/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.modules.LocalModuleLoader;
import org.jboss.modules.ModuleLoader;

final class DefaultModuleLoader {
    static final ModuleLoader INSTANCE = AccessController.doPrivileged(new PrivilegedAction<ModuleLoader>(){

        @Override
        public ModuleLoader run() {
            String modulePath = System.getProperty("module.path");
            File[] roots = modulePath == null ? new File[]{} : DefaultModuleLoader.getFiles(modulePath, 0, 0);
            return new LocalModuleLoader("default", roots);
        }
    });

    private DefaultModuleLoader() {
    }

    private static File[] getFiles(String modulePath, int stringIdx, int arrayIdx) {
        File[] files;
        int i = modulePath.indexOf(File.pathSeparatorChar, stringIdx);
        if (i == -1) {
            files = new File[arrayIdx + 1];
            files[arrayIdx] = new File(modulePath.substring(stringIdx)).getAbsoluteFile();
        } else {
            files = DefaultModuleLoader.getFiles(modulePath, i + 1, arrayIdx + 1);
            files[arrayIdx] = new File(modulePath.substring(stringIdx, i)).getAbsoluteFile();
        }
        return files;
    }
}

