/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins.factory;

import java.util.Map;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.factory.AbstractBeanFactory;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.logging.Logger;

public class GenericBeanFactory
extends AbstractBeanFactory
implements KernelControllerContextAware {
    private static final Logger log = Logger.getLogger(GenericBeanFactory.class);
    protected KernelControllerContext context;

    public GenericBeanFactory(KernelConfigurator configurator) {
        super(configurator);
    }

    public Object createBean() throws Throwable {
        ClassLoader cl = null;
        if (this.classLoader == null && this.context != null) {
            try {
                cl = this.context.getClassLoader();
            }
            catch (Throwable t) {
                log.trace((Object)("Unable to retrieve classloader from " + this.context));
            }
        }
        if (cl == null) {
            cl = Configurator.getClassLoader(this.classLoader);
        }
        BeanInfo info = null;
        if (this.bean != null) {
            info = this.configurator.getBeanInfo(this.bean, cl, this.accessMode);
        }
        Joinpoint joinpoint = this.configurator.getConstructorJoinPoint(info, this.constructor, null);
        Object result = joinpoint.dispatch();
        if (info == null && result != null) {
            info = this.configurator.getBeanInfo(result.getClass(), this.accessMode);
        }
        if (this.properties != null && this.properties.size() > 0) {
            for (Map.Entry entry : this.properties.entrySet()) {
                String property = (String)entry.getKey();
                ValueMetaData vmd = (ValueMetaData)entry.getValue();
                PropertyInfo pi = info.getProperty(property);
                pi.set(result, vmd.getValue(pi.getType(), cl));
            }
        }
        this.invokeLifecycle("create", this.create, info, cl, result);
        this.invokeLifecycle("start", this.start, info, cl, result);
        return result;
    }

    public void setKernelControllerContext(KernelControllerContext context) throws Exception {
        this.context = context;
    }

    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
        this.context = null;
    }
}

