/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.jboss.beans.metadata.api.model.AutowireType;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.beans.metadata.api.model.InjectOption;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.TypeProvider;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.dependency.plugins.AttributeCallbackItem;
import org.jboss.dependency.spi.CallbackItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.dependency.spi.dispatch.AttributeDispatchContext;
import org.jboss.kernel.plugins.dependency.ClassContextDependencyItem;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

@XmlType
public class AbstractInjectionValueMetaData
extends AbstractDependencyValueMetaData {
    private static final long serialVersionUID = 3L;
    protected AutowireType injectionType = AutowireType.BY_CLASS;
    protected InjectOption injectionOption = InjectOption.STRICT;
    protected FromContext fromContext;
    protected AbstractPropertyMetaData propertyMetaData;

    public AbstractInjectionValueMetaData() {
    }

    public AbstractInjectionValueMetaData(Object value) {
        super(value);
    }

    public AbstractInjectionValueMetaData(Object value, String property) {
        super(value, property);
    }

    public AutowireType getInjectionType() {
        return this.injectionType;
    }

    @XmlAttribute(name="type")
    public void setInjectionType(AutowireType injectionType) {
        this.injectionType = injectionType;
    }

    public InjectOption getInjectionOption() {
        return this.injectionOption;
    }

    @XmlAttribute(name="option")
    public void setInjectionOption(InjectOption injectionOption) {
        this.injectionOption = injectionOption;
    }

    public FromContext getFromContext() {
        return this.fromContext;
    }

    @XmlAttribute(name="fromContext")
    public void setFromContext(FromContext fromContext) {
        this.fromContext = fromContext;
    }

    public AbstractPropertyMetaData getPropertyMetaData() {
        return this.propertyMetaData;
    }

    @XmlTransient
    public void setPropertyMetaData(AbstractPropertyMetaData propertyMetaData) {
        this.propertyMetaData = propertyMetaData;
    }

    protected void addInstallItem(Object name) {
        if (this.propertyMetaData == null) {
            throw new IllegalArgumentException("Illegal usage of option Callback - injection not used with property = " + this);
        }
        this.context.getDependencyInfo().addInstallItem((CallbackItem)new AttributeCallbackItem(name, this.whenRequiredState, this.dependentState, (AttributeDispatchContext)this.context, this.propertyMetaData.getName()));
    }

    protected boolean isLookupValid(ControllerContext lookup) {
        boolean lookupExists = super.isLookupValid(lookup);
        boolean isCallback = InjectOption.CALLBACK.equals((Object)this.injectionOption);
        if (!lookupExists && isCallback) {
            this.addInstallItem(this.getUnderlyingValue());
        }
        return lookupExists || isCallback;
    }

    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        if (this.fromContext != null) {
            Controller controller;
            ControllerContext lookup;
            ControllerState state = this.dependentState;
            if (state == null) {
                state = ControllerState.INSTANTIATED;
            }
            if ((lookup = (controller = this.context.getController()).getContext(this.getUnderlyingValue(), state)) == null) {
                throw new Error("Should not be here - dependency failed - " + this);
            }
            return this.fromContext.executeLookup(lookup);
        }
        if (this.getUnderlyingValue() == null) {
            Controller controller = this.context.getController();
            ControllerContext lookup = controller.getInstalledContext((Object)info.getType());
            if (lookup == null) {
                if (InjectOption.STRICT.equals((Object)this.injectionOption)) {
                    throw new IllegalArgumentException("Possible multiple matching beans, see log for info.");
                }
                this.addInstallItem(info.getType());
                return null;
            }
            return lookup.getTarget();
        }
        return super.getValue(info, cl);
    }

    protected boolean addDependencyItem() {
        return InjectOption.STRICT.equals((Object)this.injectionOption) || this.fromContext != null;
    }

    public Object getUnderlyingValue() {
        Object original = super.getUnderlyingValue();
        return this.fromContext != null && original == null ? (this.context != null ? this.context.getName() : null) : original;
    }

    public void initialVisit(MetaDataVisitor visitor) {
        if (this.fromContext != null) {
            if (super.getUnderlyingValue() == null && this.dependentState == null) {
                this.dependentState = this.fromContext.getWhenValid();
            }
            super.initialVisit(visitor);
            return;
        }
        if (this.getUnderlyingValue() == null) {
            if (this.property != null) {
                this.property = null;
                this.log.warn((Object)("Ignoring property - contextual injection: " + this));
            }
            if (AutowireType.BY_NAME.equals((Object)this.injectionType)) {
                if (this.propertyMetaData == null) {
                    throw new IllegalArgumentException("Illegal usage of type ByName - injection not used with property = " + this);
                }
                this.setValue(this.propertyMetaData.getName());
            } else {
                visitor.initialVisit(this);
            }
        }
        if (this.getUnderlyingValue() != null) {
            super.initialVisit(visitor);
        }
    }

    public void describeVisit(MetaDataVisitor visitor) {
        block12: {
            if (this.getUnderlyingValue() == null) {
                if (AutowireType.BY_CLASS.equals((Object)this.injectionType)) {
                    this.context = visitor.getControllerContext();
                    if (InjectOption.STRICT.equals((Object)this.injectionOption)) {
                        MetaDataVisitorNode node = visitor.visitorNodeStack().pop();
                        try {
                            if (node instanceof TypeProvider) {
                                TypeProvider typeProvider = (TypeProvider)((Object)node);
                                Class injectionClass = typeProvider.getType(visitor, this).getType();
                                this.log.debug((Object)(this.context.getName() + ": Contextual injection usage (class -> classloader): " + injectionClass + " -> " + injectionClass.getClassLoader() + " defined by " + node));
                                ControllerState whenRequired = this.whenRequiredState;
                                if (whenRequired == null) {
                                    whenRequired = visitor.getContextState();
                                }
                                ClassContextDependencyItem item = new ClassContextDependencyItem(this.context.getName(), injectionClass, whenRequired, this.dependentState);
                                visitor.addDependency((DependencyItem)item);
                                break block12;
                            }
                            throw new Error("Node not of TypeProvider instance, cannot determine type info.");
                        }
                        catch (Error error) {
                            throw error;
                        }
                        catch (Throwable throwable) {
                            throw new Error(throwable);
                        }
                        finally {
                            visitor.visitorNodeStack().push(node);
                        }
                    }
                } else {
                    throw new IllegalArgumentException("Unknown injection type=" + (Object)((Object)this.injectionType));
                }
            }
        }
        super.describeVisit(visitor);
    }

    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        if (this.injectionType != null) {
            buffer.append(" injectionType=").append((Object)this.injectionType);
        }
        if (this.propertyMetaData != null) {
            buffer.append(" propertyMetaData=").append(this.propertyMetaData.getName());
        }
        if (this.fromContext != null) {
            buffer.append(" fromContext=").append((Object)this.fromContext);
        }
    }

    public AbstractInjectionValueMetaData clone() {
        return (AbstractInjectionValueMetaData)super.clone();
    }
}

