/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metadata.serviceref;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.jws.HandlerChain;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import javax.xml.ws.soap.MTOM;

import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.jboss.CallPropertyMetaData;
import org.jboss.metadata.javaee.jboss.JBossPortComponentRef;
import org.jboss.metadata.javaee.jboss.JBossServiceReferenceMetaData;
import org.jboss.metadata.javaee.jboss.StubPropertyMetaData;
import org.jboss.metadata.javaee.spec.Addressing;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.PortComponentRef;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.javaee.spec.RespectBinding;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainsMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlersMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.util.naming.Util;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefHandler;
import org.jboss.wsf.spi.serviceref.ServiceRefHandler.Type;
import org.jboss.wsf.spi.serviceref.ServiceRefHandlerFactory;

/**
 * Utility to bind service references to JNDI
 * @Deprecated This class will be removed once switchboard/jboss-injection is in place.
 * 
 * @author Thomas.Diesler@jboss.org
 * @author <a href="mailto:ropalka@redhat.com">Richard Opalka</a>
 */
@Deprecated
public final class ServiceReferenceHandler
{
   private static final Logger log = Logger.getLogger(ServiceReferenceHandler.class);

   private ServiceRefHandler delegate;

   public ServiceReferenceHandler()
   {
      if (delegate == null)
      {
         SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
         delegate = spiProvider.getSPI(ServiceRefHandlerFactory.class).getServiceRefHandler();
      }
   }

   public void bindServiceRef(Context encCtx, String encName, UnifiedVirtualFile vfsRoot, ClassLoader loader, ServiceReferenceMetaData sref) throws NamingException
   {
      if (!sref.isProcessed())
      {
         final UnifiedServiceRefMetaData spiRef = getUnifiedServiceRefMetaData(vfsRoot, sref, loader);
         this.processType(spiRef);
         final Referenceable jndiReferenceable = delegate.createReferenceable(spiRef);
         final String jndiFullName = encCtx.getNameInNamespace() + "/" + encName;
         log.info("Binding service reference to [jndi=" + jndiFullName + "]");
         Util.bind(encCtx, encName, jndiReferenceable);
         sref.setProcessed(true);
      }
   }

   private void processAnnotatedElement(final AnnotatedElement anElement, final UnifiedServiceRefMetaData serviceRefMD)
   {
      this.processAddressingAnnotation(anElement, serviceRefMD);
      this.processMTOMAnnotation(anElement, serviceRefMD);
      this.processRespectBindingAnnotation(anElement, serviceRefMD);
      this.processHandlerChainAnnotation(anElement, serviceRefMD);
      this.processServiceRefType(anElement, serviceRefMD);
   }

   // TODO: use classloader to detect service ref type
   private void processType(final UnifiedServiceRefMetaData serviceRefMD)
   {
      final boolean isJAXRPC = serviceRefMD.getMappingFile() != null // TODO: is mappingFile check required?
            || "javax.xml.rpc.Service".equals(serviceRefMD.getServiceInterface());

      serviceRefMD.setType(isJAXRPC ? Type.JAXRPC : Type.JAXWS);
   }

   private UnifiedServiceRefMetaData getUnifiedServiceRefMetaData(UnifiedVirtualFile vfsRoot, ServiceReferenceMetaData sref, ClassLoader loader)
   {
      UnifiedServiceRefMetaData result = new UnifiedServiceRefMetaData(vfsRoot);
      result.setServiceRefName(sref.getName());
      result.setServiceRefType(sref.getServiceRefType());
      result.setServiceInterface(sref.getServiceInterface());
      result.setWsdlFile(sref.getWsdlFile());
      result.setMappingFile(sref.getJaxrpcMappingFile());
      result.setServiceQName(sref.getServiceQname());
      result.setAddressingAnnotationSpecified(sref.isAddressingAnnotationSpecified());
      result.setAddressingEnabled(sref.isAddressingEnabled());
      result.setAddressingRequired(sref.isAddressingRequired());
      result.setAddressingResponses(sref.getAddressingResponses());
      result.setMtomAnnotationSpecified(sref.isMtomAnnotationSpecified());
      result.setMtomEnabled(sref.isMtomEnabled());
      result.setMtomThreshold(sref.getMtomThreshold());
      result.setRespectBindingAnnotationSpecified(sref.isRespectBindingAnnotationSpecified());
      result.setRespectBindingEnabled(sref.isRespectBindingEnabled());
      result.setHandlerChain(sref.getHandlerChain());

      if (sref.getInjectionTargets() != null && sref.getInjectionTargets().size() > 0)
      {
         if (sref.getInjectionTargets().size() > 1) throw new UnsupportedOperationException("What to do in such case?");
         final ResourceInjectionTargetMetaData injectionTarget = sref.getInjectionTargets().iterator().next();
         
         AccessibleObject anAlement = this.findInjectionTarget(loader, injectionTarget);
         this.processAnnotatedElement(anAlement, result);
      }

      List<? extends PortComponentRef> pcRefs = sref.getPortComponentRef();
      if (pcRefs != null)
      {
         for (PortComponentRef pcRef : pcRefs)
         {
            UnifiedPortComponentRefMetaData upcRef = getUnifiedPortComponentRefMetaData(result, pcRef);
            if (upcRef.getServiceEndpointInterface() != null || upcRef.getPortQName() != null)
               result.addPortComponentRef(upcRef);
            else
               log.warn("Ignore <port-component-ref> without <service-endpoint-interface> and <port-qname>: " + upcRef);
         }
      }

      ServiceReferenceHandlersMetaData srHandlers = sref.getHandlers();
      if (srHandlers != null)
      {
         Iterator<ServiceReferenceHandlerMetaData> it = srHandlers.iterator();
         while (it.hasNext())
         {
            ServiceReferenceHandlerMetaData srHandlerMetaData = it.next();
            UnifiedHandlerMetaData uHandlerMetaData = getUnifiedHandlerMetaData(srHandlerMetaData);
            result.addHandler(uHandlerMetaData);
         }
      }

      ServiceReferenceHandlerChainsMetaData srHandlerChains = sref.getHandlerChains();
      if (srHandlerChains != null)
      {
         UnifiedHandlerChainsMetaData uHandlerChains = new UnifiedHandlerChainsMetaData();
         List<ServiceReferenceHandlerChainMetaData> srHandlerChainList = srHandlerChains.getHandlers();
         for (ServiceReferenceHandlerChainMetaData srHandlerChain : srHandlerChainList)
         {
            UnifiedHandlerChainMetaData uHandlerChain = new UnifiedHandlerChainMetaData();
            uHandlerChain.setServiceNamePattern(srHandlerChain.getServiceNamePattern());
            uHandlerChain.setPortNamePattern(srHandlerChain.getPortNamePattern());
            uHandlerChain.setProtocolBindings(srHandlerChain.getProtocolBindings());
            List<ServiceReferenceHandlerMetaData> srHandlerChainHandlers = srHandlerChain.getHandler();
            Iterator<ServiceReferenceHandlerMetaData> it = srHandlerChainHandlers.iterator();
            while (it.hasNext())
            {
               ServiceReferenceHandlerMetaData srHandlerMetaData = it.next();
               UnifiedHandlerMetaData uHandlerMetaData = getUnifiedHandlerMetaData(srHandlerMetaData);
               uHandlerChain.addHandler(uHandlerMetaData);
            }
            uHandlerChains.addHandlerChain(uHandlerChain);
         }
         result.setHandlerChains(uHandlerChains);
      }

      if (sref instanceof JBossServiceReferenceMetaData)
      {
         JBossServiceReferenceMetaData jbRef = (JBossServiceReferenceMetaData)sref;
         if (jbRef.getServiceClass() != null)
         {
            result.setServiceImplClass(jbRef.getServiceClass());
         }
         result.setConfigName(jbRef.getConfigName());
         result.setConfigFile(jbRef.getConfigFile());
         result.setWsdlOverride(jbRef.getWsdlOverride());
         result.setHandlerChain(jbRef.getHandlerChain());
      }
      
      return result;
   }

   private UnifiedHandlerMetaData getUnifiedHandlerMetaData(ServiceReferenceHandlerMetaData srhmd)
   {
      UnifiedHandlerMetaData uhmd = new UnifiedHandlerMetaData();
      uhmd.setHandlerName(srhmd.getHandlerName());
      uhmd.setHandlerClass(srhmd.getHandlerClass());
      List<ParamValueMetaData> initParams = srhmd.getInitParam();
      if (initParams != null)
      {
         for (ParamValueMetaData initParam : initParams)
         {
            UnifiedInitParamMetaData param = new UnifiedInitParamMetaData();
            param.setParamName(initParam.getParamName());
            param.setParamValue(initParam.getParamValue());
            uhmd.addInitParam(param);
         }
      }
      List<QName> soapHeaders = srhmd.getSoapHeader();
      if (soapHeaders != null)
      {
         for (QName soapHeader : soapHeaders)
         {
            uhmd.addSoapHeader(soapHeader);
         }
      }
      List<String> soapRoles = srhmd.getSoapRole();
      if (soapRoles != null)
      {
         for (String soapRole : soapRoles)
         {
            uhmd.addSoapRole(soapRole);
         }
      }
      List<String> portNames = srhmd.getPortName();
      if (portNames != null)
      {
         for (String portName : portNames)
         {
            uhmd.addPortName(portName);
         }
      }
      return uhmd;
   }

   private UnifiedPortComponentRefMetaData getUnifiedPortComponentRefMetaData(UnifiedServiceRefMetaData usref, PortComponentRef pcref)
   {
      UnifiedPortComponentRefMetaData result = new UnifiedPortComponentRefMetaData(usref);
      result.setServiceEndpointInterface(pcref.getServiceEndpointInterface());
      result.setMtomEnabled(pcref.isEnableMtom());
      result.setMtomThreshold(pcref.getMtomThreshold());
      Addressing addressing = pcref.getAddressing();
      if (addressing != null) 
      {
         result.setAddressingAnnotationSpecified(true);
         result.setAddressingEnabled(addressing.isEnabled());
         result.setAddressingRequired(addressing.isRequired());
         result.setAddressingResponses(addressing.getResponses());
      }
      RespectBinding respectBinding = pcref.getRespectBinding();
      if (respectBinding != null)
      {
         result.setRespectBindingAnnotationSpecified(true);
         result.setRespectBindingEnabled(respectBinding.isEnabled());
      }
      result.setPortComponentLink(pcref.getPortComponentLink());
      if (pcref instanceof JBossPortComponentRef)
      {
         JBossPortComponentRef jbpcref = (JBossPortComponentRef)pcref;
         result.setPortQName(jbpcref.getPortQname());
         result.setConfigName(jbpcref.getConfigName());
         result.setConfigFile(jbpcref.getConfigFile());
         List<StubPropertyMetaData> stubProps = jbpcref.getStubProperties();
         if (stubProps != null)
         {
            for (StubPropertyMetaData stubProp : stubProps)
            {
               UnifiedStubPropertyMetaData prop = new UnifiedStubPropertyMetaData();
               prop.setPropName(stubProp.getPropName());
               prop.setPropValue(stubProp.getPropValue());
               result.addStubProperty(prop);
            }
         }
         List<CallPropertyMetaData> callProps = jbpcref.getCallProperties();
         if (callProps != null)
         {
            for (CallPropertyMetaData callProp : callProps)
            {
               UnifiedCallPropertyMetaData prop = new UnifiedCallPropertyMetaData();
               prop.setPropName(callProp.getPropName());
               prop.setPropValue(callProp.getPropValue());
               result.addCallProperty(prop);
            }
         }
      }
      return result;
   }
   private void processAddressingAnnotation(final AnnotatedElement anElement, final UnifiedServiceRefMetaData serviceRefMD)
   {
      final javax.xml.ws.soap.Addressing addressingAnnotation = this.getAnnotation(anElement, javax.xml.ws.soap.Addressing.class);

      if (addressingAnnotation != null)
      {
         serviceRefMD.setAddressingAnnotationSpecified(true);
         serviceRefMD.setAddressingEnabled(addressingAnnotation.enabled());
         serviceRefMD.setAddressingRequired(addressingAnnotation.required());
         serviceRefMD.setAddressingResponses(addressingAnnotation.responses().toString());
      }
   }

   private void processMTOMAnnotation(final AnnotatedElement anElement, final UnifiedServiceRefMetaData serviceRefMD)
   {
      final MTOM mtomAnnotation = this.getAnnotation(anElement, MTOM.class);

      if (mtomAnnotation != null)
      {
         serviceRefMD.setMtomAnnotationSpecified(true);
         serviceRefMD.setMtomEnabled(mtomAnnotation.enabled());
         serviceRefMD.setMtomThreshold(mtomAnnotation.threshold());
      }
   }

   private void processRespectBindingAnnotation(final AnnotatedElement anElement, final UnifiedServiceRefMetaData serviceRefMD)
   {
      final javax.xml.ws.RespectBinding respectBindingAnnotation = this.getAnnotation(anElement, javax.xml.ws.RespectBinding.class);

      if (respectBindingAnnotation != null)
      {
         serviceRefMD.setRespectBindingAnnotationSpecified(true);
         serviceRefMD.setRespectBindingEnabled(respectBindingAnnotation.enabled());
      }
   }
   
   private void processServiceRefType(final AnnotatedElement anElement, final UnifiedServiceRefMetaData serviceRefMD)
   {
      if (anElement instanceof Field)
      {
         final Class<?> targetClass = ((Field) anElement).getType();
         serviceRefMD.setServiceRefType(targetClass.getName());
         
         if (Service.class.isAssignableFrom(targetClass))
            serviceRefMD.setServiceInterface(targetClass.getName());
      }
      else if (anElement instanceof Method)
      {
         final Class<?> targetClass = ((Method) anElement).getParameterTypes()[0];
         serviceRefMD.setServiceRefType(targetClass.getName());

         if (Service.class.isAssignableFrom(targetClass))
            serviceRefMD.setServiceInterface(targetClass.getName());
      }
      else
      {
         final WebServiceRef serviceRefAnnotation = this.getWebServiceRefAnnotation(anElement, serviceRefMD);
         Class<?> targetClass = null;
         if (serviceRefAnnotation != null && (serviceRefAnnotation.type() != Object.class))
         {
            targetClass = serviceRefAnnotation.type();
            serviceRefMD.setServiceRefType(targetClass.getName());

            if (Service.class.isAssignableFrom(targetClass))
               serviceRefMD.setServiceInterface(targetClass.getName());
         }
      }
   }

   private void processHandlerChainAnnotation(final AnnotatedElement anElement, final UnifiedServiceRefMetaData serviceRefMD)
   {
      final HandlerChain handlerChainAnnotation = this.getAnnotation(anElement, HandlerChain.class);

      if (handlerChainAnnotation != null)
      {
         // Set the handlerChain from @HandlerChain on the annotated element
         String handlerChain = null;
         if (handlerChainAnnotation.file().length() > 0)
            handlerChain = handlerChainAnnotation.file();

         // Resolve path to handler chain
         if (handlerChain != null)
         {
            try
            {
               new URL(handlerChain);
            }
            catch (MalformedURLException ignored)
            {
               final Class<?> declaringClass = getDeclaringClass(anElement);

               handlerChain = declaringClass.getPackage().getName().replace('.', '/') + "/" + handlerChain;
            }

            serviceRefMD.setHandlerChain(handlerChain);
         }
      }
   }

   private Class<?> getDeclaringClass(final AnnotatedElement annotatedElement)
   {
      Class<?> declaringClass = null;
      if (annotatedElement instanceof Field)
         declaringClass = ((Field) annotatedElement).getDeclaringClass();
      else if (annotatedElement instanceof Method)
         declaringClass = ((Method) annotatedElement).getDeclaringClass();
      else if (annotatedElement instanceof Class)
         declaringClass = (Class<?>) annotatedElement;

      return declaringClass;
   }

   private <T extends Annotation> T getAnnotation(final AnnotatedElement anElement, final Class<T> annotationClass)
   {
      return anElement != null ? (T) anElement.getAnnotation(annotationClass) : null;
   }

   private WebServiceRef getWebServiceRefAnnotation(final AnnotatedElement anElement, final UnifiedServiceRefMetaData serviceRefMD)
   {
      final WebServiceRef webServiceRefAnnotation = this.getAnnotation(anElement, WebServiceRef.class);
      final WebServiceRefs webServiceRefsAnnotation = this.getAnnotation(anElement, WebServiceRefs.class);

      if (webServiceRefAnnotation == null && webServiceRefsAnnotation == null)
      {
         return null;
      }

      // Build the list of @WebServiceRef relevant annotations
      final List<WebServiceRef> wsrefList = new ArrayList<WebServiceRef>();

      if (webServiceRefAnnotation != null)
      {
         wsrefList.add(webServiceRefAnnotation);
      }

      if (webServiceRefsAnnotation != null)
      {
         for (final WebServiceRef webServiceRefAnn : webServiceRefsAnnotation.value())
         {
            wsrefList.add(webServiceRefAnn);
         }
      }

      // Return effective @WebServiceRef annotation
      WebServiceRef returnValue = null;
      if (wsrefList.size() == 1)
      {
         returnValue = wsrefList.get(0);
      }
      else
      {
         for (WebServiceRef webServiceRefAnn : wsrefList)
         {
            if (serviceRefMD.getServiceRefName().endsWith(webServiceRefAnn.name()))
            {
               returnValue = webServiceRefAnn;
               break;
            }
         }
      }

      return returnValue;
   }

   private AccessibleObject findInjectionTarget(ClassLoader loader, ResourceInjectionTargetMetaData target)
   {
      Class<?> clazz = null;
      try
      {
         clazz = loader.loadClass(target.getInjectionTargetClass());
      }
      catch (ClassNotFoundException e)
      {
         throw new RuntimeException("<injection-target> class: " + target.getInjectionTargetClass() + " was not found in deployment");
      }

      for (Field field : clazz.getDeclaredFields())
      {
         if (target.getInjectionTargetName().equals(field.getName())) return field;
      }

      for (Method method : clazz.getDeclaredMethods())
      {
         if (method.getName().equals(target.getInjectionTargetName())) return method;
      }

      throw new RuntimeException("<injection-target> could not be found: " + target.getInjectionTargetClass() + "." + target.getInjectionTargetName());

   }
   
}
