/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class UnlockedHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 512;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.6f;
    private static final Object[] RESIZED = new Object[0];
    private static final Object NONEXISTENT = new Object();
    private volatile Table<K, V> table;
    private final Set<K> keySet = new KeySet();
    private final Set<Map.Entry<K, V>> entrySet = new EntrySet();
    private final Collection<V> values = new Values();
    private final float loadFactor;
    private final int initialCapacity;
    private static final AtomicIntegerFieldUpdater<Table> sizeUpdater = AtomicIntegerFieldUpdater.newUpdater(Table.class, "size");
    private static final AtomicReferenceFieldUpdater<UnlockedHashMap, Table> tableUpdater = AtomicReferenceFieldUpdater.newUpdater(UnlockedHashMap.class, Table.class, "table");
    private static final AtomicReferenceFieldUpdater<Item, Object> valueUpdater = AtomicReferenceFieldUpdater.newUpdater(Item.class, Object.class, "value");

    public UnlockedHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity must be > 0");
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((double)loadFactor <= 0.0 || Float.isNaN(loadFactor) || (double)loadFactor >= 1.0) {
            throw new IllegalArgumentException("Load factor must be between 0.0f and 1.0f");
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.initialCapacity = capacity;
        Table table = new Table(capacity, loadFactor);
        tableUpdater.set(this, table);
    }

    public UnlockedHashMap(float loadFactor) {
        this(512, loadFactor);
    }

    public UnlockedHashMap(int initialCapacity) {
        this(initialCapacity, 0.6f);
    }

    public UnlockedHashMap() {
        this(512, 0.6f);
    }

    private Item<K, V>[] addItem(Item<K, V>[] row, Item<K, V> newItem) {
        if (row == null) {
            return UnlockedHashMap.createRow(newItem);
        }
        int length = row.length;
        Item<K, V>[] newRow = Arrays.copyOf(row, length + 1);
        newRow[length] = newItem;
        return newRow;
    }

    private static <K, V> Item<K, V>[] createRow(Item<K, V> newItem) {
        return new Item[]{newItem};
    }

    private static <K, V> Item<K, V>[] createRow(int length) {
        return new Item[length];
    }

    private V doPut(K key, V value, boolean ifAbsent, Table<K, V> table) {
        int hashCode = UnlockedHashMap.hashCode(key);
        AtomicReferenceArray<Item<K, V>[]> array = table.array;
        int idx = hashCode & array.length() - 1;
        block0: while (true) {
            Item<K, V> newItem;
            Item<K, V>[] newRow;
            Item<K, V>[] oldRow;
            if ((oldRow = array.get(idx)) == RESIZED) {
                V result = this.doPut(key, value, ifAbsent, table.resizeView);
                if (result == NONEXISTENT) {
                    sizeUpdater.getAndIncrement(table);
                }
                return result;
            }
            if (oldRow != null) {
                Item oldItem = null;
                for (Item tryItem : oldRow) {
                    if (key != tryItem.key) continue;
                    oldItem = tryItem;
                    break;
                }
                if (oldItem != null) {
                    Object oldItemValue;
                    do {
                        if ((oldItemValue = oldItem.value) == NONEXISTENT) continue block0;
                    } while (!ifAbsent && !valueUpdater.compareAndSet(oldItem, oldItemValue, value));
                    return oldItemValue;
                }
            }
            if (array.compareAndSet(idx, oldRow, newRow = this.addItem(oldRow, newItem = new Item<K, V>(key, hashCode, value)))) break;
        }
        int threshold = table.threshold;
        int newSize = sizeUpdater.incrementAndGet(table);
        while (newSize >= 0 && (newSize & Integer.MAX_VALUE) > threshold) {
            if (!sizeUpdater.compareAndSet(table, newSize, newSize | Integer.MIN_VALUE)) continue;
            this.resize(table);
            return UnlockedHashMap.nonexistent();
        }
        return UnlockedHashMap.nonexistent();
    }

    private static int hashCode(Object key) {
        int h = key == null ? 0 : System.identityHashCode(key);
        return h - (h << 7);
    }

    private void resize(Table<K, V> origTable) {
        int size;
        AtomicReferenceArray<Item<K, V>[]> origArray = origTable.array;
        int origCapacity = origArray.length();
        Table newTable = new Table(origCapacity << 1, this.loadFactor);
        newTable.size = Integer.MIN_VALUE;
        origTable.resizeView = newTable;
        AtomicReferenceArray<Item<K, V>[]> newArray = newTable.array;
        for (int i = 0; i < origCapacity; ++i) {
            Item<K, V>[] origRow;
            Item<K, V>[] newRow0 = null;
            Item<K, V>[] newRow1 = null;
            do {
                if ((origRow = origArray.get(i)) == null) continue;
                int count0 = 0;
                int count1 = 0;
                for (Item item : origRow) {
                    if ((item.hashCode & origCapacity) == 0) {
                        ++count0;
                        continue;
                    }
                    ++count1;
                }
                if (count0 != 0) {
                    newRow0 = UnlockedHashMap.createRow(count0);
                    int j = 0;
                    for (Item item : origRow) {
                        if ((item.hashCode & origCapacity) != 0) continue;
                        newRow0[j++] = item;
                    }
                    newArray.lazySet(i, newRow0);
                }
                if (count1 == 0) continue;
                newRow1 = UnlockedHashMap.createRow(count1);
                int j = 0;
                for (Item item : origRow) {
                    if ((item.hashCode & origCapacity) == 0) continue;
                    newRow1[j++] = item;
                }
                newArray.lazySet(i + origCapacity, newRow1);
            } while (!origArray.compareAndSet(i, origRow, UnlockedHashMap.resized()));
            sizeUpdater.getAndAdd(newTable, origRow.length);
        }
        do {
            if (((size = newTable.size) & Integer.MAX_VALUE) < newTable.threshold) continue;
            this.table = newTable;
            this.resize(newTable);
            return;
        } while (!sizeUpdater.compareAndSet(newTable, size, size & Integer.MAX_VALUE));
        this.table = newTable;
    }

    private static <K, V> Item<K, V>[] remove(Item<K, V>[] row, int idx) {
        int len = row.length;
        assert (idx < len);
        if (len == 1) {
            return null;
        }
        Item[] newRow = new Item[len - 1];
        if (idx > 0) {
            System.arraycopy(row, 0, newRow, 0, idx);
        }
        if (idx < len - 1) {
            System.arraycopy(row, idx + 1, newRow, idx, len - 1 - idx);
        }
        return newRow;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V result = this.doPut(key, value, true, this.table);
        return result == NONEXISTENT ? null : (V)result;
    }

    @Override
    public boolean remove(Object objectKey, Object objectValue) {
        Object key = objectKey;
        Object value = objectValue;
        return this.doRemove(key, value, this.table);
    }

    private boolean doRemove(Item<K, V> item, Table<K, V> table) {
        int rowIdx;
        Item<K, V>[] oldRow;
        int hashCode = ((Item)item).hashCode;
        AtomicReferenceArray<Item<K, V>[]> array = table.array;
        int idx = hashCode & array.length() - 1;
        do {
            if ((oldRow = array.get(idx)) == null) {
                return false;
            }
            if (oldRow == RESIZED) {
                Object result = this.doRemove((K)item, table.resizeView);
                if (result != false) {
                    sizeUpdater.getAndDecrement(table);
                }
                return (boolean)result;
            }
            rowIdx = -1;
            for (int i = 0; i < oldRow.length; ++i) {
                if (item != oldRow[i]) continue;
                rowIdx = i;
                break;
            }
            if (rowIdx != -1) continue;
            return false;
        } while (!array.compareAndSet(idx, oldRow, UnlockedHashMap.remove(oldRow, rowIdx)));
        sizeUpdater.getAndDecrement(table);
        return true;
    }

    private boolean doRemove(K key, V value, Table<K, V> table) {
        AtomicReferenceArray<Item<K, V>[]> array = table.array;
        int hashCode = UnlockedHashMap.hashCode(key);
        int idx = hashCode & array.length() - 1;
        Item<K, V>[] oldRow = array.get(idx);
        if (oldRow == null) {
            return false;
        }
        if (oldRow == RESIZED) {
            boolean result = this.doRemove(key, value, table.resizeView);
            if (result) {
                sizeUpdater.getAndDecrement(table);
            }
            return result;
        }
        Item oldItem = null;
        Object oldValue = null;
        int rowIdx = -1;
        for (int i = 0; i < oldRow.length; ++i) {
            Item tryItem = oldRow[i];
            if (key != tryItem.key) continue;
            Object v = tryItem.value;
            oldValue = v;
            Object v2 = v;
            if (value == v2) {
                oldItem = tryItem;
                rowIdx = i;
                break;
            }
            return false;
        }
        if (oldItem == null) {
            return false;
        }
        if (!valueUpdater.compareAndSet(oldItem, oldValue, NONEXISTENT)) {
            return false;
        }
        if (array.compareAndSet(idx, oldRow, UnlockedHashMap.remove(oldRow, rowIdx))) {
            sizeUpdater.decrementAndGet(table);
            return true;
        }
        return (boolean)this.doRemove((K)oldItem, table);
    }

    @Override
    public V remove(Object objectKey) {
        V result = this.doRemove(objectKey, this.table);
        return result == NONEXISTENT ? null : (V)result;
    }

    private V doRemove(K key, Table<K, V> table) {
        AtomicReferenceArray<Item<K, V>[]> array = table.array;
        int hashCode = UnlockedHashMap.hashCode(key);
        int idx = hashCode & array.length() - 1;
        Item<K, V>[] oldRow = array.get(idx);
        if (oldRow == null) {
            return UnlockedHashMap.nonexistent();
        }
        if (oldRow == RESIZED) {
            Object result = this.doRemove(key, table.resizeView);
            if (result != NONEXISTENT) {
                sizeUpdater.getAndDecrement(table);
            }
            return result;
        }
        Item oldItem = null;
        int rowIdx = -1;
        for (int i = 0; i < oldRow.length; ++i) {
            Item tryItem = oldRow[i];
            if (key != tryItem.key) continue;
            oldItem = tryItem;
            rowIdx = i;
            break;
        }
        if (oldItem == null) {
            return UnlockedHashMap.nonexistent();
        }
        Object oldValue = valueUpdater.getAndSet(oldItem, NONEXISTENT);
        if (oldValue == NONEXISTENT) {
            return UnlockedHashMap.nonexistent();
        }
        if (array.compareAndSet(idx, oldRow, UnlockedHashMap.remove(oldRow, rowIdx))) {
            sizeUpdater.decrementAndGet(table);
            return (V)oldValue;
        }
        V result = this.doRemove((K)oldItem, table);
        assert (result != false);
        return (V)oldValue;
    }

    private static <V> V nonexistent() {
        return (V)NONEXISTENT;
    }

    private static <K, V> Item<K, V>[] resized() {
        return (Item[])RESIZED;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.doReplace(key, oldValue, newValue, this.table);
    }

    private boolean doReplace(K key, V oldValue, V newValue, Table<K, V> table) {
        AtomicReferenceArray<Item<K, V>[]> array = table.array;
        int hashCode = UnlockedHashMap.hashCode(key);
        int idx = hashCode & array.length() - 1;
        Item<K, V>[] oldRow = array.get(idx);
        if (oldRow == null) {
            return false;
        }
        if (oldRow == RESIZED) {
            return this.doReplace(key, oldValue, newValue, table.resizeView);
        }
        Item oldItem = null;
        Object oldRowValue = null;
        for (Item tryItem : oldRow) {
            if (key != tryItem.key) continue;
            Object v = tryItem.value;
            oldRowValue = v;
            Object v2 = v;
            if (oldValue == v2) {
                oldItem = tryItem;
                break;
            }
            return false;
        }
        if (oldItem == null) {
            return false;
        }
        return valueUpdater.compareAndSet(oldItem, oldRowValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        V result = this.doReplace(key, value, this.table);
        return result == NONEXISTENT ? null : (V)result;
    }

    private V doReplace(K key, V value, Table<K, V> table) {
        AtomicReferenceArray<Item<K, V>[]> array = table.array;
        int hashCode = UnlockedHashMap.hashCode(key);
        int idx = hashCode & array.length() - 1;
        Item<K, V>[] oldRow = array.get(idx);
        if (oldRow == null) {
            return UnlockedHashMap.nonexistent();
        }
        if (oldRow == RESIZED) {
            return this.doReplace(key, value, table.resizeView);
        }
        Item oldItem = null;
        for (Item tryItem : oldRow) {
            if (key != tryItem.key) continue;
            oldItem = tryItem;
            break;
        }
        if (oldItem == null) {
            return UnlockedHashMap.nonexistent();
        }
        Object oldRowValue = valueUpdater.getAndSet(oldItem, value);
        if (oldRowValue == NONEXISTENT) {
            return UnlockedHashMap.nonexistent();
        }
        return (V)oldRowValue;
    }

    @Override
    public int size() {
        return this.table.size & Integer.MAX_VALUE;
    }

    private V doGet(Table<K, V> table, K key) {
        AtomicReferenceArray<Item<K, V>[]> array = table.array;
        Item<K, V>[] row = array.get(UnlockedHashMap.hashCode(key) & array.length() - 1);
        if (row != null) {
            for (Item item : row) {
                if (key != item.key) continue;
                return item.value;
            }
        }
        return UnlockedHashMap.nonexistent();
    }

    @Override
    public boolean containsKey(Object key) {
        V value = this.doGet(this.table, key);
        return value != NONEXISTENT;
    }

    @Override
    public V get(Object key) {
        V value = this.doGet(this.table, key);
        return value == NONEXISTENT ? null : (V)value;
    }

    @Override
    public V put(K key, V value) {
        V result = this.doPut(key, value, false, this.table);
        return result == NONEXISTENT ? null : (V)result;
    }

    @Override
    public void clear() {
        this.table = new Table(this.initialCapacity, this.loadFactor);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public Set<K> keySet() {
        return this.keySet;
    }

    private TableIterator createRowIterator(Table<K, V> table, int rowIdx) {
        AtomicReferenceArray<Item<K, V>[]> array = table.array;
        Item<K, V>[] row = array.get(rowIdx);
        if (row == RESIZED) {
            Table resizeView = table.resizeView;
            return new BranchIterator(this.createRowIterator(resizeView, rowIdx), this.createRowIterator(resizeView, rowIdx + array.length()));
        }
        return new RowIterator(table, row);
    }

    static /* synthetic */ boolean access$1100(UnlockedHashMap x0, Item x1, Table x2) {
        return (boolean)x0.doRemove((Object)x1, (Table)x2);
    }

    static final class Item<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final int hashCode;
        volatile V value;

        Item(K key, int hashCode, V value) {
            this.key = key;
            this.hashCode = hashCode;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            V value = this.value;
            if (value == NONEXISTENT) {
                throw new IllegalStateException("Already removed");
            }
            return value;
        }

        @Override
        public V setValue(V value) {
            V oldValue;
            do {
                if ((oldValue = this.value) != NONEXISTENT) continue;
                throw new IllegalStateException("Already removed");
            } while (!valueUpdater.compareAndSet(this, oldValue, value));
            return oldValue;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Item && this.equals((Item)obj);
        }

        public boolean equals(Item<?, ?> obj) {
            return obj != null && this.hashCode == obj.hashCode && this.key.equals(obj.key);
        }
    }

    static final class Table<K, V> {
        final AtomicReferenceArray<Item<K, V>[]> array;
        final int threshold;
        volatile int size;
        volatile Table<K, V> resizeView;

        private Table(int capacity, float loadFactor) {
            this.array = new AtomicReferenceArray(capacity);
            this.threshold = capacity == 0x40000000 ? Integer.MAX_VALUE : (int)((float)capacity * loadFactor);
        }
    }

    final class ValueIterator
    implements Iterator<V> {
        private final Table<K, V> table;
        private TableIterator tableIterator;
        private TableIterator removeIterator;
        private int tableIdx;
        private V next;

        ValueIterator() {
            this.table = UnlockedHashMap.this.table;
            this.next = UnlockedHashMap.nonexistent();
        }

        @Override
        public boolean hasNext() {
            while (this.next == NONEXISTENT) {
                if (this.tableIdx == this.table.array.length()) {
                    return false;
                }
                if (this.tableIterator == null) {
                    this.tableIterator = UnlockedHashMap.this.createRowIterator(this.table, this.tableIdx++);
                }
                this.next = this.tableIterator.nextValue();
                if (this.next != NONEXISTENT) continue;
                this.tableIterator = null;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V next() {
            if (this.hasNext()) {
                try {
                    Object v = this.next;
                    return v;
                }
                finally {
                    this.removeIterator = this.tableIterator;
                    this.next = null;
                }
            }
            throw new NoSuchElementException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            TableIterator removeIterator = this.removeIterator;
            if (removeIterator == null) {
                throw new IllegalStateException();
            }
            try {
                removeIterator.remove();
            }
            finally {
                this.removeIterator = null;
            }
        }
    }

    final class KeyIterator
    implements Iterator<K> {
        private final Table<K, V> table;
        private TableIterator tableIterator;
        private TableIterator removeIterator;
        private int tableIdx;
        private Item<K, V> next;

        KeyIterator() {
            this.table = UnlockedHashMap.this.table;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                if (this.tableIdx == this.table.array.length()) {
                    return false;
                }
                if (this.tableIterator == null) {
                    this.tableIterator = UnlockedHashMap.this.createRowIterator(this.table, this.tableIdx++);
                }
                if (this.tableIterator.hasNext()) {
                    this.next = this.tableIterator.next();
                    return true;
                }
                this.tableIterator = null;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K next() {
            if (this.hasNext()) {
                try {
                    Object object = this.next.key;
                    return object;
                }
                finally {
                    this.removeIterator = this.tableIterator;
                    this.next = null;
                }
            }
            throw new NoSuchElementException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            TableIterator removeIterator = this.removeIterator;
            if (removeIterator == null) {
                throw new IllegalStateException();
            }
            try {
                removeIterator.remove();
            }
            finally {
                this.removeIterator = null;
            }
        }
    }

    final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Table<K, V> table;
        private TableIterator tableIterator;
        private TableIterator removeIterator;
        private int tableIdx;
        private Item<K, V> next;

        EntryIterator() {
            this.table = UnlockedHashMap.this.table;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                if (this.tableIdx == this.table.array.length()) {
                    return false;
                }
                if (this.tableIterator == null) {
                    this.tableIterator = UnlockedHashMap.this.createRowIterator(this.table, this.tableIdx++);
                }
                if (this.tableIterator.hasNext()) {
                    this.next = this.tableIterator.next();
                    return true;
                }
                this.tableIterator = null;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next() {
            if (this.hasNext()) {
                try {
                    Item item = this.next;
                    return item;
                }
                finally {
                    this.removeIterator = this.tableIterator;
                    this.next = null;
                }
            }
            throw new NoSuchElementException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            TableIterator removeIterator = this.removeIterator;
            if (removeIterator == null) {
                throw new IllegalStateException();
            }
            try {
                removeIterator.remove();
            }
            finally {
                this.removeIterator = null;
            }
        }
    }

    final class BranchIterator
    extends TableIterator {
        private final TableIterator branch0;
        private final TableIterator branch1;
        private boolean branch;

        BranchIterator(TableIterator branch0, TableIterator branch1) {
            this.branch0 = branch0;
            this.branch1 = branch1;
        }

        @Override
        public boolean hasNext() {
            return this.branch0.hasNext() || this.branch1.hasNext();
        }

        @Override
        public Item<K, V> next() {
            if (this.branch) {
                return this.branch1.next();
            }
            if (this.branch0.hasNext()) {
                return this.branch0.next();
            }
            this.branch = true;
            return this.branch1.next();
        }

        @Override
        V nextValue() {
            if (this.branch) {
                return this.branch1.nextValue();
            }
            Object value = this.branch0.nextValue();
            if (value != NONEXISTENT) {
                return value;
            }
            this.branch = true;
            return this.branch1.nextValue();
        }

        @Override
        public void remove() {
            if (this.branch) {
                this.branch0.remove();
            } else {
                this.branch1.remove();
            }
        }
    }

    final class RowIterator
    extends TableIterator {
        private final Table<K, V> table;
        Item<K, V>[] row;
        private int idx;
        private Item<K, V> next;
        private Item<K, V> remove;

        RowIterator(Table<K, V> table, Item<K, V>[] row) {
            this.table = table;
            this.row = row;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                Item<K, V>[] row = this.row;
                if (row == null || this.idx == row.length) {
                    return false;
                }
                this.next = row[this.idx++];
            }
            return true;
        }

        @Override
        V nextValue() {
            Object value;
            do {
                if (this.next != null) continue;
                Item<K, V>[] row = this.row;
                if (row == null || this.idx == row.length) {
                    return UnlockedHashMap.nonexistent();
                }
                this.next = row[this.idx++];
            } while ((value = this.next.value) == NONEXISTENT);
            this.next = null;
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Item<K, V> next() {
            if (this.hasNext()) {
                try {
                    Item item = this.next;
                    return item;
                }
                finally {
                    this.remove = this.next;
                    this.next = null;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            Item remove = this.remove;
            if (remove == null) {
                throw new IllegalStateException("next() not yet called");
            }
            if (valueUpdater.getAndSet(remove, NONEXISTENT) == NONEXISTENT) {
                return;
            }
            this.remove = null;
            UnlockedHashMap.access$1100(UnlockedHashMap.this, remove, this.table);
        }
    }

    abstract class TableIterator
    implements Iterator<Map.Entry<K, V>> {
        TableIterator() {
        }

        @Override
        public abstract Item<K, V> next();

        abstract V nextValue();
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return UnlockedHashMap.this.doPut(entry.getKey(), entry.getValue(), true, UnlockedHashMap.this.table) == NONEXISTENT;
        }

        @Override
        public boolean remove(Object o) {
            return o instanceof Map.Entry && this.remove((Map.Entry)o);
        }

        public boolean remove(Map.Entry<K, V> entry) {
            return UnlockedHashMap.this.doRemove(entry.getKey(), entry.getValue(), UnlockedHashMap.this.table);
        }

        @Override
        public void clear() {
            UnlockedHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList list = new ArrayList(this.size());
            list.addAll(this);
            return list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList list = new ArrayList();
            list.addAll(this);
            return list.toArray(a);
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof Map.Entry && this.contains((Map.Entry)o);
        }

        public boolean contains(Map.Entry<K, V> entry) {
            Object tableValue = UnlockedHashMap.this.doGet(UnlockedHashMap.this.table, entry.getKey());
            Object entryValue = entry.getValue();
            return tableValue == null ? entryValue == null : tableValue.equals(entryValue);
        }

        @Override
        public int size() {
            return UnlockedHashMap.this.size();
        }
    }

    final class Values
    extends AbstractCollection<V>
    implements Collection<V> {
        Values() {
        }

        @Override
        public void clear() {
            UnlockedHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return UnlockedHashMap.this.containsValue(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public Object[] toArray() {
            ArrayList list = new ArrayList(this.size());
            list.addAll(this);
            return list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList list = new ArrayList();
            list.addAll(this);
            return list.toArray(a);
        }

        @Override
        public int size() {
            return UnlockedHashMap.this.size();
        }
    }

    final class KeySet
    extends AbstractSet<K>
    implements Set<K> {
        KeySet() {
        }

        @Override
        public void clear() {
            UnlockedHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return UnlockedHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return UnlockedHashMap.this.doRemove(o, UnlockedHashMap.this.table) != NONEXISTENT;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public Object[] toArray() {
            ArrayList list = new ArrayList(this.size());
            list.addAll(this);
            return list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList list = new ArrayList();
            list.addAll(this);
            return list.toArray(a);
        }

        @Override
        public boolean add(K k) {
            return UnlockedHashMap.this.doPut(k, null, true, UnlockedHashMap.this.table) == NONEXISTENT;
        }

        @Override
        public int size() {
            return UnlockedHashMap.this.size();
        }
    }
}

