/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serial;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.io.WriteAbortedException;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jboss.marshalling.AbstractUnmarshaller;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.UTFUtils;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.serial.BlockUnmarshaller;
import org.jboss.marshalling.serial.Descriptor;
import org.jboss.marshalling.serial.ExtendedObjectStreamConstants;
import org.jboss.marshalling.serial.NoDataDescriptor;
import org.jboss.marshalling.serial.PlainDescriptor;
import org.jboss.marshalling.serial.ProxyDescriptor;
import org.jboss.marshalling.serial.SerialMarshallerFactory;
import org.jboss.marshalling.serial.SerialObjectInputStream;
import org.jboss.marshalling.serial.UnknownDescriptor;
import org.jboss.marshalling.util.Kind;

public final class SerialUnmarshaller
extends AbstractUnmarshaller
implements Unmarshaller,
ExtendedObjectStreamConstants {
    private static final Object UNSHARED = new Object();
    private static final Object UNRESOLVED = new Object();
    private final ArrayList<Object> instanceCache;
    private final SerializableClassRegistry registry;
    private int depth = 0;
    private SerialObjectInputStream ois;
    private BlockUnmarshaller blockUnmarshaller;
    private int version;
    private static final int[] EMPTY_INTS = new int[0];
    private static final String[] EMPTY_STRINGS = new String[0];
    private final PrivilegedExceptionAction<SerialObjectInputStream> createObjectOutputStreamAction = new PrivilegedExceptionAction<SerialObjectInputStream>(){

        @Override
        public SerialObjectInputStream run() throws IOException {
            return new SerialObjectInputStream(SerialUnmarshaller.this);
        }
    };
    private final SortedMap<Integer, Set<ObjectInputValidation>> validationMap = new TreeMap(Collections.reverseOrder());

    SerialUnmarshaller(SerialMarshallerFactory factory, SerializableClassRegistry registry, MarshallingConfiguration configuration) {
        super(factory, configuration);
        this.registry = registry;
        this.instanceCache = new ArrayList(configuration.getInstanceCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doReadObject(boolean unshared) throws ClassNotFoundException, IOException {
        Object obj = this.objectPreResolver.readResolve(this.doReadObject(this.readUnsignedByte(), unshared));
        if (this.depth == 0) {
            try {
                for (Set<ObjectInputValidation> validations : this.validationMap.values()) {
                    for (ObjectInputValidation validation : validations) {
                        validation.validateObject();
                    }
                }
            }
            finally {
                this.validationMap.clear();
            }
        }
        return obj;
    }

    String doReadString() throws IOException, ClassNotFoundException {
        int leadByte = this.readUnsignedByte();
        switch (leadByte) {
            case 112: {
                return null;
            }
            case 113: {
                try {
                    return (String)this.readBackReference(this.readInt());
                }
                catch (ClassCastException e) {
                    throw new StreamCorruptedException("Expected a string backreference");
                }
            }
            case 116: {
                return (String)this.doReadObject(leadByte, false);
            }
        }
        throw new StreamCorruptedException("Expected a string object");
    }

    Object readBackReference(int handle) throws IOException {
        int idx = handle - 0x7E0000;
        if (idx < 0 || idx >= this.instanceCache.size()) {
            throw new StreamCorruptedException(String.format("Invalid backreference: %08x", handle));
        }
        Object obj = this.instanceCache.get(idx);
        if (obj == UNSHARED) {
            throw new StreamCorruptedException(String.format("Invalid backreference to unshared instance: %08x", handle));
        }
        if (obj == UNRESOLVED) {
            throw new StreamCorruptedException(String.format("Invalid backreference to unresolved instance: %08x", handle));
        }
        return obj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object doReadObject(int leadByte, boolean unshared) throws IOException, ClassNotFoundException {
        ++this.depth;
        try {
            BlockUnmarshaller blockUnmarshaller = this.blockUnmarshaller;
            block40: while (true) {
                switch (leadByte) {
                    case 112: {
                        Object var4_4 = null;
                        return var4_4;
                    }
                    case 113: {
                        Object prevObj = this.readBackReference(this.readInt());
                        if (prevObj instanceof Descriptor) {
                            throw SerialUnmarshaller.objectStreamClassException();
                        }
                        Object object = prevObj;
                        return object;
                    }
                    case 118: {
                        Descriptor descriptor = this.readNonNullClassDescriptor();
                        Class<?> obj = descriptor.getType();
                        this.instanceCache.add(obj);
                        Class<?> clazz = obj;
                        return clazz;
                    }
                    case 114: {
                        throw SerialUnmarshaller.objectStreamClassException();
                    }
                    case 125: {
                        throw SerialUnmarshaller.objectStreamClassException();
                    }
                    case 116: {
                        int len = this.readUnsignedShort();
                        String str = UTFUtils.readUTFBytesByByteCount(this, len);
                        Object object = this.replaceOrReturn(unshared, str);
                        return object;
                    }
                    case 124: {
                        long len = super.readLong();
                        String str = UTFUtils.readUTFBytesByByteCount(this, len);
                        Object object = this.replaceOrReturn(unshared, str);
                        return object;
                    }
                    case 117: {
                        Descriptor descriptor = this.readNonNullClassDescriptor();
                        int idx = this.instanceCache.size();
                        this.instanceCache.add(UNRESOLVED);
                        int size = this.readInt();
                        Class<?> type = descriptor.getType();
                        if (!type.isArray()) {
                            throw new InvalidClassException(type.getName(), "Expected array type");
                        }
                        Class<?> ct = type.getComponentType();
                        if (ct.isPrimitive()) {
                            if (ct == Byte.TYPE) {
                                byte[] bytes = new byte[size];
                                this.readFully(bytes);
                                Object object = this.replaceOrReturn(unshared, bytes, idx);
                                return object;
                            }
                            if (ct == Short.TYPE) {
                                short[] shorts = new short[size];
                                for (int i = 0; i < shorts.length; ++i) {
                                    shorts[i] = this.readShort();
                                }
                                Object i = this.replaceOrReturn(unshared, shorts, idx);
                                return i;
                            }
                            if (ct == Integer.TYPE) {
                                int[] ints = new int[size];
                                for (int i = 0; i < ints.length; ++i) {
                                    ints[i] = this.readInt();
                                }
                                Object i = this.replaceOrReturn(unshared, ints, idx);
                                return i;
                            }
                            if (ct == Long.TYPE) {
                                long[] longs = new long[size];
                                for (int i = 0; i < longs.length; ++i) {
                                    longs[i] = this.readLong();
                                }
                                Object i = this.replaceOrReturn(unshared, longs, idx);
                                return i;
                            }
                            if (ct == Float.TYPE) {
                                float[] floats = new float[size];
                                for (int i = 0; i < floats.length; ++i) {
                                    floats[i] = this.readFloat();
                                }
                                Object i = this.replaceOrReturn(unshared, floats, idx);
                                return i;
                            }
                            if (ct == Double.TYPE) {
                                double[] doubles = new double[size];
                                for (int i = 0; i < doubles.length; ++i) {
                                    doubles[i] = this.readDouble();
                                }
                                Object i = this.replaceOrReturn(unshared, doubles, idx);
                                return i;
                            }
                            if (ct == Boolean.TYPE) {
                                boolean[] booleans = new boolean[size];
                                for (int i = 0; i < booleans.length; ++i) {
                                    booleans[i] = this.readBoolean();
                                }
                                Object i = this.replaceOrReturn(unshared, booleans, idx);
                                return i;
                            }
                            if (ct != Character.TYPE) throw new InvalidClassException(type.getName(), "Invalid component type");
                            char[] chars = new char[size];
                            for (int i = 0; i < chars.length; ++i) {
                                chars[i] = this.readChar();
                            }
                            Object i = this.replaceOrReturn(unshared, chars, idx);
                            return i;
                        }
                        Object[] objects = (Object[])Array.newInstance(ct, size);
                        this.instanceCache.set(idx, objects);
                        for (int i = 0; i < objects.length; ++i) {
                            objects[i] = this.doReadObject(false);
                        }
                        Object object = this.replaceOrReturn(unshared, objects, idx);
                        return object;
                    }
                    case 126: {
                        Class<Enum> enumType;
                        Descriptor descriptor = this.readNonNullClassDescriptor();
                        try {
                            enumType = descriptor.getType().asSubclass(Enum.class);
                        }
                        catch (ClassCastException e) {
                            throw new InvalidClassException("Expected an enum class descriptor");
                        }
                        int idx = this.instanceCache.size();
                        this.instanceCache.add(UNRESOLVED);
                        String constName = (String)this.doReadObject(false);
                        Enum obj = Enum.valueOf(enumType, constName);
                        Object objects = this.replaceOrReturn(unshared, obj, idx);
                        return objects;
                    }
                    case 115: {
                        int idx;
                        Object obj;
                        Descriptor descriptor = this.readNonNullClassDescriptor();
                        if ((descriptor.getFlags() & 6) == 0) {
                            throw new NotSerializableException(descriptor.getClass().getName());
                        }
                        Class<?> objClass = descriptor.getType();
                        SerializableClass sc = this.registry.lookup(objClass);
                        if ((descriptor.getFlags() & 4) != 0) {
                            if (sc.hasObjectInputConstructor()) {
                                obj = sc.callObjectInputConstructor(blockUnmarshaller);
                            } else {
                                if (!sc.hasPublicNoArgConstructor()) throw new InvalidClassException(objClass.getName(), "Class is non-public or has no public no-arg constructor");
                                obj = sc.callNoArgConstructor();
                            }
                            idx = this.instanceCache.size();
                            this.instanceCache.add(unshared ? UNSHARED : obj);
                            if (!(obj instanceof Externalizable)) throw new InvalidObjectException("Created object should be Externalizable but it is not");
                            Externalizable externalizable = (Externalizable)obj;
                            if ((descriptor.getFlags() & 8) != 0) {
                                externalizable.readExternal(blockUnmarshaller);
                                blockUnmarshaller.readToEndBlockData();
                                blockUnmarshaller.unblock();
                            } else {
                                externalizable.readExternal(this);
                            }
                        } else if (sc.isRecord()) {
                            idx = this.instanceCache.size();
                            this.instanceCache.add(UNRESOLVED);
                            obj = this.doReadRecord(sc);
                            this.instanceCache.set(idx, unshared ? UNSHARED : obj);
                        } else {
                            Class<?> nonSerializable;
                            for (nonSerializable = objClass.getSuperclass(); this.serializabilityChecker.isSerializable(nonSerializable) && nonSerializable != Object.class; nonSerializable = nonSerializable.getSuperclass()) {
                            }
                            obj = sc.callNonInitConstructor(nonSerializable);
                            if (obj instanceof Externalizable) {
                                throw new InvalidObjectException("Created object should not be Externalizable but it is");
                            }
                            idx = this.instanceCache.size();
                            this.instanceCache.add(unshared ? UNSHARED : obj);
                            this.doReadSerialObject(descriptor, obj);
                        }
                        if (sc.hasReadResolve()) {
                            Object replacement = sc.callReadResolve(obj);
                            if (!unshared) {
                                this.instanceCache.set(idx, replacement);
                            }
                            Object object = this.replaceOrReturn(unshared, replacement, idx);
                            return object;
                        }
                        Object object = this.replaceOrReturn(unshared, obj, idx);
                        return object;
                    }
                    case 241: {
                        int idx = this.instanceCache.size();
                        this.instanceCache.add(unshared ? UNSHARED : UNRESOLVED);
                        Object obj = this.objectTable.readObject(blockUnmarshaller);
                        blockUnmarshaller.readToEndBlockData();
                        blockUnmarshaller.unblock();
                        if (!unshared) {
                            this.instanceCache.set(idx, obj);
                        }
                        Object object = obj;
                        return object;
                    }
                    case 123: {
                        this.clearInstanceCache();
                        IOException ex = (IOException)this.doReadObject(false);
                        this.clearInstanceCache();
                        throw new WriteAbortedException("Write aborted", ex);
                    }
                    case 119: 
                    case 122: {
                        blockUnmarshaller.readBlockHeader(leadByte);
                        throw Marshalling.createOptionalDataException(blockUnmarshaller.remaining());
                    }
                    case 120: {
                        throw Marshalling.createOptionalDataException(0);
                    }
                    case 121: {
                        if (this.depth > 1) {
                            throw new StreamCorruptedException("Reset token in the middle of stream processing");
                        }
                        this.clearInstanceCache();
                        leadByte = this.readByte() & 0xFF;
                        continue block40;
                    }
                }
                break;
            }
            throw this.badLeadByte(leadByte);
        }
        finally {
            --this.depth;
        }
    }

    private Object doReadRecord(SerializableClass sc) throws ClassNotFoundException, IOException {
        Object[] values = new Object[sc.getFields().length];
        block10: for (SerializableField serializableField : sc.getFields()) {
            switch (serializableField.getKind()) {
                case BOOLEAN: {
                    values[serializableField.getRecordComponentIndex()] = this.readBoolean();
                    continue block10;
                }
                case BYTE: {
                    values[serializableField.getRecordComponentIndex()] = this.readByte();
                    continue block10;
                }
                case CHAR: {
                    values[serializableField.getRecordComponentIndex()] = Character.valueOf(this.readChar());
                    continue block10;
                }
                case DOUBLE: {
                    values[serializableField.getRecordComponentIndex()] = this.readDouble();
                    continue block10;
                }
                case FLOAT: {
                    values[serializableField.getRecordComponentIndex()] = Float.valueOf(this.readFloat());
                    continue block10;
                }
                case INT: {
                    values[serializableField.getRecordComponentIndex()] = this.readInt();
                    continue block10;
                }
                case LONG: {
                    values[serializableField.getRecordComponentIndex()] = this.readLong();
                    continue block10;
                }
                case SHORT: {
                    values[serializableField.getRecordComponentIndex()] = this.readShort();
                }
            }
        }
        for (SerializableField field : sc.getFields()) {
            if (field.getKind() != Kind.OBJECT) continue;
            values[field.getRecordComponentIndex()] = this.doReadObject(field.isUnshared());
        }
        return sc.invokeRecordCanonicalConstructor(values);
    }

    private void doReadSerialObject(Descriptor descriptor, Object obj) throws ClassNotFoundException, IOException {
        Class<?> type;
        Descriptor parent = descriptor.getParent();
        if (parent != null) {
            this.doReadSerialObject(parent, obj);
        }
        descriptor.readSerial(this, (type = descriptor.getType()) == null ? null : this.registry.lookup(type), obj);
    }

    private static InvalidClassException objectStreamClassException() {
        return new InvalidClassException(ObjectStreamClass.class.getName(), "Cannot read ObjectStreamClass instances");
    }

    private Descriptor readNonNullClassDescriptor() throws ClassNotFoundException, IOException {
        Descriptor desc = this.readClassDescriptor(true);
        if (desc == null) {
            throw new StreamCorruptedException("Unexpected null class descriptor");
        }
        return desc;
    }

    private Descriptor readClassDescriptor(boolean required) throws ClassNotFoundException, IOException {
        return this.readClassDescriptor(this.readUnsignedByte(), required);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Descriptor readClassDescriptor(int leadByte, boolean required) throws IOException, ClassNotFoundException {
        blockUnmarshaller = this.blockUnmarshaller;
        switch (leadByte) {
            case 240: {
                clazz = this.classTable.readClass(blockUnmarshaller);
                idx = this.instanceCache.size();
                this.instanceCache.add(SerialUnmarshaller.UNRESOLVED);
                blockUnmarshaller.readToEndBlockData();
                blockUnmarshaller.unblock();
                descriptor = this.descriptorForClass(clazz);
                this.instanceCache.set(idx, descriptor);
                return descriptor;
            }
            case 114: {
                className = this.readUTF();
                svu = this.readLong();
                idx = this.instanceCache.size();
                this.instanceCache.add(SerialUnmarshaller.UNRESOLVED);
                descFlags = this.readUnsignedByte();
                fieldCount = this.readUnsignedShort();
                if (fieldCount == 0) {
                    typecodes = SerialUnmarshaller.EMPTY_INTS;
                    names = SerialUnmarshaller.EMPTY_STRINGS;
                    fieldSignatures = SerialUnmarshaller.EMPTY_STRINGS;
                } else {
                    typecodes = new int[fieldCount];
                    names = new String[fieldCount];
                    fieldSignatures = new String[fieldCount];
                    for (i = 0; i < fieldCount; ++i) {
                        typecodes[i] = this.readUnsignedByte();
                        names[i] = this.readUTF();
                        if (typecodes[i] != 91 && typecodes[i] != 76) continue;
                        fieldSignatures[i] = this.doReadString();
                    }
                }
                clazz = null;
                try {
                    clazz = this.classResolver.resolveClass(blockUnmarshaller, className, svu);
                }
                catch (ClassNotFoundException cnfe) {
                    if (!required) ** GOTO lbl43
                    throw cnfe;
                }
lbl43:
                // 2 sources

                blockUnmarshaller.readToEndBlockData();
                blockUnmarshaller.unblock();
                superDescr = this.readClassDescriptor(false);
                if (clazz == null) {
                    if (descFlags == 0) {
                        descriptor = superDescr;
                    } else {
                        fields = new SerializableField[fieldCount];
                        for (i = 0; i < fieldCount; ++i) {
                            switch (typecodes[i]) {
                                case 66: {
                                    fieldType /* !! */  = Byte.TYPE;
                                    break;
                                }
                                case 67: {
                                    fieldType /* !! */  = Character.TYPE;
                                    break;
                                }
                                case 68: {
                                    fieldType /* !! */  = Double.TYPE;
                                    break;
                                }
                                case 70: {
                                    fieldType /* !! */  = Float.TYPE;
                                    break;
                                }
                                case 73: {
                                    fieldType /* !! */  = Integer.TYPE;
                                    break;
                                }
                                case 74: {
                                    fieldType /* !! */  = Long.TYPE;
                                    break;
                                }
                                case 83: {
                                    fieldType /* !! */  = Short.TYPE;
                                    break;
                                }
                                case 90: {
                                    fieldType /* !! */  = Boolean.TYPE;
                                    break;
                                }
                                case 76: 
                                case 91: {
                                    fieldType /* !! */  = Object.class;
                                    break;
                                }
                                default: {
                                    throw new StreamCorruptedException("Invalid field typecode " + typecodes[i]);
                                }
                            }
                            fields[i] = new SerializableField(fieldType /* !! */ , names[i], false);
                        }
                        descriptor = new UnknownDescriptor(superDescr, fields, descFlags);
                    }
                } else {
                    superClazz = clazz.getSuperclass();
                    if (superDescr == null || superDescr.getNearestType().isAssignableFrom(superClazz)) {
                        if (descFlags == 0) {
                            descriptor = new NoDataDescriptor(clazz, this.bridge(superDescr, superClazz));
                        } else {
                            fields = new SerializableField[fieldCount];
                            sc = this.registry.lookup(clazz);
                            for (i = 0; i < fieldCount; ++i) {
                                switch (typecodes[i]) {
                                    case 66: {
                                        fieldType /* !! */  = Byte.TYPE;
                                        break;
                                    }
                                    case 67: {
                                        fieldType /* !! */  = Character.TYPE;
                                        break;
                                    }
                                    case 68: {
                                        fieldType /* !! */  = Double.TYPE;
                                        break;
                                    }
                                    case 70: {
                                        fieldType /* !! */  = Float.TYPE;
                                        break;
                                    }
                                    case 73: {
                                        fieldType /* !! */  = Integer.TYPE;
                                        break;
                                    }
                                    case 74: {
                                        fieldType /* !! */  = Long.TYPE;
                                        break;
                                    }
                                    case 83: {
                                        fieldType /* !! */  = Short.TYPE;
                                        break;
                                    }
                                    case 90: {
                                        fieldType /* !! */  = Boolean.TYPE;
                                        break;
                                    }
                                    case 76: 
                                    case 91: {
                                        fieldType /* !! */  = Object.class;
                                        break;
                                    }
                                    default: {
                                        throw new StreamCorruptedException("Invalid field typecode " + typecodes[i]);
                                    }
                                }
                                fields[i] = sc.getSerializableField(names[i], fieldType /* !! */ , false);
                            }
                            descriptor = new PlainDescriptor(clazz, this.bridge(superDescr, superClazz), fields, descFlags);
                        }
                    } else {
                        throw new InvalidClassException(clazz.getName(), "Class hierarchy mismatch");
                    }
                }
                this.instanceCache.set(idx, descriptor);
                return descriptor;
            }
            case 125: {
                idx = this.instanceCache.size();
                this.instanceCache.add(SerialUnmarshaller.UNRESOLVED);
                cnt = this.readInt();
                interfaces = new String[cnt];
                for (i = 0; i < interfaces.length; ++i) {
                    interfaces[i] = this.readUTF();
                }
                clazz = this.classResolver.resolveProxyClass(blockUnmarshaller, interfaces);
                blockUnmarshaller.readToEndBlockData();
                blockUnmarshaller.unblock();
                superDescr = this.readClassDescriptor(true);
                descr = new ProxyDescriptor(clazz, superDescr, interfaces);
                this.instanceCache.set(idx, descr);
                return descr;
            }
            case 112: {
                return null;
            }
            case 113: {
                try {
                    return (Descriptor)this.readBackReference(this.readInt());
                }
                catch (ClassCastException e) {
                    throw new StreamCorruptedException("Backreference was not a resolved class descriptor");
                }
            }
            case 123: {
                this.clearInstanceCache();
                ex = (IOException)this.doReadObject(false);
                this.clearInstanceCache();
                throw new WriteAbortedException("Write aborted", ex);
            }
        }
        throw this.badLeadByte(leadByte);
    }

    private Descriptor bridge(Descriptor descriptor, Class<?> type) {
        if (descriptor == null) {
            return null;
        }
        Class<?> superDescrClazz = descriptor.getType();
        if (superDescrClazz == null) {
            return descriptor;
        }
        Class<?> typeSuperclass = type.getSuperclass();
        if (type == superDescrClazz) {
            return descriptor;
        }
        return new NoDataDescriptor(type, this.bridge(descriptor, typeSuperclass));
    }

    private StreamCorruptedException badLeadByte(int leadByte) {
        return new StreamCorruptedException("Unexpected lead byte " + leadByte);
    }

    @Override
    public void clearInstanceCache() throws IOException {
        this.instanceCache.clear();
    }

    @Override
    public void clearClassCache() throws IOException {
        this.instanceCache.clear();
    }

    @Override
    public void start(ByteInput byteInput) throws IOException {
        this.depth = 0;
        this.blockUnmarshaller = new BlockUnmarshaller(this);
        super.start(byteInput);
        int version = this.readUnsignedShort();
        if (version > 5) {
            throw new IOException("Unsupported protocol version " + version);
        }
        this.version = version;
    }

    @Override
    public void finish() throws IOException {
        super.finish();
        this.blockUnmarshaller = null;
        this.depth = 0;
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    BlockUnmarshaller getBlockUnmarshaller() {
        return this.blockUnmarshaller;
    }

    private SerialObjectInputStream createObjectInputStream() throws IOException {
        if (System.getSecurityManager() == null) {
            return new SerialObjectInputStream(this);
        }
        try {
            return AccessController.doPrivileged(this.createObjectOutputStreamAction);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    SerialObjectInputStream getObjectInputStream() throws IOException {
        return this.ois == null ? (this.ois = this.createObjectInputStream()) : this.ois;
    }

    void addValidation(ObjectInputValidation validation, int prio) {
        Set<ObjectInputValidation> validations;
        Integer prioKey = prio;
        if (this.validationMap.containsKey(prioKey)) {
            validations = (Set)this.validationMap.get(prioKey);
        } else {
            validations = new HashSet();
            this.validationMap.put(prioKey, validations);
        }
        validations.add(validation);
    }

    public Descriptor descriptorForClass(Class<?> clazz) {
        if (Externalizable.class.isAssignableFrom(clazz)) {
            return new PlainDescriptor(clazz, null, SerializableClass.NOFIELDS, 12);
        }
        if (this.serializabilityChecker.isSerializable(clazz)) {
            Class<?> superclass = clazz.getSuperclass();
            Descriptor parent = superclass != null && this.serializabilityChecker.isSerializable(superclass) ? this.descriptorForClass(superclass) : null;
            SerializableClass serializableClass = this.registry.lookup(clazz);
            return new PlainDescriptor(clazz, parent, serializableClass.getFields(), 2 | (serializableClass.hasWriteObject() ? 1 : 0));
        }
        return new NoDataDescriptor(clazz, null);
    }

    private Object replaceOrReturn(boolean unshared, Object object) {
        int idx = this.instanceCache.size();
        this.instanceCache.add(UNSHARED);
        return this.replaceOrReturn(unshared, object, idx);
    }

    private Object replaceOrReturn(boolean unshared, Object object, int idx) {
        Object toReturn = object;
        Object replacement = this.objectResolver.readResolve(object);
        if (replacement != null && replacement != object) {
            toReturn = replacement;
        }
        if (unshared) {
            this.instanceCache.set(idx, null);
        } else {
            this.instanceCache.set(idx, toReturn);
        }
        return toReturn;
    }
}

