/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.jboss.logging.annotations.ConstructType;
import org.jboss.logging.processor.apt.AbstractClassType;
import org.jboss.logging.processor.apt.ProcessingException;
import org.jboss.logging.processor.apt.ThrowableTypeFactory;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.model.ReturnType;
import org.jboss.logging.processor.model.ThrowableType;
import org.jboss.logging.processor.util.ElementHelper;
import org.jboss.logging.processor.util.Objects;

final class ReturnTypeFactory {
    private ReturnTypeFactory() {
    }

    public static ReturnType of(ProcessingEnvironment processingEnv, TypeMirror returnType, MessageMethod method) {
        if (returnType.getKind() == TypeKind.VOID) {
            return VoidReturnType.getInstance(processingEnv.getTypeUtils());
        }
        AptReturnType result = new AptReturnType(processingEnv, returnType, method);
        result.init();
        return result;
    }

    private static class VoidReturnType
    implements ReturnType {
        private static VoidReturnType INSTANCE = null;
        private final Element voidElement;
        private final NoType voidType;
        private final int hash;

        private VoidReturnType(Types types) {
            this.voidType = types.getNoType(TypeKind.VOID);
            this.voidElement = types.asElement(this.voidType);
            this.hash = "void".hashCode();
        }

        private static synchronized VoidReturnType getInstance(Types types) {
            if (INSTANCE == null) {
                INSTANCE = new VoidReturnType(types);
            }
            return INSTANCE;
        }

        @Override
        public TypeMirror asType() {
            return this.voidType;
        }

        @Override
        public boolean isThrowable() {
            return false;
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public String name() {
            return "void";
        }

        @Override
        public ThrowableType throwableReturnType() {
            return null;
        }

        @Override
        public int hashCode() {
            return this.hash;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof VoidReturnType;
        }

        public String toString() {
            return "void";
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            return type == Void.class || type == Void.TYPE;
        }

        @Override
        public boolean isSubtypeOf(Class<?> type) {
            return false;
        }

        @Override
        public boolean isSameAs(Class<?> type) {
            return type == Void.class || type == Void.TYPE;
        }

        @Override
        public Element getDelegate() {
            return this.voidElement;
        }
    }

    private static class AptReturnType
    extends AbstractClassType
    implements ReturnType {
        private final TypeMirror returnType;
        private final MessageMethod method;
        private ThrowableType throwableType;

        AptReturnType(ProcessingEnvironment processingEnv, TypeMirror returnType, MessageMethod method) {
            super(processingEnv, returnType);
            this.returnType = returnType;
            this.method = method;
            this.throwableType = null;
        }

        @Override
        public Element getDelegate() {
            return this.types.asElement(this.returnType);
        }

        @Override
        public boolean isThrowable() {
            return this.isSubtypeOf(Throwable.class);
        }

        @Override
        public boolean isPrimitive() {
            return this.returnType.getKind().isPrimitive();
        }

        @Override
        public String name() {
            return this.returnType.toString();
        }

        @Override
        public ThrowableType throwableReturnType() {
            return this.throwableType;
        }

        private void init() {
            if (this.isThrowable()) {
                TypeMirror returnType = this.returnType;
                if (ElementHelper.isAnnotatedWith(this.method, ConstructType.class)) {
                    TypeElement constructTypeValue = ElementHelper.getClassAnnotationValue(this.method, ConstructType.class);
                    if (constructTypeValue == null) {
                        throw new ProcessingException(this.method, "Class not defined for the ConstructType");
                    }
                    returnType = constructTypeValue.asType();
                    if (!this.types.isAssignable(returnType, this.returnType)) {
                        throw new ProcessingException((Element)this.method, "The requested type %s can not be assigned to %s.", returnType, this.returnType);
                    }
                }
                this.throwableType = ThrowableTypeFactory.forReturnType(this.processingEnv, returnType, this.method);
            }
        }

        @Override
        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.name()).toHashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptReturnType)) {
                return false;
            }
            AptReturnType other = (AptReturnType)obj;
            return Objects.areEqual(this.name(), other.name());
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("name", this.name()).add("primitive", this.isPrimitive()).add("throwable", this.isThrowable()).add("throwableType", this.throwableType).toString();
        }

        private boolean checkType(Parameter parameter, TypeMirror type) {
            if (parameter.isPrimitive()) {
                if (type.getKind().isPrimitive()) {
                    return this.types.isSameType(parameter.asType(), type);
                }
                return this.types.isAssignable(this.types.unboxedType(parameter.asType()), type);
            }
            if (type.getKind().isPrimitive()) {
                TypeElement primitiveType = this.types.boxedClass((PrimitiveType)type);
                return this.types.isAssignable(parameter.asType(), primitiveType.asType());
            }
            return this.types.isAssignable(parameter.asType(), type);
        }
    }
}

