/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt.report;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Optional;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.logging.processor.apt.report.IndentingXmlWriter;
import org.jboss.logging.processor.apt.report.ReportWriter;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;

class XmlReportWriter
extends ReportWriter {
    static final String NAMESPACE = "urn:jboss:logging:report:1.0";
    private final XMLStreamWriter xmlWriter;

    protected XmlReportWriter(BufferedWriter writer) throws XMLStreamException {
        super(writer);
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.xmlWriter = new IndentingXmlWriter(factory.createXMLStreamWriter(writer));
    }

    @Override
    public void write(MessageInterface messageInterface) throws IOException {
        try {
            this.xmlWriter.writeStartElement("messages");
            this.xmlWriter.writeAttribute("interface", messageInterface.name());
            String idFormat = XmlReportWriter.createMessageIdFormat(messageInterface);
            for (MessageMethod messageMethod : this.getSortedMessageMethods(messageInterface)) {
                this.writeDetail(idFormat, messageMethod);
            }
            this.xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeStart(Optional<String> title) throws IOException {
        try {
            this.xmlWriter.writeStartDocument();
            this.xmlWriter.setDefaultNamespace(NAMESPACE);
            this.xmlWriter.writeStartElement("report");
            this.xmlWriter.writeNamespace(null, NAMESPACE);
            if (title.isPresent()) {
                this.xmlWriter.writeAttribute("title", title.get());
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeEnd() throws IOException {
        try {
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.xmlWriter != null) {
                this.xmlWriter.close();
            }
        }
        catch (XMLStreamException xMLStreamException) {
        }
        finally {
            super.close();
        }
    }

    private void writeDetail(String idFormat, MessageMethod method) throws XMLStreamException {
        this.xmlWriter.writeStartElement("message");
        MessageMethod.Message msg = method.message();
        if (msg.hasId()) {
            this.xmlWriter.writeAttribute("id", String.format(idFormat, msg.id()));
        }
        if (method.isLoggerMethod()) {
            this.xmlWriter.writeAttribute("logLevel", this.getLogLevel(method));
        } else {
            this.xmlWriter.writeAttribute("returnType", method.returnType().name());
        }
        this.xmlWriter.writeCharacters(msg.value());
        this.xmlWriter.writeEndElement();
    }
}

