/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.StandardLocation;
import org.jboss.logging.processor.apt.AbstractGenerator;
import org.jboss.logging.processor.apt.report.ReportType;
import org.jboss.logging.processor.apt.report.ReportWriter;
import org.jboss.logging.processor.model.MessageInterface;

@SupportedOptions(value={"reportType", "reportPath", "reportTitle"})
public class ReportFileGenerator
extends AbstractGenerator {
    public static final String REPORT_TYPE = "reportType";
    public static final String REPORT_PATH = "reportPath";
    public static final String REPORT_TITLE = "reportTitle";
    private final ReportType reportType;
    private final String reportPath;
    private final Optional<String> reportTitle;

    public ReportFileGenerator(ProcessingEnvironment processingEnv) {
        super(processingEnv);
        Map<String, String> options = processingEnv.getOptions();
        String reportType = options.get(REPORT_TYPE);
        this.reportPath = options.get(REPORT_PATH);
        this.reportTitle = Optional.ofNullable(options.get(REPORT_TITLE));
        if (reportType == null) {
            this.reportType = null;
        } else {
            String s = reportType.toLowerCase(Locale.ROOT);
            if ("adoc".equalsIgnoreCase(s)) {
                this.reportType = ReportType.ASCIIDOC;
            } else if ("xml".equalsIgnoreCase(s)) {
                this.reportType = ReportType.XML;
            } else {
                this.reportType = null;
                this.logger().warn(null, "Report type %s is invalid. No reports will be generated.", reportType);
            }
        }
    }

    @Override
    public void processTypeElement(TypeElement annotation, TypeElement element, MessageInterface messageInterface) {
        if (this.reportType != null) {
            try {
                if (messageInterface.methods().isEmpty()) {
                    this.logger().debug(element, "Skipping reports for interface %s with no methods.", messageInterface.name());
                    return;
                }
                this.logger().debug(element, "Writing reports for interface %s.", messageInterface.name());
                String fileName = messageInterface.simpleName() + this.reportType.getExtension();
                try (BufferedWriter writer = this.createWriter(messageInterface.packageName(), fileName);
                     ReportWriter reportWriter = ReportWriter.of(this.reportType, writer);){
                    reportWriter.writeStart(this.reportTitle);
                    reportWriter.write(messageInterface);
                    reportWriter.writeEnd();
                }
            }
            catch (IOException e) {
                this.logger().error((Element)element, e, "Failed to generate %s report", new Object[]{this.reportType});
            }
        }
    }

    private BufferedWriter createWriter(String packageName, String fileName) throws IOException {
        if (this.reportPath == null) {
            return new BufferedWriter(this.filer().createResource(StandardLocation.CLASS_OUTPUT, packageName, fileName, new Element[0]).openWriter());
        }
        return Files.newBufferedWriter(Paths.get(this.reportPath, packageName.replace(".", FileSystems.getDefault().getSeparator()), fileName), StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

