/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.util.Comparison;
import org.jboss.logging.processor.util.Objects;
import org.jboss.logging.processor.validation.ValidationMessage;
import org.jboss.logging.processor.validation.ValidationMessageFactory;

public final class MessageIdValidator {
    private final Map<MessageKey, MessageMethod> usedMessageIds = new HashMap<MessageKey, MessageMethod>();

    MessageIdValidator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ValidationMessage> validate(MessageInterface messageInterface, MessageMethod messageMethod) {
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        MessageMethod.Message message = messageMethod.message();
        if (message == null) {
            messages.add(ValidationMessageFactory.createError(messageMethod, "No message annotation found."));
        } else {
            Collection<MessageMethod> interfaceMessageMethods = messageInterface.methods();
            if (!messageMethod.inheritsMessage() && !message.inheritsId()) {
                int id = message.id();
                if (interfaceMessageMethods.contains(messageMethod)) {
                    List<ValidIdRange> validIdRanges = messageInterface.validIdRanges();
                    boolean invalidId = !validIdRanges.isEmpty();
                    for (ValidIdRange validIdRange : validIdRanges) {
                        if (id < validIdRange.min() || id > validIdRange.max()) continue;
                        invalidId = false;
                        break;
                    }
                    if (invalidId) {
                        StringBuilder ranges = new StringBuilder();
                        int count = 0;
                        for (ValidIdRange validIdRange : validIdRanges) {
                            ranges.append(validIdRange.min()).append('-').append(validIdRange.max());
                            if (++count >= validIdRanges.size()) continue;
                            ranges.append(", ");
                        }
                        messages.add(ValidationMessageFactory.createError(messageMethod, "Message id %d on method %s is not within the valid range: %s", id, messageMethod.name(), ranges.toString()));
                    }
                }
                String projectCode = messageInterface.projectCode();
                MessageKey key = MessageIdValidator.createMessageKey(projectCode, id);
                MessageIdValidator messageIdValidator = this;
                synchronized (messageIdValidator) {
                    if (this.usedMessageIds.containsKey(key)) {
                        MessageMethod previousMethod = this.usedMessageIds.get(key);
                        if (!previousMethod.name().equals(messageMethod.name())) {
                            messages.add(ValidationMessageFactory.createError(previousMethod, "Message id %s is not unique for messageMethod %s with project code %s.", id, previousMethod.name(), projectCode));
                            messages.add(ValidationMessageFactory.createError(messageMethod, "Message id %s is not unique for messageMethod %s with project code %s.", id, messageMethod.name(), projectCode));
                        }
                    } else {
                        this.usedMessageIds.put(key, messageMethod);
                    }
                }
            }
        }
        return messages;
    }

    private static MessageKey createMessageKey(String projectCode, int messageId) {
        return new MessageKey(projectCode, messageId);
    }

    private static class MessageKey
    implements Comparable<MessageKey> {
        final String projectCode;
        final int id;

        MessageKey(String projectCode, int id) {
            this.projectCode = projectCode == null ? "" : projectCode;
            this.id = id;
        }

        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.projectCode).add(this.id).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MessageKey)) {
                return false;
            }
            MessageKey other = (MessageKey)obj;
            return Objects.areEqual(this.projectCode, other.projectCode) && Objects.areEqual(this.id, other.id);
        }

        @Override
        public int compareTo(MessageKey other) {
            return Comparison.begin().compare((Comparable<?>)((Object)this.projectCode), (Comparable<?>)((Object)other.projectCode)).compare(this.id, other.id).result();
        }
    }
}

