/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Field;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.LoggingClass;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.Pos;
import org.jboss.logging.annotations.Property;
import org.jboss.logging.annotations.Transform;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;
import org.jboss.logging.processor.apt.AbstractGenerator;
import org.jboss.logging.processor.apt.ImplementationClassGenerator;
import org.jboss.logging.processor.apt.MessageInterfaceFactory;
import org.jboss.logging.processor.apt.ToolLogger;
import org.jboss.logging.processor.apt.TranslationClassGenerator;
import org.jboss.logging.processor.apt.TranslationFileGenerator;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.util.ElementHelper;
import org.jboss.logging.processor.validation.ValidationMessage;
import org.jboss.logging.processor.validation.Validator;

@SupportedOptions(value={"debug"})
public class LoggingToolsProcessor
extends AbstractProcessor {
    public static final String DEBUG_OPTION = "debug";
    private final List<String> interfaceAnnotations = Arrays.asList(MessageBundle.class.getName(), MessageLogger.class.getName());
    private final List<AbstractGenerator> generators = new ArrayList<AbstractGenerator>();
    private final Set<String> supportedAnnotations;
    private ToolLogger logger;

    public LoggingToolsProcessor() {
        HashSet<String> annotations = new HashSet<String>();
        annotations.addAll(this.interfaceAnnotations);
        annotations.add(Cause.class.getName());
        annotations.add(Field.class.getName());
        annotations.add(FormatWith.class.getName());
        annotations.add(LoggingClass.class.getName());
        annotations.add(LogMessage.class.getName());
        annotations.add(Message.class.getName());
        annotations.add(Param.class.getName());
        annotations.add(Pos.class.getName());
        annotations.add(Property.class.getName());
        annotations.add(Transform.class.getName());
        annotations.add(ValidIdRange.class.getName());
        annotations.add(ValidIdRanges.class.getName());
        this.supportedAnnotations = Collections.unmodifiableSet(annotations);
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> supportedOptions = new HashSet<String>();
        SupportedOptions globalOptions = this.getClass().getAnnotation(SupportedOptions.class);
        if (globalOptions != null) {
            supportedOptions.addAll(Arrays.asList(globalOptions.value()));
        }
        for (AbstractGenerator generator : this.generators) {
            supportedOptions.addAll(generator.getSupportedOptions());
        }
        return supportedOptions;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.supportedAnnotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.logger = ToolLogger.getLogger(processingEnv);
        this.generators.add(new ImplementationClassGenerator(processingEnv));
        this.generators.add(new TranslationClassGenerator(processingEnv));
        this.generators.add(new TranslationFileGenerator(processingEnv));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean process = true;
        Validator validator = new Validator();
        for (TypeElement typeElement : annotations) {
            if (!this.interfaceAnnotations.contains(typeElement.getQualifiedName().toString())) continue;
            try {
                Set<TypeElement> interfaces = ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(typeElement));
                for (TypeElement interfaceElement : interfaces) {
                    MessageInterface messageInterface = MessageInterfaceFactory.of(this.processingEnv, interfaceElement);
                    Collection<ValidationMessage> validationMessages = validator.validate(messageInterface);
                    block8: for (ValidationMessage message : validationMessages) {
                        Element element = ElementHelper.fromMessageObject(message.getMessageObject());
                        switch (message.type()) {
                            case ERROR: {
                                this.logger.error(element, message.getMessage());
                                process = false;
                                continue block8;
                            }
                            case WARN: {
                                this.logger.warn(element, message.getMessage());
                                continue block8;
                            }
                        }
                        this.logger.note(element, message.getMessage());
                    }
                    if (!process || !interfaceElement.getKind().isInterface() || interfaceElement.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                    for (AbstractGenerator processor : this.generators) {
                        this.logger.debug("Executing processor %s", processor.getName());
                        processor.processTypeElement(typeElement, interfaceElement, messageInterface);
                    }
                }
            }
            catch (Throwable t) {
                this.logger.error((Element)typeElement, t);
            }
        }
        return process;
    }
}

