/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Field;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.LoggingClass;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.Pos;
import org.jboss.logging.annotations.Property;
import org.jboss.logging.annotations.Transform;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;
import org.jboss.logging.processor.apt.Annotations;
import org.jboss.logging.processor.util.ElementHelper;

public class AnnotationsImpl
implements Annotations {
    static final String LEGACY_CAUSE = "org.jboss.logging.Cause";
    static final String LEGACY_FIELD = "org.jboss.logging.Field";
    static final String LEGACY_FORMAT_WITH = "org.jboss.logging.FormatWith";
    static final String LEGACY_LOGGING_CLASS = "org.jboss.logging.LoggingClass";
    static final String LEGACY_LOG_MESSAGE = "org.jboss.logging.LogMessage";
    static final String LEGACY_MESSAGE = "org.jboss.logging.Message";
    static final String LEGACY_MESSAGE_BUNDLE = "org.jboss.logging.MessageBundle";
    static final String LEGACY_MESSAGE_LOGGER = "org.jboss.logging.MessageLogger";
    static final String LEGACY_PARAM = "org.jboss.logging.Param";
    static final String LEGACY_PROPERTY = "org.jboss.logging.Property";
    private static String[] ANNOTATIONS = new String[]{"org.jboss.logging.MessageBundle", "org.jboss.logging.MessageLogger", "org.jboss.logging.Cause", "org.jboss.logging.Field", "org.jboss.logging.FormatWith", "org.jboss.logging.LogMessage", "org.jboss.logging.LoggingClass", "org.jboss.logging.Message", "org.jboss.logging.Param", "org.jboss.logging.Property", MessageBundle.class.getName(), MessageLogger.class.getName(), Cause.class.getName(), Field.class.getName(), FormatWith.class.getName(), LoggingClass.class.getName(), LogMessage.class.getName(), Message.class.getName(), Param.class.getName(), Pos.class.getName(), Property.class.getName(), Transform.class.getName(), ValidIdRange.class.getName(), ValidIdRanges.class.getName()};
    private static List<String> INTERFACE_ANNOTATIONS = Arrays.asList("org.jboss.logging.MessageBundle", "org.jboss.logging.MessageLogger", MessageBundle.class.getName(), MessageLogger.class.getName());

    @Override
    public Set<String> getSupportedAnnotations() {
        HashSet annotations = new HashSet(ANNOTATIONS.length);
        Collections.addAll(annotations, ANNOTATIONS);
        return Collections.unmodifiableSet(annotations);
    }

    @Override
    public boolean isSupportedInterfaceAnnotation(TypeElement annotation) {
        return INTERFACE_ANNOTATIONS.contains(annotation.getQualifiedName().toString());
    }

    @Override
    public Annotations.FormatType messageFormat(ExecutableElement method) {
        Annotations.FormatType result = null;
        if (ElementHelper.isAnnotatedWith((Element)method, Message.class)) {
            Message message = method.getAnnotation(Message.class);
            if (message != null) {
                switch (message.format()) {
                    case MESSAGE_FORMAT: {
                        result = Annotations.FormatType.MESSAGE_FORMAT;
                        break;
                    }
                    case PRINTF: {
                        result = Annotations.FormatType.PRINTF;
                        break;
                    }
                    case NO_FORMAT: {
                        result = Annotations.FormatType.NO_FORMAT;
                    }
                }
            }
        } else if (ElementHelper.isAnnotatedWith((Element)method, LEGACY_MESSAGE)) {
            AnnotationValue value = ElementHelper.getAnnotationValue(method, LEGACY_MESSAGE, "format");
            result = value != null ? AnnotationsImpl.getEnum(Annotations.FormatType.class, value.getValue().toString()) : Annotations.FormatType.PRINTF;
        }
        return result;
    }

    @Override
    public String projectCode(TypeElement intf) {
        String result = null;
        MessageBundle bundle = intf.getAnnotation(MessageBundle.class);
        MessageLogger logger = intf.getAnnotation(MessageLogger.class);
        if (bundle != null) {
            result = bundle.projectCode();
        } else if (logger != null) {
            result = logger.projectCode();
        } else {
            AnnotationValue legacyBundle = ElementHelper.getAnnotationValue(intf, LEGACY_MESSAGE_BUNDLE, "projectCode");
            AnnotationValue legacyLogger = ElementHelper.getAnnotationValue(intf, LEGACY_MESSAGE_LOGGER, "projectCode");
            if (legacyBundle != null) {
                result = legacyBundle.getValue().toString();
            } else if (legacyLogger != null) {
                result = legacyLogger.getValue().toString();
            }
        }
        return result;
    }

    @Override
    public int idLength(TypeElement intf) {
        int result = 6;
        MessageBundle bundle = intf.getAnnotation(MessageBundle.class);
        MessageLogger logger = intf.getAnnotation(MessageLogger.class);
        if (bundle != null) {
            result = bundle.length();
        } else if (logger != null) {
            result = logger.length();
        }
        return result;
    }

    @Override
    public boolean hasCauseAnnotation(VariableElement param) {
        return ElementHelper.isAnnotatedWith((Element)param, Cause.class) || ElementHelper.isAnnotatedWith((Element)param, LEGACY_CAUSE);
    }

    @Override
    public boolean hasFieldAnnotation(VariableElement param) {
        return ElementHelper.isAnnotatedWith((Element)param, Field.class) || ElementHelper.isAnnotatedWith((Element)param, LEGACY_FIELD);
    }

    @Override
    public boolean hasLoggingClassAnnotation(VariableElement param) {
        return ElementHelper.isAnnotatedWith((Element)param, LoggingClass.class) || ElementHelper.isAnnotatedWith((Element)param, LEGACY_LOGGING_CLASS);
    }

    @Override
    public boolean hasMessageAnnotation(ExecutableElement method) {
        return ElementHelper.isAnnotatedWith((Element)method, Message.class) || ElementHelper.isAnnotatedWith((Element)method, LEGACY_MESSAGE);
    }

    @Override
    public boolean hasMessageId(ExecutableElement method) {
        boolean result;
        Message message = method.getAnnotation(Message.class);
        if (message != null) {
            result = message.id() != 0 && message.id() != -1;
        } else if (ElementHelper.isAnnotatedWith((Element)method, LEGACY_MESSAGE)) {
            AnnotationValue value = ElementHelper.getAnnotationValue(method, LEGACY_MESSAGE, "id");
            int id = value != null ? Integer.parseInt(value.getValue().toString()) : -1;
            result = value != null && id != 0 && id != -1;
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean hasParamAnnotation(VariableElement param) {
        return ElementHelper.isAnnotatedWith((Element)param, Param.class) || ElementHelper.isAnnotatedWith((Element)param, LEGACY_PARAM);
    }

    @Override
    public boolean hasPropertyAnnotation(VariableElement param) {
        return ElementHelper.isAnnotatedWith((Element)param, Property.class) || ElementHelper.isAnnotatedWith((Element)param, LEGACY_PROPERTY);
    }

    @Override
    public boolean inheritsMessageId(ExecutableElement method) {
        boolean result;
        Message message = method.getAnnotation(Message.class);
        if (message != null) {
            result = message.id() == -1;
        } else if (ElementHelper.isAnnotatedWith((Element)method, LEGACY_MESSAGE)) {
            AnnotationValue value = ElementHelper.getAnnotationValue(method, LEGACY_MESSAGE, "id");
            int id = value != null ? Integer.parseInt(value.getValue().toString()) : -1;
            result = value != null && id == -1;
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean isLoggerMethod(ExecutableElement method) {
        return ElementHelper.isAnnotatedWith((Element)method, LogMessage.class) || ElementHelper.isAnnotatedWith((Element)method, LEGACY_LOG_MESSAGE);
    }

    @Override
    public boolean isMessageBundle(TypeElement element) {
        return ElementHelper.isAnnotatedWith((Element)element, MessageBundle.class) || ElementHelper.isAnnotatedWith((Element)element, LEGACY_MESSAGE_BUNDLE);
    }

    @Override
    public boolean isMessageLogger(TypeElement element) {
        return ElementHelper.isAnnotatedWith((Element)element, MessageLogger.class) || ElementHelper.isAnnotatedWith((Element)element, LEGACY_MESSAGE_LOGGER);
    }

    @Override
    public String getFormatWithAnnotationName(VariableElement param) {
        String result = FormatWith.class.getName();
        if (ElementHelper.isAnnotatedWith((Element)param, LEGACY_FORMAT_WITH)) {
            result = LEGACY_FORMAT_WITH;
        }
        return result;
    }

    @Override
    public String getMessageLoggerAnnotationName(TypeElement element) {
        String result = MessageLogger.class.getName();
        if (ElementHelper.isAnnotatedWith((Element)element, LEGACY_MESSAGE_LOGGER)) {
            result = LEGACY_MESSAGE_LOGGER;
        }
        return result;
    }

    @Override
    public int messageId(ExecutableElement method) {
        AnnotationValue value;
        Message message = method.getAnnotation(Message.class);
        int result = message != null ? message.id() : ((value = ElementHelper.getAnnotationValue(method, LEGACY_MESSAGE, "id")) == null ? 0 : Integer.valueOf(value.getValue().toString()));
        return result;
    }

    @Override
    public String messageValue(ExecutableElement method) {
        AnnotationValue value;
        Message message = method.getAnnotation(Message.class);
        String result = message != null ? message.value() : ((value = ElementHelper.getAnnotationValue(method, LEGACY_MESSAGE, "value")) == null ? null : value.getValue().toString());
        return result;
    }

    @Override
    public String loggerMethod(Annotations.FormatType formatType) {
        return "log" + (formatType == null || formatType == Annotations.FormatType.NO_FORMAT ? "" : Character.valueOf(formatType.logType()));
    }

    @Override
    public String logLevel(ExecutableElement method) {
        String result = null;
        LogMessage logMessage = method.getAnnotation(LogMessage.class);
        if (logMessage != null) {
            Logger.Level logLevel = logMessage.level() == null ? Logger.Level.INFO : logMessage.level();
            result = String.format("%s.%s.%s", Logger.class.getName(), Logger.Level.class.getSimpleName(), logLevel.name());
        } else if (ElementHelper.isAnnotatedWith((Element)method, LEGACY_LOG_MESSAGE)) {
            AnnotationValue value = ElementHelper.getAnnotationValue(method, LEGACY_LOG_MESSAGE, "level");
            Logger.Level logLevel = value == null ? Logger.Level.INFO : AnnotationsImpl.getEnum(Logger.Level.class, value.getValue().toString());
            result = String.format("%s.%s.%s", Logger.class.getName(), Logger.Level.class.getSimpleName(), logLevel.name());
        }
        return result;
    }

    @Override
    public String targetName(VariableElement param) {
        String result = "";
        Field field = param.getAnnotation(Field.class);
        Property property = param.getAnnotation(Property.class);
        if (field != null) {
            String name = field.name();
            result = name.isEmpty() ? param.getSimpleName().toString() : name;
        } else if (property != null) {
            String name = property.name();
            result = name.isEmpty() ? param.getSimpleName().toString() : name;
            result = "set" + Character.toUpperCase(result.charAt(0)) + result.substring(1);
        } else if (ElementHelper.isAnnotatedWith((Element)param, LEGACY_FIELD)) {
            AnnotationValue value = ElementHelper.getAnnotationValue(param, LEGACY_FIELD, "name");
            result = value == null ? param.getSimpleName().toString() : value.getValue().toString();
        } else if (ElementHelper.isAnnotatedWith((Element)param, LEGACY_PROPERTY)) {
            AnnotationValue value = ElementHelper.getAnnotationValue(param, LEGACY_PROPERTY, "name");
            result = value == null ? param.getSimpleName().toString() : value.getValue().toString();
            result = "set" + Character.toUpperCase(result.charAt(0)) + result.substring(1);
        }
        return result;
    }

    static <T extends Enum<T>> T getEnum(Class<T> type, String name) {
        int start = name.lastIndexOf(".");
        String s = start > 0 ? name.substring(start + 1) : name;
        return Enum.valueOf(type, s);
    }
}

