/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.processor.generator.model.ClassModel;
import org.jboss.logging.processor.generator.model.ClassModelHelper;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.model.ThrowableType;

abstract class ImplementationClassModel
extends ClassModel {
    ImplementationClassModel(MessageInterface messageInterface) {
        super(messageInterface, ClassModelHelper.implementationClassName(messageInterface), null);
    }

    @Override
    protected JCodeModel generateModel() throws IllegalStateException {
        JCodeModel codeModel = super.generateModel();
        this.getDefinedClass()._implements(codeModel.directClass(Serializable.class.getName()));
        JFieldVar serialVersionUID = this.getDefinedClass().field(28, (JType)codeModel.LONG, "serialVersionUID");
        serialVersionUID.init(JExpr.lit((long)1L));
        return codeModel;
    }

    void createBundleMethod(MessageMethod messageMethod, JMethod method, JMethod msgMethod) {
        JInvocation expression;
        JInvocation formatterMethod;
        this.addThrownTypes(messageMethod, method);
        JBlock body = method.body();
        JClass returnField = this.getCodeModel().directClass(method.type().fullName());
        JVar result = body.decl((JType)returnField, "result");
        MessageMethod.Message message = messageMethod.message();
        boolean noFormatParameters = messageMethod.parameters(Parameter.ParameterType.FORMAT).isEmpty();
        switch (message.format()) {
            case MESSAGE_FORMAT: {
                JClass formatter = this.getCodeModel().directClass(message.format().formatClass().getName());
                formatterMethod = formatter.staticInvoke(message.format().staticMethod());
                if (noFormatParameters) {
                    expression = JExpr.invoke((JMethod)msgMethod);
                    break;
                }
                formatterMethod.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
                expression = formatterMethod;
                break;
            }
            case PRINTF: {
                JClass formatter = this.getCodeModel().directClass(message.format().formatClass().getName());
                expression = formatterMethod = formatter.staticInvoke(message.format().staticMethod()).arg((JExpression)JExpr.invoke((JMethod)msgMethod));
                break;
            }
            default: {
                formatterMethod = null;
                expression = JExpr.invoke((JMethod)msgMethod);
            }
        }
        HashMap<String, JVar> fields = new HashMap<String, JVar>();
        HashMap<String, JVar> properties = new HashMap<String, JVar>();
        for (Parameter parameter : messageMethod.parameters(Parameter.ParameterType.ANY)) {
            JClass paramType = this.getCodeModel().directClass(parameter.type());
            JVar var = method.param(8, (JType)paramType, parameter.name());
            String formatterClass = parameter.formatterClass();
            switch (parameter.parameterType()) {
                case FORMAT: {
                    if (formatterMethod == null) {
                        throw new IllegalStateException("No format parameters are allowed when NO_FORMAT is specified.");
                    }
                    if (formatterClass == null) {
                        formatterMethod.arg((JExpression)var);
                        break;
                    }
                    formatterMethod.arg((JExpression)JExpr._new((JClass)this.getCodeModel().directClass(formatterClass)).arg((JExpression)var));
                    break;
                }
                case FIELD: {
                    fields.put(parameter.targetName(), var);
                    break;
                }
                case PROPERTY: {
                    properties.put(parameter.targetName(), var);
                }
            }
        }
        if (messageMethod.returnType().isThrowable()) {
            this.initCause(result, returnField, body, messageMethod, (JExpression)expression);
        } else {
            result.init((JExpression)expression);
        }
        for (Map.Entry entry : fields.entrySet()) {
            body.assign((JAssignmentTarget)result.ref((String)entry.getKey()), (JExpression)entry.getValue());
        }
        for (Map.Entry entry : properties.entrySet()) {
            body.add((JStatement)result.invoke((String)entry.getKey()).arg((JExpression)entry.getValue()));
        }
        body._return((JExpression)result);
    }

    private void initCause(JVar result, JClass returnField, JBlock body, MessageMethod messageMethod, JExpression format) {
        JInvocation initCause;
        ThrowableType returnType = messageMethod.returnType().throwableReturnType();
        if (returnType.useConstructionParameters()) {
            JInvocation invocation = JExpr._new((JClass)returnField);
            block3: for (Parameter param : returnType.constructionParameters()) {
                switch (param.parameterType()) {
                    case MESSAGE: {
                        invocation.arg(format);
                        continue block3;
                    }
                }
                invocation.arg((JExpression)JExpr.ref((String)param.name()));
            }
            result.init((JExpression)invocation);
        } else if (returnType.hasStringAndThrowableConstructor() && messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg(format).arg((JExpression)JExpr.ref((String)messageMethod.cause().name())));
        } else if (returnType.hasThrowableAndStringConstructor() && messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)JExpr.ref((String)messageMethod.cause().name())).arg(format));
        } else if (returnType.hasStringConstructor()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg(format));
            if (messageMethod.hasCause()) {
                initCause = body.invoke((JExpression)result, "initCause");
                initCause.arg((JExpression)JExpr.ref((String)messageMethod.cause().name()));
            }
        } else if (returnType.hasThrowableConstructor() && messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)JExpr.ref((String)messageMethod.cause().name())));
        } else if (returnType.hasStringAndThrowableConstructor() && !messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg(format).arg(JExpr._null()));
        } else if (returnType.hasThrowableAndStringConstructor() && !messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg(JExpr._null()).arg(format));
        } else if (messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField));
            initCause = body.invoke((JExpression)result, "initCause");
            initCause.arg((JExpression)JExpr.ref((String)messageMethod.cause().name()));
        } else {
            result.init((JExpression)JExpr._new((JClass)returnField));
        }
        JClass arrays = this.getCodeModel().directClass(Arrays.class.getName());
        JClass stClass = this.getCodeModel().directClass(StackTraceElement.class.getName()).array();
        JVar st = body.decl((JType)stClass, "st").init((JExpression)result.invoke("getStackTrace"));
        JInvocation setStackTrace = result.invoke("setStackTrace");
        setStackTrace.arg((JExpression)arrays.staticInvoke("copyOfRange").arg((JExpression)st).arg(JExpr.lit((int)1)).arg((JExpression)st.ref("length")));
        body.add((JStatement)setStackTrace);
    }

    protected final void addThrownTypes(MessageMethod messageMethod, JMethod jMethod) {
        for (ThrowableType thrownType : messageMethod.thrownTypes()) {
            jMethod._throws(this.getCodeModel().directClass(thrownType.name()));
        }
    }
}

