/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.jboss.logging.Cause;
import org.jboss.logging.Field;
import org.jboss.logging.FormatWith;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggingClass;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.MessageLogger;
import org.jboss.logging.Param;
import org.jboss.logging.Property;
import org.jboss.logging.processor.apt.Annotations;
import org.jboss.logging.processor.util.ElementHelper;

public class AnnotationsImpl
implements Annotations {
    @Override
    public Annotations.FormatType messageFormat(ExecutableElement method) {
        Message message;
        Annotations.FormatType result = null;
        if (ElementHelper.isAnnotatedWith(method, org.jboss.logging.annotations.Message.class)) {
            org.jboss.logging.annotations.Message message2 = method.getAnnotation(org.jboss.logging.annotations.Message.class);
            if (message2 != null) {
                switch (message2.format()) {
                    case MESSAGE_FORMAT: {
                        result = Annotations.FormatType.MESSAGE_FORMAT;
                        break;
                    }
                    case PRINTF: {
                        result = Annotations.FormatType.PRINTF;
                        break;
                    }
                    case NO_FORMAT: {
                        result = Annotations.FormatType.NO_FORMAT;
                    }
                }
            }
        } else if (ElementHelper.isAnnotatedWith(method, Message.class) && (message = method.getAnnotation(Message.class)) != null) {
            switch (message.format()) {
                case MESSAGE_FORMAT: {
                    result = Annotations.FormatType.MESSAGE_FORMAT;
                    break;
                }
                case PRINTF: {
                    result = Annotations.FormatType.PRINTF;
                    break;
                }
                case NO_FORMAT: {
                    result = Annotations.FormatType.NO_FORMAT;
                }
            }
        }
        return result;
    }

    @Override
    public String projectCode(TypeElement intf) {
        String result = null;
        org.jboss.logging.annotations.MessageBundle bundle = intf.getAnnotation(org.jboss.logging.annotations.MessageBundle.class);
        org.jboss.logging.annotations.MessageLogger logger = intf.getAnnotation(org.jboss.logging.annotations.MessageLogger.class);
        if (bundle != null) {
            result = bundle.projectCode();
        } else if (logger != null) {
            result = logger.projectCode();
        } else {
            MessageBundle legacyBundle = intf.getAnnotation(MessageBundle.class);
            MessageLogger legacyLogger = intf.getAnnotation(MessageLogger.class);
            if (legacyBundle != null) {
                result = legacyBundle.projectCode();
            } else if (legacyLogger != null) {
                result = legacyLogger.projectCode();
            }
        }
        return result;
    }

    @Override
    public boolean hasCauseAnnotation(VariableElement param) {
        return ElementHelper.isAnnotatedWith(param, org.jboss.logging.annotations.Cause.class, Cause.class);
    }

    @Override
    public boolean hasFieldAnnotation(VariableElement param) {
        return ElementHelper.isAnnotatedWith(param, org.jboss.logging.annotations.Field.class, Field.class);
    }

    @Override
    public boolean hasLoggingClassAnnotation(VariableElement param) {
        return ElementHelper.isAnnotatedWith(param, org.jboss.logging.annotations.LoggingClass.class, LoggingClass.class);
    }

    @Override
    public boolean hasMessageAnnotation(ExecutableElement method) {
        return ElementHelper.isAnnotatedWith(method, org.jboss.logging.annotations.Message.class, Message.class);
    }

    @Override
    public boolean hasMessageId(ExecutableElement method) {
        Message legacyMessage;
        org.jboss.logging.annotations.Message message = method.getAnnotation(org.jboss.logging.annotations.Message.class);
        boolean result = message != null ? message.id() != 0 && message.id() != -1 : (legacyMessage = method.getAnnotation(Message.class)) != null && legacyMessage.id() != 0 && legacyMessage.id() != -1;
        return result;
    }

    @Override
    public boolean hasParamAnnotation(VariableElement param) {
        return ElementHelper.isAnnotatedWith(param, org.jboss.logging.annotations.Param.class, Param.class);
    }

    @Override
    public boolean hasPropertyAnnotation(VariableElement param) {
        return ElementHelper.isAnnotatedWith(param, org.jboss.logging.annotations.Property.class, Property.class);
    }

    @Override
    public boolean inheritsMessageId(ExecutableElement method) {
        Message legacyMessage;
        org.jboss.logging.annotations.Message message = method.getAnnotation(org.jboss.logging.annotations.Message.class);
        boolean result = message != null ? message.id() == -1 : (legacyMessage = method.getAnnotation(Message.class)) != null && legacyMessage.id() == -1;
        return result;
    }

    @Override
    public boolean isLoggerMethod(ExecutableElement method) {
        return ElementHelper.isAnnotatedWith(method, LogMessage.class, org.jboss.logging.annotations.LogMessage.class);
    }

    @Override
    public boolean isMessageBundle(TypeElement element) {
        return ElementHelper.isAnnotatedWith(element, MessageBundle.class, org.jboss.logging.annotations.MessageBundle.class);
    }

    @Override
    public boolean isMessageLogger(TypeElement element) {
        return ElementHelper.isAnnotatedWith(element, MessageLogger.class, org.jboss.logging.annotations.MessageLogger.class);
    }

    @Override
    public boolean isValidInterfaceAnnotation(TypeElement annotation) {
        String name = annotation.getQualifiedName().toString();
        return name != null && (name.equals(org.jboss.logging.annotations.MessageBundle.class.getName()) || name.equals(org.jboss.logging.annotations.MessageLogger.class.getName()) || name.equals(MessageBundle.class.getName()) || name.equals(MessageLogger.class.getName()));
    }

    @Override
    public String getFormatWithAnnotationName(VariableElement param) {
        String result = org.jboss.logging.annotations.FormatWith.class.getName();
        if (param.getAnnotation(FormatWith.class) != null) {
            result = FormatWith.class.getName();
        }
        return result;
    }

    @Override
    public String getMessageLoggerAnnotationName(TypeElement element) {
        String result = org.jboss.logging.annotations.MessageLogger.class.getName();
        if (element.getAnnotation(MessageLogger.class) != null) {
            result = MessageLogger.class.getName();
        }
        return result;
    }

    @Override
    public int messageId(ExecutableElement method) {
        Message legacyMessage;
        org.jboss.logging.annotations.Message message = method.getAnnotation(org.jboss.logging.annotations.Message.class);
        int result = message != null ? message.id() : ((legacyMessage = method.getAnnotation(Message.class)) == null ? 0 : legacyMessage.id());
        return result;
    }

    @Override
    public String messageValue(ExecutableElement method) {
        Message legacyMessage;
        org.jboss.logging.annotations.Message message = method.getAnnotation(org.jboss.logging.annotations.Message.class);
        String result = message != null ? message.value() : ((legacyMessage = method.getAnnotation(Message.class)) == null ? null : legacyMessage.value());
        return result;
    }

    @Override
    public String loggerMethod(Annotations.FormatType formatType) {
        return "log" + (formatType == null || formatType == Annotations.FormatType.NO_FORMAT ? "" : Character.valueOf(formatType.logType()));
    }

    @Override
    public String logLevel(ExecutableElement method) {
        String result = null;
        org.jboss.logging.annotations.LogMessage logMessage = method.getAnnotation(org.jboss.logging.annotations.LogMessage.class);
        if (logMessage != null) {
            Logger.Level logLevel = logMessage.level() == null ? Logger.Level.INFO : logMessage.level();
            result = String.format("%s.%s.%s", Logger.class.getSimpleName(), Logger.Level.class.getSimpleName(), logLevel.name());
        } else {
            LogMessage legacyLogMessage = method.getAnnotation(LogMessage.class);
            if (legacyLogMessage != null) {
                Logger.Level logLevel = legacyLogMessage.level() == null ? Logger.Level.INFO : legacyLogMessage.level();
                result = String.format("%s.%s.%s", Logger.class.getSimpleName(), Logger.Level.class.getSimpleName(), logLevel.name());
            }
        }
        return result;
    }

    @Override
    public String targetName(VariableElement param) {
        String result = "";
        org.jboss.logging.annotations.Field field = param.getAnnotation(org.jboss.logging.annotations.Field.class);
        org.jboss.logging.annotations.Property property = param.getAnnotation(org.jboss.logging.annotations.Property.class);
        if (field != null) {
            String name = field.name();
            result = name.isEmpty() ? param.getSimpleName().toString() : name;
        } else if (property != null) {
            String name = property.name();
            result = name.isEmpty() ? param.getSimpleName().toString() : name;
            result = "set" + Character.toUpperCase(result.charAt(0)) + result.substring(1);
        } else {
            Field legacyField = param.getAnnotation(Field.class);
            Property legacyProperty = param.getAnnotation(Property.class);
            if (legacyField != null) {
                String name = legacyField.name();
                result = name.isEmpty() ? param.getSimpleName().toString() : name;
            } else if (legacyProperty != null) {
                String name = legacyProperty.name();
                result = name.isEmpty() ? param.getSimpleName().toString() : name;
                result = "set" + Character.toUpperCase(result.charAt(0)) + result.substring(1);
            }
        }
        return result;
    }
}

