/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.jboss.logging.Field;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.MessageLogger;
import org.jboss.logging.Property;
import org.jboss.logging.generator.Annotations;
import org.jboss.logging.generator.apt.AptHelper;
import org.jboss.logging.processor.BaseAnnotations;

public class AptHelperImpl
implements AptHelper {
    public Annotations.FormatType messageFormat(ExecutableElement method) {
        Annotations.FormatType result = null;
        Message message = method.getAnnotation(BaseAnnotations.MESSAGE_ANNOTATION);
        if (message != null) {
            switch (message.format()) {
                case MESSAGE_FORMAT: {
                    result = Annotations.FormatType.MESSAGE_FORMAT;
                    break;
                }
                case PRINTF: {
                    result = Annotations.FormatType.PRINTF;
                }
            }
        }
        return result;
    }

    public String projectCode(TypeElement intf) {
        String result = null;
        MessageBundle bundle = intf.getAnnotation(BaseAnnotations.MESSAGE_BUNDLE_ANNOTATION);
        MessageLogger logger = intf.getAnnotation(BaseAnnotations.MESSAGE_LOGGER_ANNOTATION);
        if (bundle != null) {
            result = bundle.projectCode();
        } else if (logger != null) {
            result = logger.projectCode();
        }
        return result;
    }

    public boolean hasMessageId(ExecutableElement method) {
        Message message = method.getAnnotation(BaseAnnotations.MESSAGE_ANNOTATION);
        return message != null && message.id() != 0 && message.id() != -1;
    }

    public boolean inheritsMessageId(ExecutableElement method) {
        Message message = method.getAnnotation(BaseAnnotations.MESSAGE_ANNOTATION);
        return message != null && message.id() == -1;
    }

    public int messageId(ExecutableElement method) {
        Message message = method.getAnnotation(BaseAnnotations.MESSAGE_ANNOTATION);
        return message == null ? 0 : message.id();
    }

    public String messageValue(ExecutableElement method) {
        Message message = method.getAnnotation(BaseAnnotations.MESSAGE_ANNOTATION);
        return message == null ? null : message.value();
    }

    public String loggerMethod(Annotations.FormatType formatType) {
        return "log" + (formatType == null ? "" : Character.valueOf(formatType.logType()));
    }

    public String logLevel(ExecutableElement method) {
        String result = null;
        LogMessage logMessage = method.getAnnotation(BaseAnnotations.LOG_MESSAGE_ANNOTATION);
        if (logMessage != null) {
            Logger.Level logLevel = logMessage.level() == null ? Logger.Level.INFO : logMessage.level();
            result = String.format("%s.%s.%s", Logger.class.getSimpleName(), Logger.Level.class.getSimpleName(), logLevel.name());
        }
        return result;
    }

    public String targetName(VariableElement param) {
        String result = "";
        Field field = param.getAnnotation(Field.class);
        Property property = param.getAnnotation(Property.class);
        if (field != null) {
            String name = field.name();
            result = name.isEmpty() ? param.getSimpleName().toString() : name;
        } else if (property != null) {
            String name = property.name();
            result = name.isEmpty() ? param.getSimpleName().toString() : name;
            result = "set" + Character.toUpperCase(result.charAt(0)) + result.substring(1);
        }
        return result;
    }
}

