/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.lazy;

import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.lazy.LazyInitializer;
import org.jboss.kernel.spi.registry.KernelBus;
import org.jboss.metadata.spi.MetaData;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLazyInitializer
implements LazyInitializer {
    protected static boolean isGetter(Method minfo) {
        String name = minfo.getName();
        Class<?> returnType = minfo.getReturnType();
        Class<?>[] parameters = minfo.getParameterTypes();
        if (name.length() > 3 && name.startsWith("get") || name.length() > 2 && name.startsWith("is")) {
            if (name.startsWith("is") && !Boolean.TYPE.equals(returnType)) {
                return false;
            }
            if (parameters.length == 0 && !Void.TYPE.equals(returnType)) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isSetter(Method minfo) {
        String name = minfo.getName();
        Class<?> returnType = minfo.getReturnType();
        Class<?>[] parameters = minfo.getParameterTypes();
        return name.length() > 3 && name.startsWith("set") && parameters.length == 1 && Void.TYPE.equals(returnType);
    }

    protected static String getLowerPropertyName(String name) {
        int start = name.startsWith("is") ? 2 : 3;
        if ((name = name.substring(start)).length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        JBossStringBuilder buffer = new JBossStringBuilder(name.length());
        buffer.append(Character.toLowerCase(name.charAt(0)));
        if (name.length() > 1) {
            buffer.append(name.substring(1));
        }
        return buffer.toString();
    }

    protected KernelControllerContext getKernelControllerContext(Kernel kernel, String bean) {
        KernelController controller = kernel.getController();
        ControllerContext context = controller.getContext(bean, null);
        if (context == null) {
            throw new IllegalArgumentException("Should not be here, dependency failed, no such context: " + bean);
        }
        if (!(context instanceof KernelControllerContext)) {
            throw new IllegalArgumentException("Context not KernelControllerContext: " + context);
        }
        return (KernelControllerContext)KernelControllerContext.class.cast(context);
    }

    protected Class<?> getBeanClass(KernelControllerContext context, KernelConfigurator configurator, ClassLoader cl) throws Throwable {
        BeanMetaData bmd = context.getBeanMetaData();
        Class beanClass = null;
        String beanClassName = bmd.getBean();
        if (beanClassName != null) {
            beanClass = configurator.getClassInfo(beanClassName, cl).getType();
        } else if (context.getBeanInfo() != null) {
            beanClass = context.getBeanInfo().getClassInfo().getType();
        }
        if (beanClass == null) {
            throw new IllegalArgumentException("Not enough info to get bean class: " + context);
        }
        return beanClass;
    }

    @Deprecated
    protected BeanInfo getBeanInfo(Kernel kernel, String bean) {
        KernelControllerContext context = this.getKernelControllerContext(kernel, bean);
        return context.getBeanInfo();
    }

    protected static Class<?>[] getClasses(KernelConfigurator configurator, Set<String> classNames, ClassLoader cl) throws Throwable {
        Class[] classes = new Class[classNames.size()];
        int i = 0;
        for (String className : classNames) {
            classes[i] = configurator.getClassInfo(className, cl).getType();
        }
        return classes;
    }

    @Override
    public Object initializeProxy(Kernel kernel, String bean, boolean exposeClass, Set<String> interfaces, MetaData metaData) throws Throwable {
        return this.initializeProxy(kernel, bean, exposeClass, interfaces);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractInvokeHandler {
        private String bean;
        private KernelBus bus;
        private Class<?> proxyClass;
        private AtomicBoolean onDemandInitialized = new AtomicBoolean(false);

        protected AbstractInvokeHandler(String bean, KernelBus bus, Class<?> proxyClass) {
            if (bean == null) {
                throw new IllegalArgumentException("Null bean name.");
            }
            this.bean = bean;
            if (bus == null) {
                throw new IllegalArgumentException("Null Kernel bus.");
            }
            this.bus = bus;
            this.proxyClass = proxyClass;
        }

        protected Object executeInvoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if ("hashCode".equals(methodName)) {
                return System.identityHashCode(proxy);
            }
            if ("getClass".equalsIgnoreCase(methodName)) {
                return this.proxyClass;
            }
            if ("equals".equals(methodName)) {
                return proxy == args[0];
            }
            if ("toString".equals(methodName)) {
                return this.bean + "Proxy";
            }
            if (!this.onDemandInitialized.getAndSet(true)) {
                ControllerMode mode;
                Kernel kernel = this.bus.getKernel();
                KernelController controller = kernel.getController();
                ControllerContext context = controller.getContext(this.bean, null);
                if (context == null) {
                    throw new IllegalArgumentException("No such context: " + this.bean);
                }
                if (!ControllerState.INSTALLED.equals((Object)context.getState()) && (ControllerMode.ON_DEMAND.equals((Object)(mode = context.getMode())) || ControllerMode.MANUAL.equals((Object)mode))) {
                    controller.change(context, ControllerState.INSTALLED);
                }
                if (!ControllerState.INSTALLED.equals((Object)context.getState())) {
                    throw new IllegalArgumentException("Bean " + this.bean + " cannot be fully installed: " + context);
                }
            }
            if (AbstractLazyInitializer.isGetter(method)) {
                return this.bus.get(this.bean, AbstractLazyInitializer.getLowerPropertyName(methodName));
            }
            if (AbstractLazyInitializer.isSetter(method)) {
                this.bus.set(this.bean, AbstractLazyInitializer.getLowerPropertyName(methodName), args[0]);
                return null;
            }
            int length = args != null ? args.length : 0;
            return this.bus.invoke(this.bean, methodName, args, new String[length]);
        }
    }
}

