/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.jboss.beans.metadata.api.model.AutowireType;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.beans.metadata.api.model.InjectOption;
import org.jboss.beans.metadata.api.model.QualifierPoint;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractInjectQualifierMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.ContextualInjectionDependencyItem;
import org.jboss.beans.metadata.plugins.SecurityActions;
import org.jboss.beans.metadata.plugins.TypeProvider;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.RelatedClassMetaData;
import org.jboss.dependency.plugins.AttributeCallbackItem;
import org.jboss.dependency.spi.CallbackItem;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.dispatch.AttributeDispatchContext;
import org.jboss.kernel.plugins.dependency.ClassAndQualifiersKey;
import org.jboss.kernel.plugins.dependency.QualifierKey;
import org.jboss.kernel.plugins.dependency.QualifiersMdrUtil;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="injectionType", propOrder={"qualifiers"})
public class AbstractInjectionValueMetaData
extends AbstractDependencyValueMetaData {
    private static final long serialVersionUID = 3L;
    protected AutowireType injectionType = AutowireType.BY_CLASS;
    protected InjectOption injectionOption = InjectOption.STRICT;
    protected FromContext fromContext;
    ContextualInjectionDependencyItem item = null;
    protected boolean ignoreBeanQualifiers;
    protected Set<RelatedClassMetaData> qualifiers;
    protected List<MetaDataVisitorNode> parentNodes;
    protected AbstractPropertyMetaData propertyMetaData;

    public AbstractInjectionValueMetaData() {
    }

    public AbstractInjectionValueMetaData(Object value) {
        super(value);
    }

    public AbstractInjectionValueMetaData(Object value, String property) {
        super(value, property);
    }

    public AutowireType getInjectionType() {
        return this.injectionType;
    }

    @XmlAttribute(name="type")
    public void setInjectionType(AutowireType injectionType) {
        this.injectionType = injectionType;
    }

    public InjectOption getInjectionOption() {
        return this.injectionOption;
    }

    @XmlAttribute(name="option")
    public void setInjectionOption(InjectOption injectionOption) {
        this.injectionOption = injectionOption;
    }

    public FromContext getFromContext() {
        return this.fromContext;
    }

    @XmlAttribute(name="fromContext")
    public void setFromContext(FromContext fromContext) {
        this.fromContext = fromContext;
    }

    public AbstractPropertyMetaData getPropertyMetaData() {
        return this.propertyMetaData;
    }

    @XmlTransient
    public void setPropertyMetaData(AbstractPropertyMetaData propertyMetaData) {
        this.propertyMetaData = propertyMetaData;
    }

    public Set<RelatedClassMetaData> getQualifiers() {
        return this.qualifiers;
    }

    @XmlElement(name="qualifier", type=AbstractInjectQualifierMetaData.class)
    public void setQualifiers(Set<RelatedClassMetaData> qualifiers) {
        this.qualifiers = qualifiers;
    }

    public boolean isIgnoreBeanQualifiers() {
        return this.ignoreBeanQualifiers;
    }

    @XmlAttribute(name="ignoreBeanQualifiers")
    public void setIgnoreBeanQualifiers(boolean ignoreBeanQualifiers) {
        this.ignoreBeanQualifiers = ignoreBeanQualifiers;
    }

    protected void addInstallItem(Object name) {
        if (this.propertyMetaData == null) {
            throw new IllegalArgumentException("Illegal usage of option Callback - injection not used with property = " + this);
        }
        this.context.getDependencyInfo().addInstallItem((CallbackItem)new AttributeCallbackItem(name, this.whenRequiredState, this.dependentState, (AttributeDispatchContext)this.context, this.propertyMetaData.getName()));
    }

    @Override
    protected boolean isLookupValid(ControllerContext lookup) {
        boolean lookupExists = super.isLookupValid(lookup);
        boolean isCallback = InjectOption.CALLBACK.equals((Object)this.injectionOption);
        boolean isOptional = InjectOption.OPTIONAL.equals((Object)this.injectionOption);
        if (!lookupExists && isCallback) {
            this.addInstallItem(this.getUnderlyingValue());
        }
        return lookupExists || isCallback || isOptional;
    }

    @Override
    protected boolean isOptional() {
        return InjectOption.OPTIONAL.equals((Object)this.injectionOption);
    }

    @Override
    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        if (this.fromContext != null) {
            ControllerContext lookup;
            ControllerState state = this.dependentState;
            if (state == null) {
                state = ControllerState.INSTANTIATED;
            }
            if ((lookup = this.getControllerContext(this.getUnderlyingValue(), state)) == null) {
                throw new Error("Should not be here - dependency failed - " + this);
            }
            return this.fromContext.executeLookup(lookup);
        }
        if (this.getUnderlyingValue() == null) {
            ControllerContext lookup = null;
            if (this.item != null) {
                lookup = this.item.getControllerContext(this.context.getController());
            }
            if (lookup == null) {
                if (InjectOption.STRICT.equals((Object)this.injectionOption)) {
                    throw new IllegalArgumentException("Possible multiple matching beans, see log for info.");
                }
                if (InjectOption.CALLBACK.equals((Object)this.injectionOption)) {
                    this.addInstallItem(info.getType());
                }
                return null;
            }
            return AbstractInjectionValueMetaData.getTarget(this.context, lookup);
        }
        return super.getValue(info, cl);
    }

    @Override
    public Object ungetValue(TypeInfo info, ClassLoader cl) throws Throwable {
        ControllerContext lookup;
        if (this.getUnderlyingValue() == null && this.context != null && this.item != null && (lookup = this.item.getControllerContext(this.context.getController())) != null) {
            AbstractInjectionValueMetaData.ungetTarget(this.context, lookup);
            return null;
        }
        return super.ungetValue(info, cl);
    }

    @Override
    protected boolean addDependencyItem() {
        return InjectOption.STRICT.equals((Object)this.injectionOption) || this.fromContext != null;
    }

    @Override
    @XmlTransient
    public Object getUnderlyingValue() {
        Object original = super.getUnderlyingValue();
        return this.fromContext != null && original == null ? (this.context != null ? this.context.getName() : null) : original;
    }

    @Override
    public void initialVisit(MetaDataVisitor visitor) {
        if (this.fromContext != null) {
            if (super.getUnderlyingValue() == null && this.dependentState == null) {
                this.dependentState = this.fromContext.getWhenValid();
            }
            super.initialVisit(visitor);
            return;
        }
        if (this.getUnderlyingValue() == null) {
            if (this.property != null) {
                this.property = null;
                this.log.warn((Object)("Ignoring property - contextual injection: " + this));
            }
            if (AutowireType.BY_NAME.equals((Object)this.injectionType)) {
                if (this.propertyMetaData == null) {
                    throw new IllegalArgumentException("Illegal usage of type ByName - injection not used with property = " + this);
                }
                this.setValue(this.propertyMetaData.getName());
            } else {
                visitor.initialVisit(this);
            }
        }
        if (this.getUnderlyingValue() != null) {
            super.initialVisit(visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void describeVisit(MetaDataVisitor visitor) {
        if (this.getUnderlyingValue() == null) {
            if (AutowireType.BY_CLASS.equals((Object)this.injectionType)) {
                this.context = visitor.getControllerContext();
                if (InjectOption.STRICT.equals((Object)this.injectionOption)) {
                    MetaDataVisitorNode node = visitor.visitorNodeStack().pop();
                    try {
                        ControllerState whenRequired;
                        Class injectionClass;
                        if (node instanceof TypeProvider) {
                            TypeProvider typeProvider = (TypeProvider)((Object)node);
                            injectionClass = null;
                            try {
                                injectionClass = typeProvider.getType(visitor, this).getType();
                            }
                            finally {
                                visitor.visitorNodeStack().push(node);
                            }
                            this.log.debugf("%1s : Contextual injection usage (class -> classloader): %2s -> %3s defined by %4s", new Object[]{this.context.getName(), injectionClass, SecurityActions.getClassLoader(injectionClass), node});
                            whenRequired = this.whenRequiredState;
                            if (whenRequired == null) {
                                whenRequired = visitor.getContextState();
                            }
                        } else {
                            throw new Error("Node not of TypeProvider instance, cannot determine type info.");
                        }
                        this.item = this.createDependencyItem(visitor, injectionClass, whenRequired);
                        visitor.addDependency(this.item);
                    }
                    catch (Error error) {
                        throw error;
                    }
                    catch (Throwable throwable) {
                        throw new Error(throwable);
                    }
                }
            } else {
                throw new IllegalArgumentException("Unknown injection type=" + (Object)((Object)this.injectionType));
            }
        }
        super.describeVisit(visitor);
    }

    private ContextualInjectionDependencyItem createDependencyItem(MetaDataVisitor visitor, Class<?> injectionClass, ControllerState whenRequired) throws Exception {
        boolean hasQualifiers;
        this.initializeParents(visitor);
        QualifierPoint point = this.determineQualifierPoint();
        Set<Object> allQualifiers = this.getAllQualifiers();
        boolean bl = hasQualifiers = allQualifiers != null && allQualifiers.size() > 0;
        if (!hasQualifiers && point != null) {
            hasQualifiers = QualifiersMdrUtil.hasWantedQualifiersInParentMdrOrBeanMetaData(this.context, point);
        }
        if (!hasQualifiers) {
            return new ContextualInjectionDependencyItem(this, this.context.getName(), injectionClass, whenRequired, this.dependentState, this.search);
        }
        QualifierKey qualifierKey = this.createClassAndQualifierMatcher(injectionClass, allQualifiers);
        return new ContextualInjectionDependencyItem(this, this.context.getName(), qualifierKey, whenRequired, this.dependentState, this.search);
    }

    private Set<Object> getAllQualifiers() throws Exception {
        Set<Annotation> qualifierAnnotations = null;
        if (this.context.getBeanInfo() != null) {
            qualifierAnnotations = QualifiersMdrUtil.getQualifiersFromAnnotationsForInjectionPointParents(this.context, this.parentNodes);
        }
        HashSet<Object> allQualifiers = null;
        if (qualifierAnnotations != null && qualifierAnnotations.size() > 0 || this.qualifiers != null && this.qualifiers.size() > 0) {
            allQualifiers = new HashSet<Object>();
            if (this.qualifiers != null && this.qualifiers.size() > 0) {
                allQualifiers = new HashSet(this.qualifiers.size());
                for (RelatedClassMetaData rcmd : this.qualifiers) {
                    allQualifiers.addAll(rcmd.getEnabled());
                }
            }
            if (qualifierAnnotations != null && qualifierAnnotations.size() > 0) {
                allQualifiers.addAll(qualifierAnnotations);
            }
        }
        return allQualifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeParents(MetaDataVisitor visitor) {
        this.parentNodes = new ArrayList<MetaDataVisitorNode>();
        try {
            MetaDataVisitorNode node = visitor.visitorNodeStack().pop();
            this.parentNodes.add(node);
            while (node != null && visitor.visitorNodeStack().size() > 0) {
                this.parentNodes.add(visitor.visitorNodeStack().pop());
            }
        }
        finally {
            for (int i = this.parentNodes.size() - 1; i >= 0; --i) {
                visitor.visitorNodeStack().push(this.parentNodes.get(i));
            }
        }
    }

    List<MetaDataVisitorNode> getParents() {
        return this.parentNodes;
    }

    QualifierKey createClassAndQualifierMatcher(Class<?> injectionClass, Set<Object> allQualifiers) throws Exception {
        QualifierPoint point = this.determineQualifierPoint();
        if (point == null) {
            throw new IllegalArgumentException("Null qualifier point for " + this.context + ". Parents: " + this.parentNodes);
        }
        return new ClassAndQualifiersKey(this.dependentState, this.context, this.ignoreBeanQualifiers, point, this.parentNodes, allQualifiers, injectionClass);
    }

    QualifierPoint determineQualifierPoint() {
        for (MetaDataVisitorNode node : this.parentNodes) {
            if (node instanceof ConstructorMetaData) {
                return QualifierPoint.CONSTRUCTOR;
            }
            if (node instanceof LifecycleMetaData) {
                return QualifierPoint.METHOD;
            }
            if (!(node instanceof PropertyMetaData)) continue;
            return QualifierPoint.PROPERTY;
        }
        return null;
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        if (this.injectionType != null) {
            buffer.append(" injectionType=").append((Object)this.injectionType);
        }
        if (this.propertyMetaData != null) {
            buffer.append(" propertyMetaData=").append(this.propertyMetaData.getName());
        }
        if (this.fromContext != null) {
            buffer.append(" fromContext=").append((Object)this.fromContext);
        }
    }

    @Override
    public AbstractInjectionValueMetaData clone() {
        return (AbstractInjectionValueMetaData)super.clone();
    }
}

