/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.beans.metadata.api.model.QualifierPoint;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.dependency.QualifierKey;
import org.jboss.kernel.plugins.dependency.QualifiersMdrUtil;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.qualifier.QualifierMatchers;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAndQualifiersKey
extends JBossObject
implements QualifierKey {
    protected final Class<?> type;
    protected final ControllerState dependentState;
    protected final KernelControllerContext context;
    protected final Set<Object> injectionPointQualifiers;
    protected final boolean ignoreBeanQualifiers;
    protected final QualifierPoint injectionPointType;
    protected final List<MetaDataVisitorNode> parentNodes;

    public ClassAndQualifiersKey(ControllerState dependentState, KernelControllerContext context, boolean ignoreBeanQualifiers, QualifierPoint injectionPointType, List<MetaDataVisitorNode> parentNodes, Set<Object> injectionPointQualifiers, Class<?> type) {
        this.dependentState = dependentState == null ? ControllerState.INSTALLED : dependentState;
        this.context = context;
        this.injectionPointQualifiers = injectionPointQualifiers != null && injectionPointQualifiers.size() > 0 ? injectionPointQualifiers : new HashSet();
        this.type = type;
        this.ignoreBeanQualifiers = ignoreBeanQualifiers;
        this.parentNodes = parentNodes;
        this.injectionPointType = injectionPointType;
    }

    public List<MetaDataVisitorNode> getParentNodes() {
        return this.parentNodes;
    }

    @Override
    public void addQualifiersFromAnnotations(Set<Annotation> annotations) {
        this.injectionPointQualifiers.addAll(annotations);
    }

    @Override
    public ControllerContext search(KernelController controller) {
        Set<Object> optionalQualifiers;
        Set<Object> requiredQualifiers;
        Set contexts = controller.getContexts(this.type, this.dependentState);
        if (contexts == null || contexts.size() == 0) {
            return null;
        }
        if (this.injectionPointQualifiers != null) {
            if (this.ignoreBeanQualifiers) {
                requiredQualifiers = this.injectionPointQualifiers;
            } else {
                requiredQualifiers = QualifiersMdrUtil.mergeRequiredQualifiersFromMdr(this.context, this.injectionPointType);
                if (requiredQualifiers == null) {
                    requiredQualifiers = new HashSet<Object>();
                }
                requiredQualifiers.addAll(this.injectionPointQualifiers);
            }
        } else {
            requiredQualifiers = QualifiersMdrUtil.mergeRequiredQualifiersFromMdr(this.context, this.injectionPointType);
        }
        Set<Object> set = optionalQualifiers = this.ignoreBeanQualifiers ? null : QualifiersMdrUtil.mergeOptionalQualifiersFromMdr(this.context, this.injectionPointType);
        if (!(requiredQualifiers != null && requiredQualifiers.size() != 0 || optionalQualifiers != null && optionalQualifiers.size() != 0)) {
            return this.getFirstContext(contexts);
        }
        List<ControllerContext> found = this.getContextWithAllRequiredAndMostOptionalQualifiers(requiredQualifiers, optionalQualifiers, contexts);
        return this.getFirstContext(found);
    }

    private ControllerContext getFirstContext(Collection<? extends ControllerContext> contexts) {
        if (contexts.size() == 0) {
            return null;
        }
        ControllerContext found = null;
        if (contexts.size() > 0) {
            for (ControllerContext controllerContext : contexts) {
                if (found != null) {
                    this.log.warn((Object)("Multiple beans match qualifiers and class [enable trace log for details]: " + this.type));
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)(this + ". Matching contexts: " + contexts));
                    }
                    return null;
                }
                found = controllerContext;
            }
        }
        return found;
    }

    private List<ControllerContext> getContextWithAllRequiredAndMostOptionalQualifiers(Set<Object> requiredQualifiers, Set<Object> optionalQualifiers, Collection<ControllerContext> contexts) {
        int max = 0;
        ArrayList<ControllerContext> found = new ArrayList<ControllerContext>();
        for (ControllerContext context : contexts) {
            Set<Object> suppliedQualifiers = QualifiersMdrUtil.mergeSuppliedQualifiersFromMdr(context);
            if (suppliedQualifiers == null) {
                suppliedQualifiers = Collections.emptySet();
            }
            int matches = 0;
            boolean allRequired = true;
            if (requiredQualifiers != null && requiredQualifiers.size() > 0) {
                for (Object qualifier : requiredQualifiers) {
                    if (QualifierMatchers.getInstance().matches(context, suppliedQualifiers, qualifier)) {
                        ++matches;
                        continue;
                    }
                    allRequired = false;
                    break;
                }
            }
            if (allRequired && optionalQualifiers != null && optionalQualifiers.size() > 0) {
                for (Object qualifier : optionalQualifiers) {
                    if (!QualifierMatchers.getInstance().matches(context, suppliedQualifiers, qualifier)) continue;
                    ++matches;
                }
            }
            if (!allRequired) continue;
            if (matches > max) {
                found.clear();
                found.add(context);
                max = matches;
                continue;
            }
            if (matches != max) continue;
            found.add(context);
        }
        return found;
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("class=");
        buffer.append(this.type);
        buffer.append(" qualifiers=");
        buffer.append(QualifiersMdrUtil.mergeRequiredQualifiersFromMdr(this.context, this.injectionPointType));
    }

    public void toShortString(JBossStringBuilder buffer) {
        this.toString(buffer);
    }
}

