/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.api.annotations.MCAnnotations;
import org.jboss.kernel.plugins.annotations.AnnotationPluginFilter;
import org.jboss.kernel.plugins.annotations.MetaAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.MetaDataAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.MethodAnnotationPluginFilter;
import org.jboss.kernel.plugins.annotations.PropertyAnnotationPluginFilter;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.retrieval.RetrievalUtils;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.DeclaredMethodSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.AnnotatedInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonAnnotationAdapter<T extends MetaDataAnnotationPlugin<?, ?>, U> {
    protected Logger log = Logger.getLogger(this.getClass());
    private final Map<ElementType, Map<Class<? extends Annotation>, Set<T>>> pluginsMap = new HashMap<ElementType, Map<Class<? extends Annotation>, Set<T>>>();
    ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final AnnotationPluginFilter PROPERTY_FILTER = new PropertyAnnotationPluginFilter();
    private static final AnnotationPluginFilter METHOD_FILTER = new MethodAnnotationPluginFilter();
    private final Map<ElementType, Map<Class<? extends Annotation>, Set<T>>> metaAnnotationsPluginsMap = new HashMap<ElementType, Map<Class<? extends Annotation>, Set<T>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationPlugin(T plugin) {
        Set<ElementType> supported;
        if (plugin == null) {
            throw new IllegalArgumentException("Null plugin.");
        }
        Class annotation = plugin.getAnnotation();
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation class: " + plugin);
        }
        if (annotation.getAnnotation(Target.class) == null) {
            this.log.warn((Object)("Annotation " + annotation + " missing @Target annotation!"));
        }
        if (annotation.getAnnotation(Retention.class) == null) {
            this.log.warn((Object)("Annotation " + annotation + " missing @Retention annotation!"));
        }
        if ((supported = plugin.getSupportedTypes()) == null || supported.isEmpty()) {
            throw new IllegalArgumentException("Null or empty support types: " + plugin);
        }
        this.lock.writeLock().lock();
        try {
            for (ElementType type : supported) {
                Set<T> plugins;
                Map<Class<Annotation>, Set<T>> pluginsForType = this.pluginsMap.get((Object)type);
                if (pluginsForType == null) {
                    pluginsForType = new HashMap<Class<? extends Annotation>, Set<T>>();
                    this.pluginsMap.put(type, pluginsForType);
                }
                if ((plugins = pluginsForType.get(plugin.getAnnotation())) == null) {
                    plugins = new LinkedHashSet<T>();
                    pluginsForType.put(plugin.getAnnotation(), plugins);
                }
                plugins.add(plugin);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotationPlugin(T plugin) {
        if (plugin == null) {
            return;
        }
        Set<ElementType> supported = plugin.getSupportedTypes();
        if (supported == null || supported.isEmpty()) {
            throw new IllegalArgumentException("Null or empty support types: " + plugin);
        }
        this.lock.writeLock().lock();
        try {
            for (ElementType type : supported) {
                Map<Class<Annotation>, Set<T>> pluginsForType = this.pluginsMap.get((Object)type);
                if (pluginsForType == null) continue;
                Set<T> plugins = pluginsForType.get(plugin.getAnnotation());
                if (plugins != null) {
                    plugins.remove(plugin);
                    if (plugins.isEmpty()) {
                        pluginsForType.remove(plugin.getAnnotation());
                    }
                }
                if (!pluginsForType.isEmpty()) continue;
                this.pluginsMap.remove((Object)type);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetaAnnotationPlugin(T plugin) {
        Set<ElementType> supported;
        if (plugin == null) {
            throw new IllegalArgumentException("Null plugin.");
        }
        if (!(plugin instanceof MetaAnnotationPlugin)) {
            throw new IllegalArgumentException("Not a MetaAnnotationPlugin");
        }
        Class annotation = ((MetaAnnotationPlugin)plugin).getMetaAnnotation();
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation class: " + plugin);
        }
        if (annotation.getAnnotation(Target.class) == null) {
            this.log.warn((Object)("Annotation " + annotation + " missing @Target annotation!"));
        }
        if (annotation.getAnnotation(Retention.class) == null) {
            this.log.warn((Object)("Annotation " + annotation + " missing @Retention annotation!"));
        }
        if ((supported = plugin.getSupportedTypes()) == null || supported.isEmpty()) {
            throw new IllegalArgumentException("Null or empty support types: " + plugin);
        }
        this.lock.writeLock().lock();
        try {
            for (ElementType type : supported) {
                Set<T> plugins;
                Map<Class<Annotation>, Set<T>> pluginsForType = this.metaAnnotationsPluginsMap.get((Object)type);
                if (pluginsForType == null) {
                    pluginsForType = new HashMap<Class<? extends Annotation>, Set<T>>();
                    this.metaAnnotationsPluginsMap.put(type, pluginsForType);
                }
                if ((plugins = pluginsForType.get(((MetaAnnotationPlugin)plugin).getMetaAnnotation())) == null) {
                    plugins = new LinkedHashSet<T>();
                    pluginsForType.put(((MetaAnnotationPlugin)plugin).getMetaAnnotation(), plugins);
                }
                plugins.add(plugin);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetaAnnotationPlugin(T plugin) {
        if (plugin == null) {
            return;
        }
        Set<ElementType> supported = plugin.getSupportedTypes();
        if (supported == null || supported.isEmpty()) {
            throw new IllegalArgumentException("Null or empty support types: " + plugin);
        }
        this.lock.writeLock().lock();
        try {
            for (ElementType type : supported) {
                Map<Class<Annotation>, Set<T>> pluginsForType = this.metaAnnotationsPluginsMap.get((Object)type);
                if (pluginsForType == null) continue;
                Set<T> plugins = pluginsForType.get(((MetaAnnotationPlugin)plugin).getMetaAnnotation());
                if (plugins != null) {
                    plugins.remove(plugin);
                    if (plugins.isEmpty()) {
                        pluginsForType.remove(((MetaAnnotationPlugin)plugin).getMetaAnnotation());
                    }
                }
                if (!pluginsForType.isEmpty()) continue;
                this.metaAnnotationsPluginsMap.remove((Object)type);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected abstract void applyPlugin(T var1, Annotation var2, AnnotatedInfo var3, MetaData var4, U var5) throws Throwable;

    protected abstract void cleanPlugin(T var1, Annotation var2, AnnotatedInfo var3, MetaData var4, U var5) throws Throwable;

    protected abstract Object getName(U var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable<T> getPlugins(ElementType type, Annotation annotation, AnnotationPluginFilter filter, Collection<Class<? extends Annotation>> annotationClasses) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation");
        }
        if (annotationClasses != null && !annotationClasses.contains(annotation)) {
            return Collections.emptySet();
        }
        Set<T> plugins = null;
        this.lock.readLock().lock();
        try {
            Map<Class<Annotation>, Set<T>> pluginsForType = this.pluginsMap.get((Object)type);
            if (pluginsForType != null && (plugins = pluginsForType.get(annotation.annotationType())) != null && !plugins.isEmpty()) {
                plugins = new LinkedHashSet<T>(plugins);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (plugins == null || plugins.isEmpty()) {
            return Collections.emptySet();
        }
        if (filter != null) {
            ArrayList<MetaDataAnnotationPlugin> result = new ArrayList<MetaDataAnnotationPlugin>();
            for (MetaDataAnnotationPlugin plugin : plugins) {
                if (!filter.accept(plugin) || annotationClasses != null && !annotationClasses.contains(plugin.getAnnotation())) continue;
                result.add(plugin);
            }
            return result;
        }
        return plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Class<? extends Annotation>, Set<T>> getMetaAnnotationsForType(ElementType type) {
        this.lock.readLock().lock();
        try {
            Map<Class<Annotation>, Set<T>> metaAnnotationsForType = this.metaAnnotationsPluginsMap.get((Object)type);
            if (metaAnnotationsForType == null || metaAnnotationsForType.isEmpty()) {
                Map<Class<? extends Annotation>, Set<T>> map = Collections.emptyMap();
                return map;
            }
            HashMap<Class<Annotation>, Set<T>> clone = new HashMap<Class<Annotation>, Set<T>>();
            for (Map.Entry<Class<Annotation>, Set<T>> entry : metaAnnotationsForType.entrySet()) {
                clone.put(entry.getKey(), new LinkedHashSet(entry.getValue()));
            }
            HashMap<Class<Annotation>, Set<T>> hashMap = clone;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void handleAnnotations(BeanInfo info, MetaData retrieval, U handle, boolean isApplyPhase) throws Throwable {
        MethodInfo[] staticMethods;
        Set constructors;
        MCAnnotations annotations;
        if (info == null) {
            throw new IllegalArgumentException("Null bean info.");
        }
        if (retrieval == null) {
            throw new IllegalArgumentException("Null metadata.");
        }
        if (handle == null) {
            throw new IllegalArgumentException("Null handle.");
        }
        retrieval = RetrievalUtils.createCachedMetaData((MetaData)retrieval);
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)(this.getName(handle) + " apply annotations"));
        }
        if ((annotations = (MCAnnotations)retrieval.getAnnotation(MCAnnotations.class)) != null && (annotations.ignore() || annotations.value().length == 0)) {
            if (trace) {
                this.log.trace((Object)("Ignoring annotations lookup: " + annotations));
            }
            return;
        }
        List<Class<? extends Annotation>> annotationClasses = annotations != null ? Arrays.asList(annotations.value()) : null;
        ClassInfo classInfo = info.getClassInfo();
        for (Annotation annotation : retrieval.getAnnotations()) {
            for (MetaDataAnnotationPlugin plugin : this.getPlugins(ElementType.TYPE, annotation, null, annotationClasses)) {
                if (isApplyPhase) {
                    this.applyPlugin(plugin, annotation, (AnnotatedInfo)classInfo, retrieval, handle);
                    continue;
                }
                this.cleanPlugin(plugin, annotation, (AnnotatedInfo)classInfo, retrieval, handle);
            }
        }
        Map<Class<Annotation>, Set<T>> metaAnnotationsForType = this.getMetaAnnotationsForType(ElementType.TYPE);
        if (metaAnnotationsForType != null) {
            for (Map.Entry<Class<Annotation>, Set<T>> entry : metaAnnotationsForType.entrySet()) {
                for (Annotation annotation : retrieval.getAnnotationsAnnotatedWith(entry.getKey())) {
                    for (MetaDataAnnotationPlugin plugin : entry.getValue()) {
                        if (isApplyPhase) {
                            this.applyPlugin(plugin, annotation, (AnnotatedInfo)classInfo, retrieval, handle);
                            continue;
                        }
                        this.cleanPlugin(plugin, annotation, (AnnotatedInfo)classInfo, retrieval, handle);
                    }
                }
            }
        }
        if ((constructors = info.getConstructors()) != null && !constructors.isEmpty()) {
            for (ConstructorInfo ci : constructors) {
                ConstructorSignature cis = new ConstructorSignature(ci);
                MetaData cmdr = retrieval.getComponentMetaData((Signature)cis);
                if (cmdr != null) {
                    for (Annotation annotation : cmdr.getAnnotations()) {
                        for (MetaDataAnnotationPlugin plugin : this.getPlugins(ElementType.CONSTRUCTOR, annotation, null, annotationClasses)) {
                            if (isApplyPhase) {
                                this.applyPlugin(plugin, annotation, (AnnotatedInfo)ci, cmdr, handle);
                                continue;
                            }
                            this.cleanPlugin(plugin, annotation, (AnnotatedInfo)ci, cmdr, handle);
                        }
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for " + ci));
            }
        } else if (trace) {
            this.log.trace((Object)"No constructors");
        }
        HashSet<MethodInfo> visitedMethods = new HashSet<MethodInfo>();
        Set properties = info.getProperties();
        if (properties != null && !properties.isEmpty()) {
            for (PropertyInfo pi : properties) {
                FieldInfo field = pi.getFieldInfo();
                if (field != null) {
                    FieldSignature sis = new FieldSignature(field);
                    MetaData cmdr = retrieval.getComponentMetaData((Signature)sis);
                    if (cmdr != null) {
                        for (Annotation annotation : cmdr.getAnnotations()) {
                            for (MetaDataAnnotationPlugin plugin : this.getPlugins(ElementType.FIELD, annotation, null, annotationClasses)) {
                                if (isApplyPhase) {
                                    this.applyPlugin(plugin, annotation, (AnnotatedInfo)field, cmdr, handle);
                                    continue;
                                }
                                this.cleanPlugin(plugin, annotation, (AnnotatedInfo)field, cmdr, handle);
                            }
                        }
                    } else if (trace) {
                        this.log.trace((Object)("No annotations for field " + field.getName()));
                    }
                }
                this.handleMethod(retrieval, handle, isApplyPhase, trace, visitedMethods, pi, pi.getSetter(), "setter", annotationClasses);
                this.handleMethod(retrieval, handle, isApplyPhase, trace, visitedMethods, pi, pi.getGetter(), "getter", annotationClasses);
            }
        } else if (trace) {
            this.log.trace((Object)"No properties");
        }
        TypeInfoFactory tif = classInfo.getTypeInfoFactory();
        TypeInfo objectTI = tif.getTypeInfo(Object.class);
        Set methods = info.getMethods();
        if (methods != null && !methods.isEmpty()) {
            for (MethodInfo mi : methods) {
                ClassInfo declaringCI = mi.getDeclaringClass();
                if (declaringCI == objectTI || visitedMethods.contains(mi)) continue;
                DeclaredMethodSignature mis = new DeclaredMethodSignature(mi);
                MetaData cmdr = retrieval.getComponentMetaData((Signature)mis);
                if (cmdr != null) {
                    for (Annotation annotation : cmdr.getAnnotations()) {
                        for (MetaDataAnnotationPlugin plugin : this.getPlugins(ElementType.METHOD, annotation, METHOD_FILTER, annotationClasses)) {
                            if (isApplyPhase) {
                                this.applyPlugin(plugin, annotation, (AnnotatedInfo)mi, cmdr, handle);
                                continue;
                            }
                            this.cleanPlugin(plugin, annotation, (AnnotatedInfo)mi, cmdr, handle);
                        }
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for " + mi));
            }
        } else if (trace) {
            this.log.trace((Object)"No methods");
        }
        if ((staticMethods = this.getStaticMethods(classInfo)) != null && staticMethods.length != 0) {
            for (MethodInfo smi : staticMethods) {
                if (!smi.isStatic() || !smi.isPublic()) continue;
                DeclaredMethodSignature mis = new DeclaredMethodSignature(smi);
                MetaData cmdr = retrieval.getComponentMetaData((Signature)mis);
                if (cmdr != null) {
                    for (Annotation annotation : cmdr.getAnnotations()) {
                        for (MetaDataAnnotationPlugin plugin : this.getPlugins(ElementType.METHOD, annotation, METHOD_FILTER, annotationClasses)) {
                            if (isApplyPhase) {
                                this.applyPlugin(plugin, annotation, (AnnotatedInfo)smi, cmdr, handle);
                                continue;
                            }
                            this.cleanPlugin(plugin, annotation, (AnnotatedInfo)smi, cmdr, handle);
                        }
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for " + smi));
            }
        } else if (trace) {
            this.log.trace((Object)"No static methods");
        }
    }

    protected void handleMethod(MetaData retrieval, U handle, boolean isApplyPhase, boolean trace, Set<MethodInfo> visitedMethods, PropertyInfo pi, MethodInfo method, String type, Collection<Class<? extends Annotation>> annotationClasses) throws Throwable {
        if (method == null) {
            return;
        }
        visitedMethods.add(method);
        DeclaredMethodSignature sis = new DeclaredMethodSignature(method);
        MetaData cmdr = retrieval.getComponentMetaData((Signature)sis);
        if (cmdr != null) {
            for (Annotation annotation : cmdr.getAnnotations()) {
                for (MetaDataAnnotationPlugin plugin : this.getPlugins(ElementType.METHOD, annotation, PROPERTY_FILTER, annotationClasses)) {
                    if (isApplyPhase) {
                        this.applyPlugin(plugin, annotation, (AnnotatedInfo)pi, cmdr, handle);
                        continue;
                    }
                    this.cleanPlugin(plugin, annotation, (AnnotatedInfo)pi, cmdr, handle);
                }
            }
        } else if (trace) {
            this.log.trace((Object)("No annotations for " + type + ": " + pi.getName()));
        }
    }

    protected MethodInfo[] getStaticMethods(ClassInfo classInfo) {
        return classInfo.getDeclaredMethods();
    }
}

