package org.jboss.kernel.plugins.qualifier;

import java.util.Set;

import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.qualifier.QualifierMatcher;

/**
 * The default Matcher implementation.
 * 
 * It checks if the qualifier exists in the context's standard supplied qualifiers using Object.equals(Object) 
 * when comparing. 
 * @see QualifierMatcher#matches(ControllerContext, Set, Object)
 */
public class DefaultEqualsMatcher implements QualifierMatcher<Object>
{
   public static final QualifierMatcher SINGLETON = new DefaultEqualsMatcher();
   
   private DefaultEqualsMatcher()
   {
   }
   
   public boolean matches(ControllerContext context, Set<Object> suppliedQualifiers, Object qualifier)
   {
      return suppliedQualifiers.contains(qualifier);
   }

   public Class<Object> getHandledType()
   {
      return Object.class;
   }
}