/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.beans.metadata.plugins;

import java.util.HashSet;
import java.util.Set;

import javax.xml.bind.annotation.XmlAttribute;

import org.jboss.beans.metadata.api.model.QualifierContent;
import org.jboss.kernel.spi.qualifier.QualifierMatchers;
import org.jboss.kernel.spi.qualifier.QualifierParser;

/**
 * Abstract Qualifier MetaData. Qualifiers are used to narrow down what is injected
 * when doing contextul injection (by bean type) 
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public abstract class AbstractQualifierMetaData extends AbstractRelatedClassMetaData
{
   private static final long serialVersionUID = 1L;
   
   private volatile QualifierContent content = QualifierContent.STRING;
   
   private volatile Set<Object> parsedQualifiers;
   
   public AbstractQualifierMetaData()
   {
   }
   
   @Override
   @XmlAttribute(name="name")
   public void setClassName(String classname)
   {
      throw new IllegalStateException("Class name can not be set for qualifiers");
   }
   
   protected void internalSetClassName(String classname)
   {
      super.setClassName(classname);
   }

   /**
    * Get how the qualifier content should be parsed. The default is STRING
    * 
    * @return the content
    */
   public QualifierContent getContent()
   {
      return content;
   }

   /**
    * Set how the qualifier content should be parsed. If not set, the default is STRING
    * 
    * @param content the content to set
    */
   @XmlAttribute(name="content")
   public void setContent(QualifierContent content)
   {
      this.content = content;
   }

   @Override
   public Set<Object> getEnabled()
   {
      return getEnabled((ClassLoader)null);
   }
   
   public Set<Object> getEnabled(ClassLoader cl)
   {
      Set<Object> enableds = super.getEnabled();
      if (enableds == null || enableds.size() == 0)
         return enableds;
      
      QualifierParser parser = QualifierMatchers.getInstance().getParser(content);

      if (parsedQualifiers == null)
      {
         Set<Object> qualifiers = new HashSet<Object>();
         for(Object enabled : enableds)
         {
            qualifiers.add(parse(cl, parser, enabled));
         }
         parsedQualifiers = qualifiers;
      }
      return parsedQualifiers;
   }
   
   protected abstract Object parse(ClassLoader cl, QualifierParser parser, Object enabled);
}
