/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.beans.metadata.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Creates a map that can be used as a parameter
 * <pre>
 *  &#64;MapValue(keyClass=java.lang.String.class, 
 *         valueClass=java.lang.String.class, 
 *         {&#64EntryValue(key=&#64;Value(string=&#64;StringValue("foo.bar.key")), 
 *                      value=&#64;Value(string=&#64;StringValue("QWERT"))), 
 *          &#64;EntryValue(key=&#64;Value(string=&#64;StringValue("xyz.key")), 
 *                      value=&#64;Value(string=&#64;StringValue("QWERTY"))) 
 *        }) 
 * public void setMap(Map<String, String> map) {} 
 * </pre>
 * creates a collection of the type <code>org.jboss.example.CustomList</code>, where all the elements are of type String.
 *
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.PARAMETER})
public @interface MapValue
{
   /**
    * Get the map class. If absent, the default type is java.util.HashMap 
    *
    * @return the map class
    */
   Class<?> clazz() default void.class;

   /**
    * Get the key class.
    *
    * @return the key class
    */
   Class<?> keyClass() default void.class;

   /**
    * Get the value class name.
    *
    * @return the value class name
    */
   Class<?> valueClass() default void.class;

   /**
    * Get the array containing this map's entries.
    *
    * @return the entries
    */
   EntryValue[] value();
}
