/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
import org.jboss.logging.Logger;

class SecurityActions {
    private static final Logger log = Logger.getLogger(SecurityActions.class);

    SecurityActions() {
    }

    private static ClassLoader setContextClassLoaderInternal(ControllerContext context) {
        ClassLoader result = Thread.currentThread().getContextClassLoader();
        if (context instanceof InvokeDispatchContext) {
            ClassLoader cl;
            block4: {
                cl = null;
                InvokeDispatchContext invokeContext = (InvokeDispatchContext)((Object)context);
                try {
                    cl = invokeContext.getClassLoader();
                }
                catch (Throwable t) {
                    if (!log.isTraceEnabled()) break block4;
                    log.trace((Object)("Not setting classloader for " + context.getName() + " reason:" + context));
                }
            }
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        return result;
    }

    static ClassLoader setContextClassLoader(final ControllerContext context) {
        if (System.getSecurityManager() == null) {
            return SecurityActions.setContextClassLoaderInternal(context);
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return SecurityActions.setContextClassLoaderInternal(context);
            }
        });
    }

    private static ClassLoader setContextClassLoaderInternal(ClassLoader classLoader) {
        ClassLoader result = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        return result;
    }

    static ClassLoader setContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            return SecurityActions.setContextClassLoaderInternal(classLoader);
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return SecurityActions.setContextClassLoaderInternal(classLoader);
            }
        });
    }

    static void resetContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

