/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.impl.remote;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.jboss.jpa.impl.deployment.PersistenceUnitInfoImpl;
import org.jboss.logging.Logger;
import org.jboss.metadata.jpa.spec.PersistenceUnitMetaData;
import org.jboss.metadata.jpa.spec.TransactionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotelyInjectEntityManagerFactory
implements EntityManagerFactory,
Serializable {
    private static final Logger log = Logger.getLogger(RemotelyInjectEntityManagerFactory.class);
    private static final long serialVersionUID = 1L;
    private PersistenceUnitMetaData metaData;
    private EntityManagerFactory actualFactory;
    private Properties defaultPersistenceProperties = new Properties();
    private List<String> explicitEntityClasses = new ArrayList<String>();
    private String jaccContextId;

    public RemotelyInjectEntityManagerFactory(PersistenceUnitMetaData metaData, String jaccContextId) {
        assert (metaData != null) : "metaData is null";
        this.metaData = metaData;
        this.jaccContextId = jaccContextId;
    }

    public void close() {
        throw new RuntimeException("NYI");
    }

    private void createEntityManagerFactory() throws Exception {
        log.debug((Object)"Booting up the entity manager factory");
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.defaultPersistenceProperties);
        props.put("hibernate.jacc.ctx.id", this.getJaccContextId());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<URL> jarFiles = new ArrayList<URL>();
        InitialContext ctx = new InitialContext();
        PersistenceUnitInfoImpl pi = new PersistenceUnitInfoImpl(this.metaData, props, classLoader, this.getPersistenceUnitRoot(), jarFiles, ctx);
        Class<?> providerClass = Thread.currentThread().getContextClassLoader().loadClass(pi.getPersistenceProviderClassName());
        PersistenceProvider pp = (PersistenceProvider)providerClass.newInstance();
        this.actualFactory = pp.createContainerEntityManagerFactory((PersistenceUnitInfo)pi, null);
    }

    public EntityManager createEntityManager() {
        return this.actualFactory.createEntityManager();
    }

    public EntityManager createEntityManager(Map map) {
        return this.actualFactory.createEntityManager(map);
    }

    protected String getJaccContextId() {
        return this.jaccContextId;
    }

    protected PersistenceUnitTransactionType getJPATransactionType() {
        TransactionType type = this.metaData.getTransactionType();
        if (type == TransactionType.RESOURCE_LOCAL) {
            return PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        return PersistenceUnitTransactionType.JTA;
    }

    protected URL getPersistenceUnitRoot() throws IOException {
        ArrayList<URL> list = new ArrayList<URL>();
        Enumeration<URL> e = Thread.currentThread().getContextClassLoader().getResources("META-INF/persistence.xml");
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        if (list.size() > 1) {
            log.warn((Object)("Found multiple persistence units on the classpath, will use the first one of " + list));
        }
        if (list.size() == 0) {
            throw new IllegalStateException("Can't find META-INF/persistence.xml");
        }
        URL url = (URL)list.get(0);
        String spec = url.toExternalForm();
        spec = spec.substring(0, spec.length() - "META-INF/persistence.xml".length());
        return new URL(spec);
    }

    public boolean isOpen() {
        throw new RuntimeException("NYI");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.createEntityManagerFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> safeList(Set<String> set) {
        return set == null || set.isEmpty() ? Collections.emptyList() : new ArrayList<String>(set);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        log.trace((Object)"writeObject");
        out.defaultWriteObject();
    }
}

