/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.security.SecurityPermission;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;

public final class PolicyContext {
    private static SecurityPermission setPolicy = new SecurityPermission("setPolicy");
    private static SecurityPermission getPolicy = new SecurityPermission("getPolicy");
    private static ThreadLocal handlerDataLocal = new ThreadLocal();
    private static ThreadLocal contextIDLocal = new ThreadLocal();
    private static Map handlerMap = Collections.synchronizedMap(new HashMap());

    public static Object getContext(String key) throws PolicyContextException {
        PolicyContextHandler handler;
        if (key == null || !handlerMap.containsKey(key)) {
            throw new IllegalArgumentException("No PolicyContextHandler for key=" + key);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getPolicy);
        }
        if (!(handler = (PolicyContextHandler)handlerMap.get(key)).supports(key)) {
            throw new IllegalArgumentException("PolicyContextHandler does not support key=" + key);
        }
        Object data = handlerDataLocal.get();
        Object context = handler.getContext(key, data);
        return context;
    }

    public static String getContextID() {
        String contextID = (String)contextIDLocal.get();
        return contextID;
    }

    public static Set getHandlerKeys() {
        return handlerMap.keySet();
    }

    public static void registerHandler(String key, PolicyContextHandler handler, boolean replace) throws PolicyContextException {
        if (key == null) {
            throw new IllegalArgumentException("The key may not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("The handler may not be null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPolicy);
        }
        if (!replace && handlerMap.containsKey(key)) {
            String msg = "Handler for key=" + key + ", exists, handler: " + handlerMap.get(key);
            throw new IllegalArgumentException(msg);
        }
        handlerMap.put(key, handler);
    }

    public static void setContextID(String contextID) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPolicy);
        }
        contextIDLocal.set(contextID);
    }

    public static void setHandlerData(Object data) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPolicy);
        }
        handlerDataLocal.set(data);
    }

    private PolicyContext() {
    }
}

