/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public abstract class AnnotationValue {
    static final AnnotationValue[] EMPTY_VALUE_ARRAY = new AnnotationValue[0];
    private final String name;

    AnnotationValue(String name) {
        this.name = name;
    }

    public final String name() {
        return this.name;
    }

    public abstract Object value();

    public int asInt() {
        throw new IllegalArgumentException("Not a number");
    }

    public long asLong() {
        throw new IllegalArgumentException("Not a number");
    }

    public short asShort() {
        throw new IllegalArgumentException("not a number");
    }

    public byte asByte() {
        throw new IllegalArgumentException("not a number");
    }

    public float asFloat() {
        throw new IllegalArgumentException("not a number");
    }

    public double asDouble() {
        throw new IllegalArgumentException("not a number");
    }

    public char asChar() {
        throw new IllegalArgumentException("not a character");
    }

    public boolean asBoolean() {
        throw new IllegalArgumentException("not a boolean");
    }

    public String asString() {
        return this.value().toString();
    }

    public String asEnum() {
        throw new IllegalArgumentException("not an enum");
    }

    public DotName asEnumType() {
        throw new IllegalArgumentException("not an enum");
    }

    public Type asClass() {
        throw new IllegalArgumentException("not a class");
    }

    public AnnotationInstance asNested() {
        throw new IllegalArgumentException("not a nested annotation");
    }

    AnnotationValue[] asArray() {
        throw new IllegalArgumentException("Not an array");
    }

    public int[] asIntArray() {
        throw new IllegalArgumentException("Not a numerical array");
    }

    public long[] asLongArray() {
        throw new IllegalArgumentException("Not a numerical array");
    }

    public short[] asShortArray() {
        throw new IllegalArgumentException("not a numerical array");
    }

    public byte[] asByteArray() {
        throw new IllegalArgumentException("not a numerical array");
    }

    public float[] asFloatArray() {
        throw new IllegalArgumentException("not a numerical array");
    }

    public double[] asDoubleArray() {
        throw new IllegalArgumentException("not a numerical array");
    }

    public char[] asCharArray() {
        throw new IllegalArgumentException("not a character array");
    }

    public boolean[] asBooleanArray() {
        throw new IllegalArgumentException("not a boolean array");
    }

    public String[] asStringArray() {
        throw new IllegalArgumentException("not a string array");
    }

    public String[] asEnumArray() {
        throw new IllegalArgumentException("not an enum array");
    }

    public DotName[] asEnumTypeArray() {
        throw new IllegalArgumentException("not an enum array");
    }

    public Type[] asClassArray() {
        throw new IllegalArgumentException("not a class array");
    }

    public AnnotationInstance[] asNestedArray() {
        throw new IllegalArgumentException("not a nested annotation array");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.name.length() > 0) {
            builder.append(this.name).append(" = ");
        }
        return builder.append(this.value()).toString();
    }

    static final class ArrayValue
    extends AnnotationValue {
        private final AnnotationValue[] value;

        ArrayValue(String name, AnnotationValue[] value) {
            super(name);
            this.value = value.length > 0 ? value : EMPTY_VALUE_ARRAY;
        }

        public AnnotationValue[] value() {
            return this.value;
        }

        @Override
        AnnotationValue[] asArray() {
            return this.value;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (((AnnotationValue)this).name.length() > 0) {
                builder.append(((AnnotationValue)this).name).append(" = ");
            }
            builder.append('[');
            int i = 0;
            while (i < this.value.length) {
                builder.append(this.value[i]);
                if (i < this.value.length - 1) {
                    builder.append(',');
                }
                ++i;
            }
            return builder.append(']').toString();
        }

        @Override
        public int[] asIntArray() {
            int length = this.value.length;
            int[] array = new int[length];
            int i = 0;
            while (i < length) {
                array[i] = this.value[i].asInt();
                ++i;
            }
            return array;
        }

        @Override
        public long[] asLongArray() {
            int length = this.value.length;
            long[] array = new long[length];
            int i = 0;
            while (i < length) {
                array[i] = this.value[i].asLong();
                ++i;
            }
            return array;
        }

        @Override
        public short[] asShortArray() {
            int length = this.value.length;
            short[] array = new short[length];
            int i = 0;
            while (i < length) {
                array[i] = this.value[i].asShort();
                ++i;
            }
            return array;
        }

        @Override
        public byte[] asByteArray() {
            int length = this.value.length;
            byte[] array = new byte[length];
            int i = 0;
            while (i < length) {
                array[i] = this.value[i].asByte();
                ++i;
            }
            return array;
        }

        @Override
        public float[] asFloatArray() {
            int length = this.value.length;
            float[] array = new float[length];
            int i = 0;
            while (i < length) {
                array[i] = this.value[i].asFloat();
                ++i;
            }
            return array;
        }

        @Override
        public double[] asDoubleArray() {
            int length = this.value.length;
            double[] array = new double[length];
            int i = 0;
            while (i < length) {
                array[i] = this.value[i].asDouble();
                ++i;
            }
            return array;
        }

        @Override
        public char[] asCharArray() {
            int length = this.value.length;
            char[] array = new char[length];
            int i = 0;
            while (i < length) {
                array[i] = this.value[i].asChar();
                ++i;
            }
            return array;
        }

        @Override
        public boolean[] asBooleanArray() {
            int length = this.value.length;
            boolean[] array = new boolean[length];
            int i = 0;
            while (i < length) {
                array[i] = this.value[i].asBoolean();
                ++i;
            }
            return array;
        }

        @Override
        public String[] asStringArray() {
            int length = this.value.length;
            String[] array = new String[length];
            int i = 0;
            while (i < length) {
                array[i] = this.value[i].asString();
                ++i;
            }
            return array;
        }

        @Override
        public String[] asEnumArray() {
            int length = this.value.length;
            String[] array = new String[length];
            int i = 0;
            while (i < length) {
                array[i] = this.value[i].asEnum();
                ++i;
            }
            return array;
        }

        @Override
        public Type[] asClassArray() {
            int length = this.value.length;
            Type[] array = new Type[length];
            int i = 0;
            while (i < length) {
                array[i] = this.value[i].asClass();
                ++i;
            }
            return array;
        }

        @Override
        public AnnotationInstance[] asNestedArray() {
            int length = this.value.length;
            AnnotationInstance[] array = new AnnotationInstance[length];
            int i = 0;
            while (i < length) {
                array[i] = this.value[i].asNested();
                ++i;
            }
            return array;
        }

        @Override
        public DotName[] asEnumTypeArray() {
            int length = this.value.length;
            DotName[] array = new DotName[length];
            int i = 0;
            while (i < length) {
                array[i] = this.value[i].asEnumType();
                ++i;
            }
            return array;
        }
    }

    static final class BooleanValue
    extends AnnotationValue {
        private final boolean value;

        BooleanValue(String name, boolean value) {
            super(name);
            this.value = value;
        }

        @Override
        public Boolean value() {
            return this.value;
        }

        @Override
        public boolean asBoolean() {
            return this.value;
        }
    }

    static final class ByteValue
    extends AnnotationValue {
        private final byte value;

        ByteValue(String name, byte value) {
            super(name);
            this.value = value;
        }

        @Override
        public Byte value() {
            return this.value;
        }

        @Override
        public int asInt() {
            return this.value;
        }

        @Override
        public long asLong() {
            return this.value;
        }

        @Override
        public short asShort() {
            return this.value;
        }

        @Override
        public byte asByte() {
            return this.value;
        }

        @Override
        public float asFloat() {
            return this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }
    }

    static final class CharacterValue
    extends AnnotationValue {
        private final char value;

        CharacterValue(String name, char value) {
            super(name);
            this.value = value;
        }

        @Override
        public Character value() {
            return Character.valueOf(this.value);
        }

        @Override
        public char asChar() {
            return this.value;
        }
    }

    static final class ClassValue
    extends AnnotationValue {
        private final Type type;

        ClassValue(String name, Type type) {
            super(name);
            this.type = type;
        }

        @Override
        public Type value() {
            return this.type;
        }

        @Override
        public Type asClass() {
            return this.type;
        }
    }

    static final class DoubleValue
    extends AnnotationValue {
        private final double value;

        public DoubleValue(String name, double value) {
            super(name);
            this.value = value;
        }

        @Override
        public Double value() {
            return this.value;
        }

        @Override
        public int asInt() {
            return (int)this.value;
        }

        @Override
        public long asLong() {
            return (long)this.value;
        }

        @Override
        public short asShort() {
            return (short)this.value;
        }

        @Override
        public byte asByte() {
            return (byte)this.value;
        }

        @Override
        public float asFloat() {
            return (float)this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }
    }

    static final class EnumValue
    extends AnnotationValue {
        private final String value;
        private final DotName typeName;

        EnumValue(String name, DotName typeName, String value) {
            super(name);
            this.typeName = typeName;
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String asEnum() {
            return this.value;
        }

        @Override
        public DotName asEnumType() {
            return this.typeName;
        }
    }

    static final class FloatValue
    extends AnnotationValue {
        private final float value;

        FloatValue(String name, float value) {
            super(name);
            this.value = value;
        }

        @Override
        public Float value() {
            return Float.valueOf(this.value);
        }

        @Override
        public int asInt() {
            return (int)this.value;
        }

        @Override
        public long asLong() {
            return (long)this.value;
        }

        @Override
        public short asShort() {
            return (short)this.value;
        }

        @Override
        public byte asByte() {
            return (byte)this.value;
        }

        @Override
        public float asFloat() {
            return this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }
    }

    static final class IntegerValue
    extends AnnotationValue {
        private final int value;

        IntegerValue(String name, int value) {
            super(name);
            this.value = value;
        }

        @Override
        public Integer value() {
            return this.value;
        }

        @Override
        public int asInt() {
            return this.value;
        }

        @Override
        public long asLong() {
            return this.value;
        }

        @Override
        public short asShort() {
            return (short)this.value;
        }

        @Override
        public byte asByte() {
            return (byte)this.value;
        }

        @Override
        public float asFloat() {
            return this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }
    }

    static final class LongValue
    extends AnnotationValue {
        private final long value;

        LongValue(String name, long value) {
            super(name);
            this.value = value;
        }

        @Override
        public Long value() {
            return this.value;
        }

        @Override
        public int asInt() {
            return (int)this.value;
        }

        @Override
        public long asLong() {
            return this.value;
        }

        @Override
        public short asShort() {
            return (short)this.value;
        }

        @Override
        public byte asByte() {
            return (byte)this.value;
        }

        @Override
        public float asFloat() {
            return this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }
    }

    static final class NestedAnnotation
    extends AnnotationValue {
        private final AnnotationInstance value;

        NestedAnnotation(String name, AnnotationInstance value) {
            super(name);
            this.value = value;
        }

        @Override
        public AnnotationInstance value() {
            return this.value;
        }

        @Override
        public AnnotationInstance asNested() {
            return this.value;
        }
    }

    static final class ShortValue
    extends AnnotationValue {
        private final short value;

        ShortValue(String name, short value) {
            super(name);
            this.value = value;
        }

        @Override
        public Short value() {
            return this.value;
        }

        @Override
        public int asInt() {
            return this.value;
        }

        @Override
        public long asLong() {
            return this.value;
        }

        @Override
        public short asShort() {
            return this.value;
        }

        @Override
        public byte asByte() {
            return (byte)this.value;
        }

        @Override
        public float asFloat() {
            return this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }
    }

    static final class StringValue
    extends AnnotationValue {
        private final String value;

        StringValue(String name, String value) {
            super(name);
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (((AnnotationValue)this).name.length() > 0) {
                builder.append(((AnnotationValue)this).name).append(" = ");
            }
            return builder.append('\"').append(this.value).append('\"').toString();
        }
    }
}

