/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.metadata;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.metadata.Metadata;
import org.jboss.shrinkwrap.descriptor.metadata.filter.AttributeFilter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.AttributeGroupFilter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.ComplexTypeFilter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.ElementFilter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.EnumFilter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.ExtensionFilter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.Filter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.GroupFilter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.ListFilter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.RestrictionFilter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.UnionFilter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;

public class FilterChain {
    private static final String ELEMENT_LOG = "%s- %s name: %s";
    private final List<Filter> filterList = new ArrayList<Filter>();

    public FilterChain() {
        this.filterList.add(new GroupFilter());
        this.filterList.add(new ElementFilter());
        this.filterList.add(new EnumFilter());
        this.filterList.add(new AttributeFilter());
        this.filterList.add(new AttributeGroupFilter());
        this.filterList.add(new RestrictionFilter());
        this.filterList.add(new ComplexTypeFilter());
        this.filterList.add(new ExtensionFilter());
        this.filterList.add(new UnionFilter());
        this.filterList.add(new ListFilter());
    }

    public void traverseAndFilter(TreeWalker walker, String indent, Metadata metadata, StringBuilder sb) {
        Node parend = walker.getCurrentNode();
        boolean isLogged = this.appendText(indent, (Element)parend, sb);
        for (Filter filter : this.filterList) {
            if (!filter.filter(metadata, walker)) continue;
            this.appendText(" catched by: " + filter.getClass().getSimpleName(), sb);
            break;
        }
        if (isLogged) {
            this.appendText("\n", sb);
        }
        Node n = walker.firstChild();
        while (n != null) {
            this.traverseAndFilter(walker, indent + "  ", metadata, sb);
            n = walker.nextSibling();
        }
        walker.setCurrentNode(parend);
    }

    private boolean appendText(String text, StringBuilder sb) {
        if (sb != null && text != null && text.indexOf(":annotation") < 0 && text.indexOf(":documentation") < 0) {
            sb.append(text);
            return true;
        }
        return false;
    }

    private boolean appendText(String indent, Element element, StringBuilder sb) {
        if (sb != null && element.getTagName().indexOf(":annotation") < 0 && element.getTagName().indexOf(":documentation") < 0) {
            sb.append(String.format(ELEMENT_LOG, indent, element.getTagName(), element.getAttribute("name")));
            return true;
        }
        return false;
    }
}

