/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logmanager.ConfigurationLocator;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.DefaultConfigurationLocator;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.PropertyConfigurator;

public final class LogManager
extends java.util.logging.LogManager {
    private final AtomicBoolean configured = new AtomicBoolean();

    public LogManager() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                Object outField;
                Class<java.util.logging.Level> lc = java.util.logging.Level.class;
                try {
                    Class<java.util.logging.Level> clazz = lc;
                    synchronized (clazz) {
                        Field knownField = lc.getDeclaredField("known");
                        knownField.setAccessible(true);
                        List old = (List)knownField.get(null);
                        if (!(old instanceof ReadOnlyArrayList)) {
                            knownField.set(null, new ReadOnlyArrayList(Arrays.asList(Level.TRACE, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, Level.FATAL, java.util.logging.Level.ALL, java.util.logging.Level.FINEST, java.util.logging.Level.FINER, java.util.logging.Level.FINE, java.util.logging.Level.INFO, java.util.logging.Level.CONFIG, java.util.logging.Level.WARNING, java.util.logging.Level.SEVERE, java.util.logging.Level.OFF)));
                        }
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    Class<?> traceManagerClass = Class.forName("com.sun.jmx.trace.Trace");
                    outField = traceManagerClass.getDeclaredField("out");
                    ((Field)outField).setAccessible(true);
                    ((Field)outField).set(null, null);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                Class<java.util.logging.LogManager> lmc = java.util.logging.LogManager.class;
                try {
                    outField = lmc;
                    synchronized (outField) {
                        Field loggingMXBean = lmc.getDeclaredField("loggingMXBean");
                        loggingMXBean.setAccessible(true);
                        loggingMXBean.set(null, LogContext.getSystemLogContext().getLoggingMXBean());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private static String tryGetProperty(String name, String defaultVal) {
        try {
            return System.getProperty(name, defaultVal);
        }
        catch (Throwable t) {
            return defaultVal;
        }
    }

    @Override
    public void readConfiguration() throws IOException, SecurityException {
        InputStream configuration;
        this.checkAccess();
        if (this.configured.getAndSet(true)) {
            return;
        }
        String confLocClassName = LogManager.tryGetProperty("org.jboss.logmanager.configurationLocator", null);
        ConfigurationLocator locator = null;
        if (confLocClassName != null) {
            locator = LogManager.construct(ConfigurationLocator.class, confLocClassName);
        } else {
            ServiceLoader<ConfigurationLocator> loader;
            Iterator<ConfigurationLocator> iterator;
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl != null && (iterator = (loader = ServiceLoader.load(ConfigurationLocator.class, tccl)).iterator()).hasNext()) {
                locator = iterator.next();
            }
            if (locator == null) {
                loader = ServiceLoader.load(ConfigurationLocator.class, tccl != null ? tccl : LogManager.class.getClassLoader());
                iterator = loader.iterator();
                locator = iterator.hasNext() ? iterator.next() : new DefaultConfigurationLocator();
            }
        }
        if (locator != null && (configuration = locator.findConfiguration()) != null) {
            this.readConfiguration(configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readConfiguration(InputStream inputStream) throws IOException, SecurityException {
        try {
            this.checkAccess();
            this.configured.set(true);
            String confClassName = LogManager.tryGetProperty("org.jboss.logmanager.configurator", null);
            Configurator configurator = null;
            if (confClassName != null) {
                configurator = LogManager.construct(Configurator.class, confClassName);
            } else {
                ServiceLoader<Configurator> loader;
                Iterator<Configurator> iterator;
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                if (tccl != null && (iterator = (loader = ServiceLoader.load(Configurator.class, tccl)).iterator()).hasNext()) {
                    configurator = iterator.next();
                }
                if (configurator == null) {
                    loader = ServiceLoader.load(Configurator.class, LogManager.class.getClassLoader());
                    iterator = loader.iterator();
                    configurator = iterator.hasNext() ? iterator.next() : new PropertyConfigurator();
                }
            }
            if (configurator != null) {
                try {
                    configurator.configure(inputStream);
                    LogContext.getSystemLogContext().getLogger("").attach(Configurator.ATTACHMENT_KEY, configurator);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    static <T> T construct(Class<? extends T> type, String className) throws IOException {
        try {
            Class<?> clazz = null;
            try {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                if (tccl != null) {
                    clazz = Class.forName(className, true, tccl);
                }
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = Class.forName(className, true, LogManager.class.getClassLoader());
            }
            return type.cast(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            IOException ioe = new IOException("Unable to load configuration class " + className);
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public String getProperty(String name) {
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    public Enumeration<String> getLoggerNames() {
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public String nextElement() {
                throw new NoSuchElementException("No elements");
            }
        };
    }

    @Override
    public boolean addLogger(java.util.logging.Logger logger2) {
        return false;
    }

    @Override
    public Logger getLogger(String name) {
        return LogContext.getLogContext().getLogger(name);
    }

    private static final class ReadOnlyArrayList<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = -6048215349511680936L;

        private ReadOnlyArrayList(Collection<? extends T> c) {
            super(c);
        }

        @Override
        public T set(int index, T element) {
            return null;
        }

        @Override
        public T remove(int index) {
            return null;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
        }

        @Override
        public Iterator<T> iterator() {
            final Iterator superIter = super.iterator();
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return superIter.hasNext();
                }

                @Override
                public T next() {
                    return superIter.next();
                }

                @Override
                public void remove() {
                }
            };
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            final ListIterator superIter = super.listIterator(index);
            return new ListIterator<T>(){

                @Override
                public boolean hasNext() {
                    return superIter.hasNext();
                }

                @Override
                public T next() {
                    return superIter.next();
                }

                @Override
                public boolean hasPrevious() {
                    return superIter.hasPrevious();
                }

                @Override
                public T previous() {
                    return superIter.previous();
                }

                @Override
                public int nextIndex() {
                    return superIter.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return superIter.previousIndex();
                }

                @Override
                public void remove() {
                }

                @Override
                public void set(T o) {
                }

                @Override
                public void add(T o) {
                }
            };
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }
    }
}

