/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.common;

import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.Security;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public class SecurityImpl
implements Security {
    private static final long serialVersionUID = 1L;
    private static CommonBundle bundle = Messages.getBundle(CommonBundle.class);
    private String securityDomainManaged;
    private String securityDomainAndApplicationManaged;
    private boolean applicationManaged;

    public SecurityImpl(String securityDomainManaged, String securityDomainAndApplicationManaged, boolean applicationManaged) throws ValidateException {
        this.securityDomainManaged = securityDomainManaged;
        this.securityDomainAndApplicationManaged = securityDomainAndApplicationManaged;
        this.applicationManaged = applicationManaged;
        this.validate();
    }

    @Override
    public String getSecurityDomain() {
        return this.securityDomainManaged;
    }

    @Override
    public String getSecurityDomainAndApplication() {
        return this.securityDomainAndApplicationManaged;
    }

    @Override
    public boolean isApplication() {
        return this.applicationManaged;
    }

    @Override
    public String resolveSecurityDomain() {
        if (this.securityDomainManaged != null && !this.securityDomainManaged.trim().equals("")) {
            return this.securityDomainManaged;
        }
        return this.securityDomainAndApplicationManaged;
    }

    @Override
    public void validate() throws ValidateException {
        if (this.securityDomainManaged != null && !this.securityDomainManaged.trim().equals("")) {
            if (this.securityDomainAndApplicationManaged != null && !this.securityDomainAndApplicationManaged.trim().equals("")) {
                throw new ValidateException(bundle.invalidSecurityConfiguration());
            }
            if (this.applicationManaged) {
                throw new ValidateException(bundle.invalidSecurityConfiguration());
            }
        } else if (this.securityDomainAndApplicationManaged != null && !this.securityDomainAndApplicationManaged.trim().equals("") ? this.applicationManaged : !this.applicationManaged) {
            throw new ValidateException(bundle.invalidSecurityConfiguration());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.applicationManaged ? 1231 : 1237);
        result = 31 * result + (this.securityDomainAndApplicationManaged == null ? 0 : this.securityDomainAndApplicationManaged.hashCode());
        result = 31 * result + (this.securityDomainManaged == null ? 0 : this.securityDomainManaged.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityImpl)) {
            return false;
        }
        SecurityImpl other = (SecurityImpl)obj;
        if (this.applicationManaged != other.applicationManaged) {
            return false;
        }
        if (this.securityDomainAndApplicationManaged == null ? other.securityDomainAndApplicationManaged != null : !this.securityDomainAndApplicationManaged.equals(other.securityDomainAndApplicationManaged)) {
            return false;
        }
        return !(this.securityDomainManaged == null ? other.securityDomainManaged != null : !this.securityDomainManaged.equals(other.securityDomainManaged));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<security>");
        if (this.applicationManaged) {
            sb.append("<").append((Object)Security.Tag.APPLICATION).append("/>");
        } else if (this.securityDomainManaged != null) {
            sb.append("<").append((Object)Security.Tag.SECURITY_DOMAIN).append(">");
            sb.append(this.securityDomainManaged);
            sb.append("</").append((Object)Security.Tag.SECURITY_DOMAIN).append(">");
        } else if (this.securityDomainAndApplicationManaged != null) {
            sb.append("<").append((Object)Security.Tag.SECURITY_DOMAIN_AND_APPLICATION).append(">");
            sb.append(this.securityDomainAndApplicationManaged);
            sb.append("</").append((Object)Security.Tag.SECURITY_DOMAIN_AND_APPLICATION).append(">");
        }
        sb.append("</security>");
        return sb.toString();
    }
}

