/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.ErrorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArrayAssert
extends ArrayAssert<IntArrayAssert, int[]> {
    protected IntArrayAssert(int ... actual) {
        super(IntArrayAssert.class, actual);
    }

    public IntArrayAssert contains(int ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    public IntArrayAssert containsOnly(int ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    public IntArrayAssert excludes(int ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    @Override
    public IntArrayAssert isEqualTo(int[] expected) {
        if (Arrays.equals((int[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Override
    public IntArrayAssert isNotEqualTo(int[] array) {
        if (!Arrays.equals((int[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }
}

