/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.metadata;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataDescriptor;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataElement;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataEnum;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataItem;
import org.jboss.shrinkwrap.descriptor.metadata.filter.XsdDatatypeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metadata {
    private final List<MetadataItem> dataTypeList = new ArrayList<MetadataItem>();
    private final List<MetadataEnum> enumList = new ArrayList<MetadataEnum>();
    private final List<MetadataItem> groupList = new ArrayList<MetadataItem>();
    private final List<MetadataItem> classList = new ArrayList<MetadataItem>();
    private final List<String> packageApiList = new ArrayList<String>();
    private final List<String> packageImplList = new ArrayList<String>();
    private List<MetadataDescriptor> metadataDescriptorList = new ArrayList<MetadataDescriptor>();
    private String currentNamespace;
    private String currentSchmema;
    private String currentPackageApi;
    private String currentPackageImpl;

    public List<MetadataDescriptor> getMetadataDescriptorList() {
        return this.metadataDescriptorList;
    }

    public void setMetadataDescriptorList(List<MetadataDescriptor> metadataDescriptorList) {
        this.metadataDescriptorList = metadataDescriptorList;
    }

    public String getCurrentNamespace() {
        return this.currentNamespace;
    }

    public void setCurrentNamespace(String currentNamespace) {
        this.currentNamespace = currentNamespace;
    }

    public String getCurrentSchmema() {
        return this.currentSchmema;
    }

    public void setCurrentSchmema(String currentSchmema) {
        this.currentSchmema = currentSchmema;
    }

    public String getCurrentPackageApi() {
        return this.currentPackageApi;
    }

    public void setCurrentPackageApi(String currentPackageApi) {
        this.currentPackageApi = currentPackageApi;
        this.packageApiList.add(currentPackageApi);
    }

    public String getCurrentPackageImpl() {
        return this.currentPackageImpl;
    }

    public void setCurrentPackageImpl(String currentPackageImpl) {
        this.currentPackageImpl = currentPackageImpl;
        this.packageImplList.add(currentPackageImpl);
    }

    public List<MetadataItem> getDataTypeList() {
        return this.dataTypeList;
    }

    public List<MetadataEnum> getEnumList() {
        return this.enumList;
    }

    public List<MetadataItem> getGroupList() {
        return this.groupList;
    }

    public List<MetadataItem> getClassList() {
        return this.classList;
    }

    public List<String> getPackageApiList() {
        return this.packageApiList;
    }

    public List<String> getPackageImplList() {
        return this.packageImplList;
    }

    public void addEnumValue(String enumName, String enumValue) {
        for (MetadataEnum instance : this.enumList) {
            if (!instance.getName().equals(enumName) || !instance.getNamespace().equals(this.getCurrentNamespace())) continue;
            instance.addValue(enumValue);
            return;
        }
        MetadataEnum newEnum = new MetadataEnum(enumName);
        newEnum.addValue(enumValue);
        newEnum.setNamespace(this.getCurrentNamespace());
        newEnum.setSchemaName(this.getCurrentSchmema());
        newEnum.setPackageApi(this.getCurrentPackageApi());
        this.enumList.add(newEnum);
    }

    public void addGroupElement(String groupName, MetadataElement groupElement) {
        for (MetadataItem item : this.groupList) {
            if (!item.getName().equals(groupName) || !item.getNamespace().equals(this.getCurrentNamespace())) continue;
            item.getElements().add(groupElement);
            return;
        }
        MetadataItem newItem = new MetadataItem(groupName);
        newItem.getElements().add(groupElement);
        newItem.setNamespace(this.getCurrentNamespace());
        newItem.setSchemaName(this.getCurrentSchmema());
        newItem.setPackageApi(this.getCurrentPackageApi());
        newItem.setPackageImpl(this.getCurrentPackageImpl());
        this.groupList.add(newItem);
    }

    public void addGroupReference(String groupName, MetadataElement groupReference) {
        groupReference.setRef(this.getNamespaceValue(groupReference.getRef()));
        for (MetadataItem item : this.groupList) {
            if (!item.getName().equals(groupName) || !item.getNamespace().equals(this.getCurrentNamespace())) continue;
            item.getReferences().add(groupReference);
            return;
        }
        MetadataItem newItem = new MetadataItem(groupName);
        newItem.getReferences().add(groupReference);
        newItem.setNamespace(this.getCurrentNamespace());
        newItem.setSchemaName(this.getCurrentSchmema());
        newItem.setPackageApi(this.getCurrentPackageApi());
        newItem.setPackageImpl(this.getCurrentPackageImpl());
        this.groupList.add(newItem);
    }

    public void addClassElement(String className, MetadataElement classElement) {
        classElement.setType(this.getNamespaceValue(classElement.getType()));
        for (MetadataItem item : this.classList) {
            if (!item.getName().equals(className) || !item.getNamespace().equals(this.getCurrentNamespace()) || !item.getPackageApi().equals(this.getCurrentPackageApi())) continue;
            for (MetadataElement element : item.getElements()) {
                if (!element.getName().equals(classElement.getName())) continue;
                element.setMaxOccurs("unbounded");
                return;
            }
            item.getElements().add(classElement);
            return;
        }
        MetadataItem newItem = new MetadataItem(className);
        newItem.getElements().add(classElement);
        newItem.setNamespace(this.getCurrentNamespace());
        newItem.setSchemaName(this.getCurrentSchmema());
        newItem.setPackageApi(this.getCurrentPackageApi());
        newItem.setPackageImpl(this.getCurrentPackageImpl());
        this.classList.add(newItem);
    }

    public void addClassReference(String className, MetadataElement classReference) {
        classReference.setRef(this.getNamespaceValue(classReference.getRef()));
        for (MetadataItem item : this.classList) {
            if (!item.getName().equals(className) || !item.getNamespace().equals(this.getCurrentNamespace()) || !item.getPackageApi().equals(this.getCurrentPackageApi())) continue;
            item.getReferences().add(classReference);
            return;
        }
        MetadataItem newItem = new MetadataItem(className);
        newItem.getReferences().add(classReference);
        newItem.setNamespace(this.getCurrentNamespace());
        newItem.setSchemaName(this.getCurrentSchmema());
        newItem.setPackageApi(this.getCurrentPackageApi());
        newItem.setPackageImpl(this.getCurrentPackageImpl());
        this.classList.add(newItem);
    }

    public void preResolveDataTypes() {
        for (MetadataItem metadataClass : this.classList) {
            this.preResolveDataTypeImpl(metadataClass);
        }
        for (MetadataItem metadataClass : this.groupList) {
            this.preResolveDataTypeImpl(metadataClass);
        }
    }

    private String getNamespaceValue(String value) {
        if (value == null || value.contains(":") || value.equals("text")) {
            return value;
        }
        return this.getCurrentNamespace() + ":" + value;
    }

    private void preResolveDataTypeImpl(MetadataItem metadataClass) {
        for (MetadataElement element : metadataClass.getElements()) {
            for (MetadataItem dataType : this.getDataTypeList()) {
                String str = dataType.getNamespace() + ":" + dataType.getName();
                if (!str.equals(element.getType())) continue;
                element.setType(dataType.getMappedTo());
            }
            element.setType(element.getType().replace("xs:", "xsd:"));
            if (element.getType().contains(":") || !XsdDatatypeEnum.integer.isDataType("xsd:" + element.getType())) continue;
            element.setType("xsd:" + element.getType());
        }
    }
}

