/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.jboss.jca.common.CommonLogger;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.metadata.ironjacamar.IronJacamarParser;
import org.jboss.jca.common.metadata.spec.RaParser;
import org.jboss.logging.Logger;

public class MetadataFactory {
    private static CommonLogger log = Logger.getMessageLogger(CommonLogger.class, MetadataFactory.class.getName());

    public Connector getStandardMetaData(File root) throws Exception {
        Connector result = null;
        File metadataFile = new File(root, "/META-INF/ra.xml");
        if (metadataFile.exists()) {
            String url = metadataFile.getAbsolutePath();
            try (InputStream input = null;){
                long start = System.currentTimeMillis();
                input = new FileInputStream(metadataFile);
                result = new RaParser().parse(input);
                log.debugf("Total parse for %s took %d ms", (Object)url, (Object)(System.currentTimeMillis() - start));
            }
        } else {
            log.tracef("metadata file %s does not exist", (Object)metadataFile.toString());
        }
        return result;
    }

    public Activation getIronJacamarMetaData(File root) throws Exception {
        Activation result = null;
        File metadataFile = new File(root, "/META-INF/ironjacamar.xml");
        if (metadataFile.exists()) {
            String url = metadataFile.getAbsolutePath();
            try (InputStream input = null;){
                long start = System.currentTimeMillis();
                input = new FileInputStream(metadataFile);
                result = new IronJacamarParser().parse(input);
                log.debugf("Total parse for %s took %d ms", (Object)url, (Object)(System.currentTimeMillis() - start));
            }
        }
        return result;
    }
}

