/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.JavaExtensionLibrary;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Validation;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.SaxonCollation;
import net.sf.saxon.style.SaxonImportQuery;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetFunctionLibrary;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLDecimalFormat;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGeneralIncorporate;
import net.sf.saxon.style.XSLImport;
import net.sf.saxon.style.XSLImportSchema;
import net.sf.saxon.style.XSLInclude;
import net.sf.saxon.style.XSLKey;
import net.sf.saxon.style.XSLNamespaceAlias;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLPreserveSpace;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.Whitespace;

public class XSLStylesheet
extends StyleElement {
    Executable exec = new Executable();
    private LocationMap locationMap = new LocationMap();
    private HashMap globalVariableIndex = new HashMap(20);
    private NamePool targetNamePool;
    private boolean wasIncluded = false;
    private int precedence = 0;
    private int minImportPrecedence = 0;
    private XSLStylesheet importer = null;
    private PreparedStylesheet stylesheet;
    private List topLevel;
    private HashMap templateIndex = new HashMap(20);
    private int inputAnnotations = 0;
    public static final int ANNOTATION_STRIP = 1;
    public static final int ANNOTATION_PRESERVE = 2;
    private HashSet schemaIndex = new HashSet(10);
    private XQueryFunctionLibrary queryFunctions;
    private FunctionLibrary javaFunctions;
    private int numberOfAliases = 0;
    private ArrayList namespaceAliasList = new ArrayList(5);
    private short[] aliasSCodes;
    private int[] aliasNCodes;
    private int largestPatternStackFrame = 0;
    private int defaultValidation = 4;
    private FunctionLibraryList functionLibrary;
    private boolean needsDynamicOutputProperties = false;

    public void setPreparedStylesheet(PreparedStylesheet preparedStylesheet) {
        Configuration configuration = preparedStylesheet.getConfiguration();
        this.stylesheet = preparedStylesheet;
        this.targetNamePool = preparedStylesheet.getTargetNamePool();
        this.exec.setConfiguration(configuration);
        this.exec.setRuleManager(new RuleManager());
        this.exec.setLocationMap(this.locationMap);
        this.exec.setHostLanguage(50);
        this.functionLibrary = new FunctionLibraryList();
        this.functionLibrary.addFunctionLibrary(new SystemFunctionLibrary(1));
        this.functionLibrary.addFunctionLibrary(new StylesheetFunctionLibrary(this, true));
        this.functionLibrary.addFunctionLibrary(configuration.getVendorFunctionLibrary());
        this.functionLibrary.addFunctionLibrary(new ConstructorFunctionLibrary(configuration));
        this.queryFunctions = new XQueryFunctionLibrary(configuration);
        this.functionLibrary.addFunctionLibrary(this.queryFunctions);
        if (configuration.isAllowExternalFunctions()) {
            this.javaFunctions = configuration.getExtensionBinder();
            this.functionLibrary.addFunctionLibrary(this.javaFunctions);
        }
        this.functionLibrary.addFunctionLibrary(new StylesheetFunctionLibrary(this, false));
    }

    public PreparedStylesheet getPreparedStylesheet() {
        if (this.importer != null) {
            return this.importer.getPreparedStylesheet();
        }
        return this.stylesheet;
    }

    public Executable getExecutable() {
        return this.exec;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public NamePool getTargetNamePool() {
        return this.targetNamePool;
    }

    public RuleManager getRuleManager() {
        return this.exec.getRuleManager();
    }

    protected Mode getStripperRules() {
        if (this.exec.getStripperRules() == null) {
            this.exec.setStripperRules(new Mode(-4));
        }
        return this.exec.getStripperRules();
    }

    public boolean stripsWhitespace() {
        for (int i = 0; i < this.topLevel.size(); ++i) {
            NodeInfo nodeInfo = (NodeInfo)this.topLevel.get(i);
            if (nodeInfo.getFingerprint() != 179) continue;
            return true;
        }
        return false;
    }

    public KeyManager getKeyManager() {
        if (this.exec.getKeyManager() == null) {
            this.exec.setKeyManager(new KeyManager(this.getConfiguration()));
        }
        return this.exec.getKeyManager();
    }

    public DecimalFormatManager getDecimalFormatManager() {
        if (this.exec.getDecimalFormatManager() == null) {
            this.exec.setDecimalFormatManager(new DecimalFormatManager());
        }
        return this.exec.getDecimalFormatManager();
    }

    public void setCollation(String string, Comparator comparator, boolean bl) {
        if (this.exec.getCollationTable() == null) {
            this.exec.setCollationTable(new HashMap(20));
        }
        this.exec.getCollationTable().put(string, comparator);
        if (bl) {
            this.exec.setDefaultCollationName(string);
        }
    }

    protected Comparator findCollation(String string) {
        if (string.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        Comparator comparator = null;
        if (string == null) {
            string = this.exec.getDefaultCollationName();
        }
        if (this.exec.getCollationTable() != null) {
            comparator = (Comparator)this.exec.getCollationTable().get(string);
        }
        if (comparator != null) {
            return comparator;
        }
        XSLStylesheet xSLStylesheet = this.getPrincipalStylesheet();
        List list = xSLStylesheet.getTopLevel();
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!(list.get(i) instanceof SaxonCollation)) continue;
            SaxonCollation saxonCollation = (SaxonCollation)list.get(i);
            if (string == null && saxonCollation.isDefaultCollation()) {
                this.exec.setDefaultCollationName(saxonCollation.getCollationName());
                return saxonCollation.getCollator();
            }
            if (!saxonCollation.getCollationName().equals(string)) continue;
            return saxonCollation.getCollator();
        }
        if (string == null) {
            return null;
        }
        Configuration configuration = this.getConfiguration();
        return configuration.getCollationURIResolver().resolve(string, this.getBaseURI(), configuration);
    }

    public String getDefaultCollationName() {
        return this.exec.getDefaultCollationName();
    }

    public XSLCharacterMap getCharacterMap(int n) {
        for (int i = this.topLevel.size() - 1; i >= 0; --i) {
            XSLCharacterMap xSLCharacterMap;
            if (!(this.topLevel.get(i) instanceof XSLCharacterMap) || (xSLCharacterMap = (XSLCharacterMap)this.topLevel.get(i)).getCharacterMapFingerprint() != n) continue;
            return xSLCharacterMap;
        }
        return null;
    }

    public void setPrecedence(int n) {
        this.precedence = n;
    }

    public int getPrecedence() {
        if (this.wasIncluded) {
            return this.importer.getPrecedence();
        }
        return this.precedence;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public void setMinImportPrecedence(int n) {
        this.minImportPrecedence = n;
    }

    public void setImporter(XSLStylesheet xSLStylesheet) {
        this.importer = xSLStylesheet;
    }

    public XSLStylesheet getImporter() {
        return this.importer;
    }

    public void setWasIncluded() {
        this.wasIncluded = true;
    }

    public List getTopLevel() {
        return this.topLevel;
    }

    public int allocateGlobalSlot(int n) {
        return this.exec.getGlobalVariableMap().allocateSlotNumber(n);
    }

    public void allocatePatternSlots(int n) {
        if (n > this.largestPatternStackFrame) {
            this.largestPatternStackFrame = n;
        }
    }

    public void prepareAttributes() throws XPathException {
        String string = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string2 = this.getNamePool().getClarkName(n);
            if (string2 == "version") {
                this.processVersionAttribute(string2);
                continue;
            }
            if (string2 == "id" || string2 == "extension-element-prefixes" || string2 == "exclude-result-prefixes") continue;
            if (string2 == "default-validation") {
                this.defaultValidation = Validation.getCode(attributeCollection.getValue(i));
                if (this.defaultValidation != -1) continue;
                this.compileError("Invalid value for default-validation attribute. Permitted values are (strict, lax, preserve, strip)", "XTSE0020");
                continue;
            }
            if (string2 == "input-type-annotations") {
                string = attributeCollection.getValue("", string2);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (this.version == null) {
            this.reportAbsence("version");
        }
        if (string != null) {
            if (string.equals("strip")) {
                this.setInputTypeAnnotations(1);
            } else if (string.equals("preserve")) {
                this.setInputTypeAnnotations(2);
            } else if (!string.equals("unspecified")) {
                this.compileError("Invalid value for input-type-annotations attribute. Permitted values are (strip, preserve, unspecified)", "XTSE0020");
            }
        }
    }

    public int getDefaultValidation() {
        return this.defaultValidation;
    }

    public int getInputTypeAnnotationsAttribute() throws XPathException {
        String string = this.getAttributeValue("input-type-annotations");
        if (string != null) {
            if (string.equals("strip")) {
                this.setInputTypeAnnotations(1);
            } else if (string.equals("preserve")) {
                this.setInputTypeAnnotations(2);
            } else if (!string.equals("unspecified")) {
                this.compileError("Invalid value for input-type-annotations attribute. Permitted values are (strip, preserve, unspecified)", "XTSE0020");
            }
        }
        return this.inputAnnotations;
    }

    public int getInputTypeAnnotations() {
        return this.inputAnnotations;
    }

    public void setInputTypeAnnotations(int n) throws XPathException {
        this.inputAnnotations |= n;
        if (this.inputAnnotations == 3) {
            this.compileError("One stylesheet module specifies input-type-annotations='strip', another specifies input-type-annotations='preserve'", "XTSE0265");
        }
    }

    protected int getNamespaceAlias(short s) {
        for (int i = 0; i < this.numberOfAliases; ++i) {
            if (s != this.aliasSCodes[i]) continue;
            return this.aliasNCodes[i];
        }
        return s;
    }

    protected boolean isAliasResultNamespace(short s) {
        for (int i = 0; i < this.numberOfAliases; ++i) {
            if (s != (this.aliasNCodes[i] & 0xFFFF)) continue;
            return true;
        }
        return false;
    }

    public void validate() throws XPathException {
        NodeInfo nodeInfo;
        if (this.validationError != null) {
            this.compileError(this.validationError);
        }
        if (this.getParent().getNodeKind() != 9) {
            this.compileError(this.getDisplayName() + " must be the outermost element", "XTSE0010");
        }
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo.getNodeKind() == 3 || nodeInfo instanceof XSLTemplate || nodeInfo instanceof XSLImport || nodeInfo instanceof XSLInclude || nodeInfo instanceof XSLAttributeSet || nodeInfo instanceof XSLCharacterMap || nodeInfo instanceof XSLDecimalFormat || nodeInfo instanceof XSLFunction || nodeInfo instanceof XSLImportSchema || nodeInfo instanceof XSLKey || nodeInfo instanceof XSLNamespaceAlias || nodeInfo instanceof XSLOutput || nodeInfo instanceof XSLParam || nodeInfo instanceof XSLPreserveSpace || nodeInfo instanceof XSLVariable || nodeInfo instanceof XSLParam || nodeInfo instanceof DataElement || !"http://www.w3.org/1999/XSL/Transform".equals(nodeInfo.getURI()) && !"".equals(nodeInfo.getURI()) || nodeInfo instanceof AbsentExtensionElement && ((StyleElement)nodeInfo).forwardsCompatibleModeIsEnabled()) continue;
            ((StyleElement)nodeInfo).compileError("Element " + nodeInfo.getDisplayName() + " must not appear directly within " + this.getDisplayName(), "XTSE0010");
        }
    }

    public void preprocess() throws XPathException {
        Object e;
        int n;
        this.spliceIncludes();
        this.buildIndexes();
        this.processAllAttributes();
        this.collectNamespaceAliases();
        for (n = 0; n < this.topLevel.size(); ++n) {
            e = this.topLevel.get(n);
            if (!(e instanceof StyleElement)) continue;
            ((StyleElement)e).fixupReferences();
        }
        this.validate();
        for (n = 0; n < this.topLevel.size(); ++n) {
            e = this.topLevel.get(n);
            if (!(e instanceof StyleElement)) continue;
            ((StyleElement)e).validateSubtree();
        }
    }

    public void spliceIncludes() throws XPathException {
        NodeInfo nodeInfo;
        boolean bl = false;
        this.topLevel = new ArrayList(50);
        this.minImportPrecedence = this.precedence;
        StyleElement styleElement = this;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo.getNodeKind() == 3) {
                if (Whitespace.isWhite(nodeInfo.getStringValueCS())) continue;
                styleElement.compileError("No character data is allowed between top-level elements", "XTSE0010");
                continue;
            }
            if (nodeInfo instanceof DataElement) {
                bl = true;
                continue;
            }
            styleElement = (StyleElement)nodeInfo;
            if (nodeInfo instanceof XSLGeneralIncorporate) {
                XSLStylesheet xSLStylesheet;
                XSLGeneralIncorporate xSLGeneralIncorporate = (XSLGeneralIncorporate)nodeInfo;
                xSLGeneralIncorporate.processAttributes();
                if (xSLGeneralIncorporate.isImport()) {
                    if (bl) {
                        xSLGeneralIncorporate.compileError("xsl:import elements must come first", "XTSE0010");
                    }
                } else {
                    bl = true;
                }
                if ((xSLStylesheet = xSLGeneralIncorporate.getIncludedStylesheet(this, this.precedence)) == null) {
                    return;
                }
                if (xSLGeneralIncorporate.isImport()) {
                    this.precedence = xSLStylesheet.getPrecedence() + 1;
                } else {
                    this.precedence = xSLStylesheet.getPrecedence();
                    xSLStylesheet.setMinImportPrecedence(this.minImportPrecedence);
                    xSLStylesheet.setWasIncluded();
                }
                List list = xSLStylesheet.topLevel;
                for (int i = 0; i < list.size(); ++i) {
                    StyleElement styleElement2 = (StyleElement)list.get(i);
                    int n = this.topLevel.size() - 1;
                    if (n < 0 || styleElement2.getPrecedence() >= ((StyleElement)this.topLevel.get(n)).getPrecedence()) {
                        this.topLevel.add(styleElement2);
                        continue;
                    }
                    while (n >= 0 && styleElement2.getPrecedence() < ((StyleElement)this.topLevel.get(n)).getPrecedence()) {
                        --n;
                    }
                    this.topLevel.add(n + 1, styleElement2);
                }
                continue;
            }
            bl = true;
            this.topLevel.add(nodeInfo);
        }
    }

    private void buildIndexes() throws XPathException {
        Object object;
        for (int i = this.topLevel.size() - 1; i >= 0; --i) {
            object = this.topLevel.get(i);
            if (object instanceof XSLTemplate) {
                this.indexNamedTemplate((XSLTemplate)object);
                continue;
            }
            if (object instanceof XSLVariableDeclaration) {
                this.indexVariableDeclaration((XSLVariableDeclaration)object);
                continue;
            }
            if (object instanceof XSLNamespaceAlias) {
                this.namespaceAliasList.add(object);
                ++this.numberOfAliases;
                continue;
            }
            if (object instanceof XSLImportSchema) {
                try {
                    ((XSLImportSchema)object).readSchema();
                    continue;
                }
                catch (SchemaException schemaException) {
                    throw StaticError.makeStaticError(schemaException);
                }
            }
            if (object instanceof XSLDecimalFormat) {
                ((XSLDecimalFormat)object).register();
                continue;
            }
            if (!(object instanceof SaxonImportQuery)) continue;
            ((SaxonImportQuery)object).importModule();
        }
        Configuration configuration = this.getConfiguration();
        object = this.schemaIndex.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            configuration.sealNamespace(string);
        }
    }

    private void indexVariableDeclaration(XSLVariableDeclaration xSLVariableDeclaration) throws XPathException {
        int n = xSLVariableDeclaration.getVariableFingerprint();
        if (n != -1) {
            Integer n2 = new Integer(n);
            XSLVariableDeclaration xSLVariableDeclaration2 = (XSLVariableDeclaration)this.globalVariableIndex.get(n2);
            if (xSLVariableDeclaration2 == null) {
                this.globalVariableIndex.put(n2, xSLVariableDeclaration);
            } else {
                int n3;
                int n4 = xSLVariableDeclaration.getPrecedence();
                if (n4 == (n3 = xSLVariableDeclaration2.getPrecedence())) {
                    xSLVariableDeclaration.compileError("Duplicate global variable declaration (see line " + xSLVariableDeclaration2.getLineNumber() + " of " + xSLVariableDeclaration2.getSystemId() + ')', "XTSE0630");
                } else if (n4 < n3) {
                    xSLVariableDeclaration.setRedundant();
                } else {
                    xSLVariableDeclaration2.setRedundant();
                    this.globalVariableIndex.put(n2, xSLVariableDeclaration);
                }
            }
        }
    }

    private void indexNamedTemplate(XSLTemplate xSLTemplate) throws XPathException {
        int n = xSLTemplate.getTemplateFingerprint();
        if (n != -1) {
            Integer n2 = new Integer(n);
            XSLTemplate xSLTemplate2 = (XSLTemplate)this.templateIndex.get(n2);
            if (xSLTemplate2 == null) {
                this.templateIndex.put(n2, xSLTemplate);
            } else {
                int n3;
                int n4 = xSLTemplate.getPrecedence();
                if (n4 == (n3 = xSLTemplate2.getPrecedence())) {
                    xSLTemplate.compileError("Duplicate named template (see line " + xSLTemplate2.getLineNumber() + " of " + xSLTemplate2.getSystemId() + ')', "XTSE0660");
                } else if (n4 >= n3) {
                    this.templateIndex.put(n2, xSLTemplate);
                }
            }
            this.exec.putNamedTemplate(n, xSLTemplate.getCompiledTemplate());
        }
    }

    private void collectNamespaceAliases() throws XPathException {
        this.aliasSCodes = new short[this.numberOfAliases];
        this.aliasNCodes = new int[this.numberOfAliases];
        int n = 0;
        int n2 = -1;
        for (int i = 0; i < this.numberOfAliases; ++i) {
            XSLNamespaceAlias xSLNamespaceAlias = (XSLNamespaceAlias)this.namespaceAliasList.get(i);
            short s = xSLNamespaceAlias.getStylesheetURICode();
            int n3 = xSLNamespaceAlias.getResultNamespaceCode();
            int n4 = xSLNamespaceAlias.getPrecedence();
            if (n2 != n4) {
                n2 = n4;
                n = i;
            }
            for (int j = n; j < i; ++j) {
                if (s != this.aliasSCodes[j] || (n3 & 0xFFFF) == (this.aliasNCodes[j] & 0xFFFF)) continue;
                xSLNamespaceAlias.compileError("More than one alias is defined for the same namespace prefix", "XTSE0810");
            }
            this.aliasSCodes[i] = s;
            this.aliasNCodes[i] = n3;
        }
        this.namespaceAliasList = null;
    }

    protected boolean hasNamespaceAliases() {
        return this.numberOfAliases > 0;
    }

    public void processAllAttributes() throws XPathException {
        this.prepareAttributes();
        if (this.topLevel == null) {
            return;
        }
        for (int i = 0; i < this.topLevel.size(); ++i) {
            Object e = this.topLevel.get(i);
            if (!(e instanceof StyleElement)) continue;
            try {
                ((StyleElement)e).processAllAttributes();
                continue;
            }
            catch (XPathException xPathException) {
                ((StyleElement)e).compileError(xPathException);
            }
        }
    }

    public XSLVariableDeclaration getGlobalVariable(int n) {
        return (XSLVariableDeclaration)this.globalVariableIndex.get(new Integer(n));
    }

    public void setNeedsDynamicOutputProperties(boolean bl) {
        this.needsDynamicOutputProperties = bl;
    }

    public Properties gatherOutputProperties(int n) throws XPathException {
        boolean bl = n == -1;
        Properties properties = new Properties();
        HashMap hashMap = new HashMap(10);
        for (int i = this.topLevel.size() - 1; i >= 0; --i) {
            XSLOutput xSLOutput;
            Object e = this.topLevel.get(i);
            if (!(e instanceof XSLOutput) || (xSLOutput = (XSLOutput)e).getOutputFingerprint() != n) continue;
            bl = true;
            xSLOutput.gatherOutputProperties(properties, hashMap);
        }
        if (!bl) {
            this.compileError("Requested output format " + (n == -1 ? "(unnamed)" : this.getNamePool().getClarkName(n)) + " has not been defined");
        }
        return properties;
    }

    protected void declareXQueryFunction(XQueryFunction xQueryFunction) throws XPathException {
        this.queryFunctions.declareFunction(xQueryFunction);
    }

    protected void declareJavaClass(String string, Class clazz) {
        if (!(this.javaFunctions instanceof JavaExtensionLibrary)) {
            throw new IllegalStateException("saxon:script cannot be used with a custom extension library factory");
        }
        ((JavaExtensionLibrary)this.javaFunctions).declareJavaClass(string, clazz);
    }

    protected boolean isImportedSchema(String string) {
        return this.schemaIndex.contains(string);
    }

    protected void addImportedSchema(String string) {
        this.schemaIndex.add(string);
    }

    protected HashSet getImportedSchemaTable() {
        return this.schemaIndex;
    }

    public Executable compileStylesheet() throws XPathException {
        try {
            Object object;
            Expression expression;
            Object object2;
            try {
                Iterator iterator = this.queryFunctions.getFunctionDefinitions();
                while (iterator.hasNext()) {
                    object2 = (XQueryFunction)iterator.next();
                    ((XQueryFunction)object2).fixupReferences(this.getStaticContext());
                }
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
            for (int i = 0; i < this.topLevel.size(); ++i) {
                StyleElement styleElement;
                object2 = (NodeInfo)this.topLevel.get(i);
                if (!(object2 instanceof StyleElement) || !((expression = (styleElement = (StyleElement)object2).compile(this.exec)) instanceof ComputedExpression)) continue;
                ((ComputedExpression)expression).setLocationId(this.allocateLocationId(this.getSystemId(), styleElement.getLineNumber()));
            }
            if (this.exec.getDecimalFormatManager() != null) {
                try {
                    this.exec.getDecimalFormatManager().fixupDefaultDefault();
                }
                catch (StaticError staticError) {
                    this.compileError(staticError.getMessage(), staticError.getErrorCodeLocalPart());
                }
            }
            this.exec.setStripsWhitespace(this.stripsWhitespace());
            Properties properties = this.gatherOutputProperties(-1);
            properties.setProperty("{http://saxon.sf.net/}stylesheet-version", this.getVersion().toString());
            this.exec.setDefaultOutputProperties(properties);
            if (this.needsDynamicOutputProperties) {
                object2 = new IntHashSet(5);
                for (int i = 0; i < this.topLevel.size(); ++i) {
                    int n;
                    expression = this.topLevel.get(i);
                    if (!(expression instanceof XSLOutput) || (n = ((XSLOutput)(object = (XSLOutput)((Object)expression))).getOutputFingerprint()) == -1) continue;
                    ((IntHashSet)object2).add(n);
                }
                if (((IntHashSet)object2).isEmpty()) {
                    this.compileError("The stylesheet contains xsl:result-document instructions that calculate the output format name at run-time, but there are no named xsl:output declarations");
                } else {
                    IntIterator intIterator = ((IntHashSet)object2).iterator();
                    while (intIterator.hasNext()) {
                        int n = intIterator.next();
                        object = this.gatherOutputProperties(n);
                        this.exec.setOutputProperties(n, (Properties)object);
                    }
                }
            }
            this.exec.setPatternSlotSpace(this.largestPatternStackFrame);
            this.exec.setStripsInputTypeAnnotations(this.inputAnnotations == 1);
            for (int i = 0; i < this.topLevel.size(); ++i) {
                XSLCharacterMap xSLCharacterMap;
                if (!(this.topLevel.get(i) instanceof XSLCharacterMap) || (xSLCharacterMap = (XSLCharacterMap)this.topLevel.get(i)).isRedundant()) continue;
                int n = xSLCharacterMap.getCharacterMapFingerprint();
                object = new IntHashMap(20);
                xSLCharacterMap.assemble((IntHashMap)object);
                if (this.exec.getCharacterMapIndex() == null) {
                    this.exec.setCharacterMapIndex(new IntHashMap(20));
                }
                this.exec.getCharacterMapIndex().put(n, object);
            }
            ExecutableFunctionLibrary executableFunctionLibrary = new ExecutableFunctionLibrary(this.getConfiguration());
            ExecutableFunctionLibrary executableFunctionLibrary2 = new ExecutableFunctionLibrary(this.getConfiguration());
            for (int i = 0; i < this.topLevel.size(); ++i) {
                object = this.topLevel.get(i);
                if (!(object instanceof XSLFunction)) continue;
                XSLFunction xSLFunction = (XSLFunction)object;
                if (xSLFunction.isOverriding()) {
                    executableFunctionLibrary.addFunction(xSLFunction.getCompiledFunction());
                    continue;
                }
                executableFunctionLibrary2.addFunction(xSLFunction.getCompiledFunction());
            }
            FunctionLibraryList functionLibraryList = new FunctionLibraryList();
            functionLibraryList.addFunctionLibrary(new SystemFunctionLibrary(1));
            functionLibraryList.addFunctionLibrary(executableFunctionLibrary);
            functionLibraryList.addFunctionLibrary(this.getConfiguration().getVendorFunctionLibrary());
            functionLibraryList.addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
            functionLibraryList.addFunctionLibrary(this.queryFunctions);
            if (this.getConfiguration().isAllowExternalFunctions()) {
                functionLibraryList.addFunctionLibrary(this.javaFunctions);
            }
            functionLibraryList.addFunctionLibrary(executableFunctionLibrary2);
            this.exec.setFunctionLibrary(functionLibraryList);
            return this.exec;
        }
        catch (RuntimeException runtimeException) {
            if (this.getPreparedStylesheet().getErrorCount() > 0) {
                return this.exec;
            }
            throw runtimeException;
        }
    }

    public Expression compile(Executable executable) {
        return null;
    }
}

