/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class ActivationCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public class " + this.getClassName(def));
        this.writeLeftCurlyBracket(out, 0);
        this.writeEol(out);
        int indent = 1;
        this.writeIndent(out, indent);
        out.write("/** The resource adapter */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private " + def.getRaClass() + " ra;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** Activation spec */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private " + def.getAsClass() + " spec;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** The message endpoint factory */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private MessageEndpointFactory endpointFactory;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Default constructor");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @exception ResourceException Thrown if an error occurs");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public " + this.getClassName(def) + "() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("this(null, null, null);");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Constructor");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param ra " + def.getRaClass());
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param endpointFactory MessageEndpointFactory");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param spec " + def.getAsClass());
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @exception ResourceException Thrown if an error occurs");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public " + this.getClassName(def) + "(" + def.getRaClass() + " ra, ");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("MessageEndpointFactory endpointFactory,");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write(def.getAsClass() + " spec) throws ResourceException");
        this.writeEol(out);
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("this.ra = ra;");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("this.endpointFactory = endpointFactory;");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("this.spec = spec;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeGetAs(def, out, indent);
        this.writeMef(def, out, indent);
        this.writeStartStop(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ".inflow;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import " + def.getRaPackage() + "." + def.getRaClass() + ";");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import jakarta.resource.ResourceException;");
        this.writeEol(out);
        out.write("import jakarta.resource.spi.endpoint.MessageEndpointFactory;");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getActivationClass();
    }

    private void writeGetAs(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Get activation spec class");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Activation spec");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public " + def.getAsClass() + " getActivationSpec()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return spec;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeMef(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Get message endpoint factory");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Message endpoint factory");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public MessageEndpointFactory getMessageEndpointFactory()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return endpointFactory;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeStartStop(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Start the activation");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws ResourceException Thrown if an error occurs");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void start() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Stop the activation");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void stop()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

