/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jboss.jca.codegenerator.ConfigPropType;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.Version;
import org.jboss.jca.codegenerator.code.PropsCodeGen;

public class AsCodeGen
extends PropsCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        if (def.isUseAnnotation()) {
            if (!def.isDefaultPackageInbound()) {
                out.write("@Activation(messageListeners = { " + def.getMlClass() + ".class })");
            } else {
                out.write("@Activation(messageListeners = { " + def.getRaPackage() + ".inflow." + def.getMlClass() + ".class })");
            }
            this.writeEol(out);
        }
        out.write("public class " + this.getClassName(def) + " implements ActivationSpec");
        this.writeLeftCurlyBracket(out, 0);
        this.writeEol(out);
        int indent = 1;
        this.writeIndent(out, indent);
        out.write("/** The logger */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private static Logger log = Logger.getLogger(" + this.getSelfClassName(def) + ");");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** The resource adapter */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private ResourceAdapter ra;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeConfigPropsDeclare(def, out, indent);
        this.writeDefaultConstructor(def, out, indent);
        this.writeConfigProps(def, out, indent);
        this.writeValidate(def, out, indent);
        this.writeResourceAdapter(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    void writeDefaultConstructor(Definition def, Writer out, int indent) throws IOException {
        if (!def.getVersion().equals(Version.V_15.getLocalName())) {
            super.writeDefaultConstructor(def, out, indent);
            return;
        }
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Default constructor");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public " + this.getClassName(def) + "()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeConfigPropsDefaults(def, out, indent);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeConfigPropsDefaults(Definition def, Writer out, int indent) throws IOException {
        List<ConfigPropType> configPropTypes = def.getAsConfigProps();
        if (configPropTypes == null) {
            return;
        }
        for (ConfigPropType configPropType : configPropTypes) {
            String name = configPropType.getName();
            String type = configPropType.getType();
            String value = configPropType.getValue();
            if (value == null || value.length() <= 0) continue;
            this.writeIndent(out, indent);
            this.writeIndent(out, indent);
            if (type.equals("Character")) {
                out.write("this." + name + " = " + type + ".valueOf('" + value + "');");
            } else if (type.equals("String")) {
                out.write("this." + name + " = \"" + value + "\";");
            } else {
                out.write("this." + name + " = " + type + ".valueOf(\"" + value + "\");");
            }
            this.writeEol(out);
        }
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ".inflow;");
        this.writeEol(out);
        this.writeEol(out);
        this.importLogging(def, out);
        if (def.isUseAnnotation()) {
            out.write("import jakarta.resource.spi.Activation;");
            this.writeEol(out);
        }
        out.write("import jakarta.resource.spi.ActivationSpec;");
        this.writeEol(out);
        if (def.isUseAnnotation()) {
            this.importConfigProperty(def, out);
        }
        out.write("import jakarta.resource.spi.InvalidPropertyException;");
        this.writeEol(out);
        out.write("import jakarta.resource.spi.ResourceAdapter;");
        this.writeEol(out);
        if (def.isUseAnnotation()) {
            for (int i = 0; i < this.getConfigProps(def).size(); ++i) {
                if (!this.getConfigProps(def).get(i).isRequired()) continue;
                out.write("import jakarta.validation.constraints.NotNull;");
                break;
            }
        }
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getAsClass();
    }

    @Override
    public List<ConfigPropType> getConfigProps(Definition def) {
        return def.getAsConfigProps();
    }

    private void writeValidate(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * This method may be called by a deployment tool to validate the overall");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * activation configuration information provided by the endpoint deployer.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws InvalidPropertyException indicates invalid configuration property settings.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void validate() throws InvalidPropertyException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "validate", new String[0]);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeResourceAdapter(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Get the resource adapter");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return The handle");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public ResourceAdapter getResourceAdapter()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getResourceAdapter", new String[0]);
        this.writeIndent(out, indent + 1);
        out.write("return ra;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Set the resource adapter");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param ra The handle");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void setResourceAdapter(ResourceAdapter ra)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "setResourceAdapter", "ra");
        this.writeIndent(out, indent + 1);
        out.write("this.ra = ra;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

