/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.MethodForConnection;
import org.jboss.jca.codegenerator.MethodParam;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class MbeanInterfaceCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        int indent = 1;
        out.write("public interface " + this.getClassName(def));
        this.writeLeftCurlyBracket(out, 0);
        if (def.getMcfDefs().get(0).isDefineMethodInConnection()) {
            if (def.getMcfDefs().get(0).getMethods().size() > 0) {
                for (MethodForConnection method : def.getMcfDefs().get(0).getMethods()) {
                    this.writeIndent(out, indent);
                    out.write("/**");
                    this.writeEol(out);
                    this.writeIndent(out, indent);
                    out.write(" * " + method.getMethodName());
                    this.writeEol(out);
                    for (MethodParam param : method.getParams()) {
                        this.writeIndent(out, indent);
                        out.write(" * @param " + param.getName() + " " + param.getName());
                        this.writeEol(out);
                    }
                    if (!method.getReturnType().equals("void")) {
                        this.writeIndent(out, indent);
                        out.write(" * @return " + method.getReturnType());
                        this.writeEol(out);
                    }
                    this.writeIndent(out, indent);
                    out.write(" * @throws Exception exception");
                    this.writeEol(out);
                    this.writeIndent(out, indent);
                    out.write(" */");
                    this.writeEol(out);
                    this.writeIndent(out, indent);
                    out.write("public " + method.getReturnType() + " " + method.getMethodName() + "(");
                    int paramSize = method.getParams().size();
                    for (int i = 0; i < paramSize; ++i) {
                        MethodParam param = method.getParams().get(i);
                        out.write(param.getType());
                        out.write(" ");
                        out.write(param.getName());
                        if (i + 1 >= paramSize) continue;
                        out.write(", ");
                    }
                    out.write(") throws Exception;");
                    this.writeEol(out);
                    this.writeEol(out);
                }
            }
        } else {
            this.writeIndent(out, indent);
            out.write("/**");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * Call me");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * @throws Exception exception");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("public void callMe() throws Exception;");
        }
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ".mbean;");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMbeanInterfaceClass();
    }
}

