/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.util.ArrayDeque;
import java.util.concurrent.Executor;
import org.jboss.invocation.AsynchronousInterceptor;
import org.jboss.invocation.AsynchronousInterceptorContext;
import org.jboss.invocation.AsynchronousTask;

public final class QueuedAsynchronousInterceptor
implements AsynchronousInterceptor {
    private boolean running;
    private final ArrayDeque<AsynchronousTask> queue = new ArrayDeque();
    private final Executor executor;

    public QueuedAsynchronousInterceptor(Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        ArrayDeque<AsynchronousTask> queue = this.queue;
        while (true) {
            AsynchronousTask task;
            ArrayDeque<AsynchronousTask> arrayDeque = queue;
            synchronized (arrayDeque) {
                task = queue.poll();
                if (task == null) {
                    return;
                }
            }
            task.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        ArrayDeque<AsynchronousTask> queue;
        ArrayDeque<AsynchronousTask> arrayDeque = queue = this.queue;
        synchronized (arrayDeque) {
            return queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsynchronousInterceptor.CancellationHandle processInvocation(AsynchronousInterceptorContext context, AsynchronousInterceptor.ResultHandler resultHandler) {
        ArrayDeque<AsynchronousTask> queue;
        ArrayDeque<AsynchronousTask> arrayDeque = queue = this.queue;
        synchronized (arrayDeque) {
            if (this.running) {
                AsynchronousTask task = new AsynchronousTask(context, resultHandler);
                queue.add(task);
                return task;
            }
            this.running = true;
        }
        return context.proceed(resultHandler.withAction(this, QueuedAsynchronousInterceptor::runNext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNext() {
        AsynchronousTask next;
        ArrayDeque<AsynchronousTask> queue;
        ArrayDeque<AsynchronousTask> arrayDeque = queue = this.queue;
        synchronized (arrayDeque) {
            assert (this.running);
            if (queue.isEmpty()) {
                this.running = false;
                next = null;
            } else {
                next = queue.poll();
            }
        }
        if (next != null) {
            this.executor.execute(next);
        }
    }
}

