/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.proxy;

import java.io.ObjectStreamException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.code.BranchEnd;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.classfilewriter.util.Boxing;
import org.jboss.invocation.proxy.AbstractProxyFactory;
import org.jboss.invocation.proxy.ConstructorBodyCreator;
import org.jboss.invocation.proxy.MethodBodyCreator;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.invocation.proxy.SerializableProxy;

public class ProxyFactory<T>
extends AbstractProxyFactory<T> {
    private volatile Field invocationHandlerField;
    public static final String INVOCATION_HANDLER_FIELD = "invocation$$dispatcher";
    private static final AtomicInteger nameCount = new AtomicInteger();
    public static final String CONSTRUCTED_GUARD = "proxy$$Constructor$$finished";
    private final Class<?>[] additionalInterfaces;
    private Class<? extends SerializableProxy> serializableProxyClass;

    public ProxyFactory(String className, Class<T> superClass, ClassLoader classLoader, ProtectionDomain protectionDomain, Class<?> ... additionalInterfaces) {
        super(className, superClass, classLoader, protectionDomain);
        this.additionalInterfaces = additionalInterfaces;
    }

    public ProxyFactory(String className, Class<T> superClass, ClassLoader classLoader, Class<?> ... additionalInterfaces) {
        super(className, superClass, classLoader);
        this.additionalInterfaces = additionalInterfaces;
    }

    public ProxyFactory(String className, Class<T> superClass, Class<?> ... additionalInterfaces) {
        super(className, superClass);
        this.additionalInterfaces = additionalInterfaces;
    }

    public ProxyFactory(Class<T> superClass, Class<?> ... additionalInterfaces) {
        super(superClass.getName() + "$$Proxy" + nameCount.incrementAndGet(), superClass);
        this.additionalInterfaces = additionalInterfaces;
    }

    public T newInstance(InvocationHandler handler) throws InstantiationException, IllegalAccessException {
        Object ret = this.newInstance();
        this.setInvocationHandler(ret, handler);
        return ret;
    }

    @Override
    protected void generateClass() {
        this.classFile.addField(2, INVOCATION_HANDLER_FIELD, InvocationHandler.class);
        this.classFile.addField(2, CONSTRUCTED_GUARD, "Z");
        if (this.serializableProxyClass != null) {
            this.createWriteReplace();
        }
        MethodBodyCreator creator = this.getDefaultMethodOverride();
        this.overrideAllMethods(creator);
        for (Class<?> iface : this.additionalInterfaces) {
            this.addInterface(creator, iface);
        }
        this.overrideToString(creator);
        this.overrideEquals(creator);
        this.overrideHashcode(creator);
        this.createConstructorDelegates(new ProxyConstructorBodyCreator());
        this.finalizeStaticConstructor();
        for (Annotation annotation : this.getSuperClass().getDeclaredAnnotations()) {
            this.classFile.getRuntimeVisibleAnnotationsAttribute().addAnnotation(annotation);
        }
    }

    private void createWriteReplace() {
        MethodIdentifier identifier = MethodIdentifier.getIdentifier(Object.class, "writeReplace", new Class[0]);
        ClassMethod method = this.classFile.addMethod(4, "writeReplace", "Ljava/lang/Object;", new String[0]);
        method.addCheckedExceptions(new Class[]{ObjectStreamException.class});
        this.overrideMethod(method, identifier, (MethodBodyCreator)new WriteReplaceBodyCreator());
    }

    public void setSerializableProxyClass(Class<? extends SerializableProxy> serializableProxyClass) {
        if (this.classFile == null) {
            throw new IllegalStateException("Cannot set a ProxyFactories SerializableProxyClass after the proxy has been created");
        }
        this.serializableProxyClass = serializableProxyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Field getInvocationHandlerField() {
        if (this.invocationHandlerField == null) {
            ProxyFactory proxyFactory = this;
            synchronized (proxyFactory) {
                if (this.invocationHandlerField == null) {
                    try {
                        this.invocationHandlerField = this.defineClass().getDeclaredField(INVOCATION_HANDLER_FIELD);
                        AccessController.doPrivileged(new SetAccessiblePrivilege(this.invocationHandlerField));
                    }
                    catch (NoSuchFieldException e) {
                        throw new RuntimeException("Could not find invocation handler on generated proxy", e);
                    }
                }
            }
        }
        return this.invocationHandlerField;
    }

    @Override
    public MethodBodyCreator getDefaultMethodOverride() {
        return new ProxyMethodBodyCreator();
    }

    public void setInvocationHandler(Object proxy, InvocationHandler handler) {
        Field field = this.getInvocationHandlerField();
        try {
            field.set(proxy, handler);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public InvocationHandler getInvocationHandler(Object proxy) {
        Field field = this.getInvocationHandlerField();
        try {
            return (InvocationHandler)field.get(proxy);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Object is not a proxy of correct type", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setInvocationHandlerStatic(Object proxy, InvocationHandler handler) {
        try {
            Field field = proxy.getClass().getDeclaredField(INVOCATION_HANDLER_FIELD);
            AccessController.doPrivileged(new SetAccessiblePrivilege(field));
            field.set(proxy, handler);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Could not find invocation handler on generated proxy", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static InvocationHandler getInvocationHandlerStatic(Object proxy) {
        try {
            Field field = proxy.getClass().getDeclaredField(INVOCATION_HANDLER_FIELD);
            AccessController.doPrivileged(new SetAccessiblePrivilege(field));
            return (InvocationHandler)field.get(proxy);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Could not find invocation handler on generated proxy", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Object is not a proxy of correct type", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static class SetAccessiblePrivilege
    implements PrivilegedAction<Void> {
        private final AccessibleObject object;

        public SetAccessiblePrivilege(AccessibleObject object) {
            this.object = object;
        }

        @Override
        public Void run() {
            this.object.setAccessible(true);
            return null;
        }
    }

    public class WriteReplaceBodyCreator
    implements MethodBodyCreator {
        @Override
        public void overrideMethod(ClassMethod method, Method superclassMethod) {
            CodeAttribute ca = method.getCodeAttribute();
            ca.newInstruction(ProxyFactory.this.serializableProxyClass.getName());
            ca.dup();
            ca.invokespecial(ProxyFactory.this.serializableProxyClass.getName(), "<init>", "()V");
            ca.dup();
            ca.aload(0);
            ca.invokeinterface(SerializableProxy.class.getName(), "setProxyInstance", "(Ljava/lang/Object;)V");
            ca.returnInstruction();
        }
    }

    public class ProxyConstructorBodyCreator
    implements ConstructorBodyCreator {
        @Override
        public void overrideConstructor(ClassMethod method, Constructor<?> constructor) {
            CodeAttribute ca = method.getCodeAttribute();
            ca.aload(0);
            ca.iconst(0);
            ca.putfield(ProxyFactory.this.getClassName(), ProxyFactory.CONSTRUCTED_GUARD, "Z");
            ca.aload(0);
            ca.loadMethodParameters();
            ca.invokespecial(constructor);
            ca.aload(0);
            ca.iconst(1);
            ca.putfield(ProxyFactory.this.getClassName(), ProxyFactory.CONSTRUCTED_GUARD, "Z");
            ca.returnInstruction();
        }
    }

    public class ProxyMethodBodyCreator
    implements MethodBodyCreator {
        @Override
        public void overrideMethod(ClassMethod method, Method superclassMethod) {
            CodeAttribute ca = method.getCodeAttribute();
            ca.aload(0);
            ca.getfield(ProxyFactory.this.getClassName(), ProxyFactory.CONSTRUCTED_GUARD, "Z");
            BranchEnd end = ca.ifne();
            ca.aload(0);
            ca.loadMethodParameters();
            ca.invokespecial(ProxyFactory.this.getSuperClassName(), method.getName(), method.getDescriptor());
            ca.returnInstruction();
            ca.branchEnd(end);
            ca.aload(0);
            ca.getfield(ProxyFactory.this.getClassName(), ProxyFactory.INVOCATION_HANDLER_FIELD, InvocationHandler.class);
            ca.aload(0);
            ProxyFactory.this.loadMethodIdentifier(superclassMethod, method);
            String[] params = method.getParameters();
            ca.iconst(params.length);
            ca.anewarray("java/lang/Object");
            int loadPosition = 1;
            for (int i = 0; i < params.length; ++i) {
                ca.dup();
                ca.iconst(i);
                String type = params[i];
                if (type.length() == 1) {
                    char typeChar = type.charAt(0);
                    switch (typeChar) {
                        case 'I': {
                            ca.iload(loadPosition);
                            Boxing.boxInt((CodeAttribute)ca);
                            break;
                        }
                        case 'S': {
                            ca.iload(loadPosition);
                            Boxing.boxShort((CodeAttribute)ca);
                            break;
                        }
                        case 'B': {
                            ca.iload(loadPosition);
                            Boxing.boxByte((CodeAttribute)ca);
                            break;
                        }
                        case 'Z': {
                            ca.iload(loadPosition);
                            Boxing.boxBoolean((CodeAttribute)ca);
                            break;
                        }
                        case 'C': {
                            ca.iload(loadPosition);
                            Boxing.boxChar((CodeAttribute)ca);
                            break;
                        }
                        case 'D': {
                            ca.dload(loadPosition);
                            Boxing.boxDouble((CodeAttribute)ca);
                            ++loadPosition;
                            break;
                        }
                        case 'J': {
                            ca.lload(loadPosition);
                            Boxing.boxLong((CodeAttribute)ca);
                            ++loadPosition;
                            break;
                        }
                        case 'F': {
                            ca.fload(loadPosition);
                            Boxing.boxFloat((CodeAttribute)ca);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown primitive type descriptor: " + typeChar);
                        }
                    }
                } else {
                    ca.aload(loadPosition);
                }
                ca.aastore();
                ++loadPosition;
            }
            ca.invokeinterface(InvocationHandler.class.getName(), "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;");
            if (superclassMethod.getReturnType() != Void.TYPE) {
                if (superclassMethod.getReturnType().isPrimitive()) {
                    Boxing.unbox((CodeAttribute)ca, (String)method.getReturnType());
                } else {
                    ca.checkcast(superclassMethod.getReturnType().getName());
                }
            }
            ca.returnInstruction();
        }
    }
}

