package org.jboss.hal.dmr.macro;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class MacroOperationEvent extends GwtEvent<MacroOperationEvent.MacroOperationHandler> { 

  org.jboss.hal.dmr.macro.Macro macro;
  org.jboss.hal.dmr.Operation operation;

  protected MacroOperationEvent() {
    // Possibly for serialization.
  }

  public MacroOperationEvent(org.jboss.hal.dmr.macro.Macro macro, org.jboss.hal.dmr.Operation operation) {
    this.macro = macro;
    this.operation = operation;
  }

  public static void fire(HasHandlers source, org.jboss.hal.dmr.macro.Macro macro, org.jboss.hal.dmr.Operation operation) {
    MacroOperationEvent eventInstance = new MacroOperationEvent(macro, operation);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, MacroOperationEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasMacroOperationHandlers extends HasHandlers {
    HandlerRegistration addMacroOperationHandler(MacroOperationHandler handler);
  }

  public interface MacroOperationHandler extends EventHandler {
    public void onMacroOperation(MacroOperationEvent event);
  }

  private static final Type<MacroOperationHandler> TYPE = new Type<MacroOperationHandler>();

  public static Type<MacroOperationHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<MacroOperationHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(MacroOperationHandler handler) {
    handler.onMacroOperation(this);
  }

  public org.jboss.hal.dmr.macro.Macro getMacro(){
    return macro;
  }

  public org.jboss.hal.dmr.Operation getOperation(){
    return operation;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    MacroOperationEvent other = (MacroOperationEvent) obj;
    if (macro == null) {
      if (other.macro != null)
        return false;
    } else if (!macro.equals(other.macro))
      return false;
    if (operation == null) {
      if (other.operation != null)
        return false;
    } else if (!operation.equals(other.operation))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (macro == null ? 1 : macro.hashCode());
    hashCode = (hashCode * 37) + (operation == null ? 1 : operation.hashCode());
    return hashCode;
  }

  @Override
  public String toString() {
    return "MacroOperationEvent["
                 + macro
                 + ","
                 + operation
    + "]";
  }
}
