package org.jboss.hal.core.runtime.group;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class ServerGroupActionEvent extends GwtEvent<ServerGroupActionEvent.ServerGroupActionHandler> { 

  org.jboss.hal.core.runtime.group.ServerGroup serverGroup;
  java.util.List<org.jboss.hal.core.runtime.server.Server> servers;
  org.jboss.hal.core.runtime.Action action;

  protected ServerGroupActionEvent() {
    // Possibly for serialization.
  }

  public ServerGroupActionEvent(org.jboss.hal.core.runtime.group.ServerGroup serverGroup, java.util.List<org.jboss.hal.core.runtime.server.Server> servers, org.jboss.hal.core.runtime.Action action) {
    this.serverGroup = serverGroup;
    this.servers = servers;
    this.action = action;
  }

  public static void fire(HasHandlers source, org.jboss.hal.core.runtime.group.ServerGroup serverGroup, java.util.List<org.jboss.hal.core.runtime.server.Server> servers, org.jboss.hal.core.runtime.Action action) {
    ServerGroupActionEvent eventInstance = new ServerGroupActionEvent(serverGroup, servers, action);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, ServerGroupActionEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasServerGroupActionHandlers extends HasHandlers {
    HandlerRegistration addServerGroupActionHandler(ServerGroupActionHandler handler);
  }

  public interface ServerGroupActionHandler extends EventHandler {
    public void onServerGroupAction(ServerGroupActionEvent event);
  }

  private static final Type<ServerGroupActionHandler> TYPE = new Type<ServerGroupActionHandler>();

  public static Type<ServerGroupActionHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<ServerGroupActionHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(ServerGroupActionHandler handler) {
    handler.onServerGroupAction(this);
  }

  public org.jboss.hal.core.runtime.group.ServerGroup getServerGroup(){
    return serverGroup;
  }

  public java.util.List<org.jboss.hal.core.runtime.server.Server> getServers(){
    return servers;
  }

  public org.jboss.hal.core.runtime.Action getAction(){
    return action;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    ServerGroupActionEvent other = (ServerGroupActionEvent) obj;
    if (serverGroup == null) {
      if (other.serverGroup != null)
        return false;
    } else if (!serverGroup.equals(other.serverGroup))
      return false;
    if (servers == null) {
      if (other.servers != null)
        return false;
    } else if (!servers.equals(other.servers))
      return false;
    if (action == null) {
      if (other.action != null)
        return false;
    } else if (!action.equals(other.action))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (serverGroup == null ? 1 : serverGroup.hashCode());
    hashCode = (hashCode * 37) + (servers == null ? 1 : servers.hashCode());
    hashCode = (hashCode * 37) + (action == null ? 1 : action.hashCode());
    return hashCode;
  }

  @Override
  public String toString() {
    return "ServerGroupActionEvent["
                 + serverGroup
                 + ","
                 + servers
                 + ","
                 + action
    + "]";
  }
}
