package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_RemoteActiveMQView extends RemoteActiveMQView {

    private final Metadata metadata134;
    private final Metadata metadata132;
    private final Metadata metadata130;
    private final Metadata metadata136;
    private final Metadata metadata131;
    private final Metadata metadata133;
    private final Metadata metadata129;
    private final Metadata metadata135;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_RemoteActiveMQView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata134Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/connection-factory=*");
        this.metadata134 = mbuiContext.metadataRegistry().lookup(metadata134Template);
        AddressTemplate metadata132Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/remote-connector=*");
        this.metadata132 = mbuiContext.metadataRegistry().lookup(metadata132Template);
        AddressTemplate metadata130Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/in-vm-connector=*");
        this.metadata130 = mbuiContext.metadataRegistry().lookup(metadata130Template);
        AddressTemplate metadata136Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/external-jms-topic=*");
        this.metadata136 = mbuiContext.metadataRegistry().lookup(metadata136Template);
        AddressTemplate metadata131Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/http-connector=*");
        this.metadata131 = mbuiContext.metadataRegistry().lookup(metadata131Template);
        AddressTemplate metadata133Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/discovery-group=*");
        this.metadata133 = mbuiContext.metadataRegistry().lookup(metadata133Template);
        AddressTemplate metadata129Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/connector=*");
        this.metadata129 = mbuiContext.metadataRegistry().lookup(metadata129Template);
        AddressTemplate metadata135Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/external-jms-queue=*");
        this.metadata135 = mbuiContext.metadataRegistry().lookup(metadata135Template);
        this.expressionElements = new HashMap<>();

        connectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connector-form", metadata129)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.CONNECTOR, form))
            .build();
        inVmConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-in-vm-connector-form", metadata130)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.IN_VM_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.IN_VM_CONNECTOR, form))
            .build();
        httpConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-http-connector-form", metadata131)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.HTTP_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.HTTP_CONNECTOR, form))
            .build();
        remoteConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-remote-connector-form", metadata132)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.REMOTE_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.REMOTE_CONNECTOR, form))
            .build();
        discoveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-discovery-group-form", metadata133)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.DISCOVERY_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.DISCOVERY_GROUP, form))
            .build();
        connectionFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connection-factory-form", metadata134)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.CONNECTION_FACTORY, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.CONNECTION_FACTORY, form))
            .build();
        externalQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-queue-form", metadata135)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.EXTERNAL_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.EXTERNAL_QUEUE, form))
            .build();
        externalTopicForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-topic-form", metadata136)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.EXTERNAL_TOPIC, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.EXTERNAL_TOPIC, form))
            .build();

        connectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connector-table", metadata129)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        inVmConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-in-vm-connector-table", metadata130)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.IN_VM_CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/in-vm-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.IN_VM_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/in-vm-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        httpConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-http-connector-table", metadata131)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addHttpConnector(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/http-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.HTTP_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/http-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-remote-connector-table", metadata132)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addRemoteConnector(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/remote-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.REMOTE_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/remote-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        discoveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-discovery-group-table", metadata133)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.DISCOVERY_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/discovery-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.DISCOVERY_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/discovery-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectionFactoryTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connection-factory-table", metadata134)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addConnectionFactory(RemoteActiveMQSubResource.CONNECTION_FACTORY), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connection-factory=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.CONNECTION_FACTORY, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connection-factory=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        externalQueueTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-queue-table", metadata135)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.EXTERNAL_QUEUE), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-queue=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.EXTERNAL_QUEUE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-queue=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        externalTopicTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-topic-table", metadata136)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.EXTERNAL_TOPIC), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-topic=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.EXTERNAL_TOPIC, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-topic=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("msg-remote-connector-group-item", "Connector", "fa fa-link");
        HTMLElement html377;
        HTMLElement msgRemoteConnectorItemElement = section()
            .add(html377 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Connector</h1><p>${metadata129.getDescription().getDescription()}</p>"))
                                    .element())
            .add(connectorTable)
            .add(connectorForm)
                            .element();
        expressionElements.put("html377", html377);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-connector-item", "Generic", msgRemoteConnectorItemElement);
        HTMLElement html380;
        HTMLElement msgRemoteInVmConnectorItemElement = section()
            .add(html380 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Connector</h1><p>${metadata130.getDescription().getDescription()}</p>"))
                                    .element())
            .add(inVmConnectorTable)
            .add(inVmConnectorForm)
                            .element();
        expressionElements.put("html380", html380);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-in-vm-connector-item", "In VM", msgRemoteInVmConnectorItemElement);
        HTMLElement html383;
        HTMLElement msgRemoteHttpConnectorItemElement = section()
            .add(html383 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>${metadata131.getDescription().getDescription()}</p>"))
                                    .element())
            .add(httpConnectorTable)
            .add(httpConnectorForm)
                            .element();
        expressionElements.put("html383", html383);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-http-connector-item", "HTTP", msgRemoteHttpConnectorItemElement);
        HTMLElement html386;
        HTMLElement msgRemoteRemoteConnectorItemElement = section()
            .add(html386 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Connector</h1><p>${metadata132.getDescription().getDescription()}</p>"))
                                    .element())
            .add(remoteConnectorTable)
            .add(remoteConnectorForm)
                            .element();
        expressionElements.put("html386", html386);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-remote-connector-item", "Remote", msgRemoteRemoteConnectorItemElement);
        HTMLElement html389;
        HTMLElement msgRemoteDiscoveryGroupItemElement = section()
            .add(html389 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Discovery Group</h1><p>${metadata133.getDescription().getDescription()}</p>"))
                            .element())
            .add(discoveryGroupTable)
            .add(discoveryGroupForm)
                    .element();
        expressionElements.put("html389", html389);
        navigation.addPrimary("msg-remote-discovery-group-item", "Discovery Group", "pficon pficon-service", msgRemoteDiscoveryGroupItemElement);
        HTMLElement html392;
        HTMLElement msgRemoteConnectionFactoryItemElement = section()
            .add(html392 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connection Factory</h1><p>${metadata134.getDescription().getDescription()}</p>"))
                            .element())
            .add(connectionFactoryTable)
            .add(connectionFactoryForm)
                    .element();
        expressionElements.put("html392", html392);
        navigation.addPrimary("msg-remote-connection-factory-item", "Connection Factory", "fa fa-cubes", msgRemoteConnectionFactoryItemElement);
        HTMLElement html395;
        HTMLElement msgRemoteExternalQueueItemElement = section()
            .add(html395 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>External JMS Queue</h1><p>${metadata135.getDescription().getDescription()}</p>"))
                            .element())
            .add(externalQueueTable)
            .add(externalQueueForm)
                    .element();
        expressionElements.put("html395", html395);
        navigation.addPrimary("msg-remote-external-queue-item", "External JMS Queue", "fa fa-long-arrow-right", msgRemoteExternalQueueItemElement);
        HTMLElement html398;
        HTMLElement msgRemoteExternalTopicItemElement = section()
            .add(html398 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>External JMS Topic</h1><p>${metadata136.getDescription().getDescription()}</p>"))
                            .element())
            .add(externalTopicTable)
            .add(externalTopicForm)
                    .element();
        expressionElements.put("html398", html398);
        navigation.addPrimary("msg-remote-external-topic-item", "External JMS Topic", "fa fa-arrows", msgRemoteExternalTopicItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(connectorTable);
        registerAttachable(connectorForm);
        registerAttachable(inVmConnectorTable);
        registerAttachable(inVmConnectorForm);
        registerAttachable(httpConnectorTable);
        registerAttachable(httpConnectorForm);
        registerAttachable(remoteConnectorTable);
        registerAttachable(remoteConnectorForm);
        registerAttachable(discoveryGroupTable);
        registerAttachable(discoveryGroupForm);
        registerAttachable(connectionFactoryTable);
        registerAttachable(connectionFactoryForm);
        registerAttachable(externalQueueTable);
        registerAttachable(externalQueueForm);
        registerAttachable(externalTopicTable);
        registerAttachable(externalTopicForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            connectorTable.bindForm(connectorForm);
            inVmConnectorTable.bindForm(inVmConnectorForm);
            httpConnectorTable.bindForm(httpConnectorForm);
            remoteConnectorTable.bindForm(remoteConnectorForm);
            discoveryGroupTable.bindForm(discoveryGroupForm);
            connectionFactoryTable.bindForm(connectionFactoryForm);
            externalQueueTable.bindForm(externalQueueForm);
            externalTopicTable.bindForm(externalTopicForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html377"), "${metadata129.getDescription().getDescription()}", String.valueOf(metadata129.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html380"), "${metadata130.getDescription().getDescription()}", String.valueOf(metadata130.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html383"), "${metadata131.getDescription().getDescription()}", String.valueOf(metadata131.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html386"), "${metadata132.getDescription().getDescription()}", String.valueOf(metadata132.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html389"), "${metadata133.getDescription().getDescription()}", String.valueOf(metadata133.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html392"), "${metadata134.getDescription().getDescription()}", String.valueOf(metadata134.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html395"), "${metadata135.getDescription().getDescription()}", String.valueOf(metadata135.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html398"), "${metadata136.getDescription().getDescription()}", String.valueOf(metadata136.getDescription().getDescription()));
    }
}
