package org.jboss.hal.client.bootstrap.tasks;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class VersionUpdateEvent extends GwtEvent<VersionUpdateEvent.VersionUpdateHandler> { 

  org.jboss.hal.config.Version version;

  protected VersionUpdateEvent() {
    // Possibly for serialization.
  }

  public VersionUpdateEvent(org.jboss.hal.config.Version version) {
    this.version = version;
  }

  public static void fire(HasHandlers source, org.jboss.hal.config.Version version) {
    VersionUpdateEvent eventInstance = new VersionUpdateEvent(version);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, VersionUpdateEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasVersionUpdateHandlers extends HasHandlers {
    HandlerRegistration addVersionUpdateHandler(VersionUpdateHandler handler);
  }

  public interface VersionUpdateHandler extends EventHandler {
    public void onVersionUpdate(VersionUpdateEvent event);
  }

  private static final Type<VersionUpdateHandler> TYPE = new Type<VersionUpdateHandler>();

  public static Type<VersionUpdateHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<VersionUpdateHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(VersionUpdateHandler handler) {
    handler.onVersionUpdate(this);
  }

  public org.jboss.hal.config.Version getVersion(){
    return version;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    VersionUpdateEvent other = (VersionUpdateEvent) obj;
    if (version == null) {
      if (other.version != null)
        return false;
    } else if (!version.equals(other.version))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (version == null ? 1 : version.hashCode());
    return hashCode;
  }

  @Override
  public String toString() {
    return "VersionUpdateEvent["
                 + version
    + "]";
  }
}
