/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.spi;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.gravia.runtime.spi.CompositePropertiesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstitutionPropertiesProvider
extends CompositePropertiesProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubstitutionPropertiesProvider.class);
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{([a-zA-Z0-9\\.\\-]+)}");
    private static final String BOX_FORMAT = "\\$\\{%s\\}";
    private static final String UNESCAPED_BOX_FORMAT = "${%s}";

    public SubstitutionPropertiesProvider(PropertiesProvider ... delegates) {
        super(delegates);
    }

    @Override
    public Object getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        for (PropertiesProvider provider : this.getDelegates()) {
            try {
                Object rawValue = provider.getProperty(key);
                if (rawValue == null || SubstitutionPropertiesProvider.isCyclicReference(key, rawValue)) continue;
                return this.substitute(String.valueOf(rawValue), new HashSet<String>());
            }
            catch (Exception e) {
                LOGGER.debug("Skipping properties provider:{}, due to:{}", (Object)provider, (Object)e.getMessage());
            }
        }
        return defaultValue;
    }

    private String substitute(String str, Set<String> visited) {
        String result = str;
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(str);
        CopyOnWriteArraySet<String> copyOfVisited = new CopyOnWriteArraySet<String>(visited);
        while (matcher.find()) {
            String name = matcher.group(1);
            String replacement = null;
            String toReplace = String.format(BOX_FORMAT, name);
            for (PropertiesProvider provider : this.getDelegates()) {
                Object rawValue;
                if (provider.getProperty(name) == null || visited.contains(name) || SubstitutionPropertiesProvider.isCyclicReference(name, rawValue = provider.getProperty(name)) || !PLACEHOLDER_PATTERN.matcher(replacement = String.valueOf(rawValue)).matches()) continue;
                copyOfVisited.add(name);
                replacement = this.substitute(replacement, copyOfVisited);
            }
            if (replacement != null) {
                result = result.replaceAll(toReplace, Matcher.quoteReplacement(replacement));
                continue;
            }
            if (!str.equals(toReplace.replace("\\", ""))) {
                result = result.replaceAll(toReplace, "");
                continue;
            }
            result = null;
        }
        return result;
    }

    private static boolean isCyclicReference(String key, Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        return String.format(UNESCAPED_BOX_FORMAT, key).equals(value);
    }
}

