/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.dependencies.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.DependencyNode;
import org.jboss.forge.furnace.util.Predicate;

public final class DependencyNodeUtil {
    public static final String FORGE_ADDON_CLASSIFIER = "forge-addon";

    private DependencyNodeUtil() {
    }

    public static <T> T selectFirst(Iterator<T> nodeIterator, Predicate<T> filter) {
        while (nodeIterator.hasNext()) {
            T element = nodeIterator.next();
            if (!filter.accept(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> List<T> select(Iterator<T> iterator, Predicate<T> filter) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (!filter.accept(element)) continue;
            result.add(element);
        }
        return result;
    }

    public static List<DependencyNode> select(DependencyNode node, Predicate<DependencyNode> filter) {
        ArrayList<DependencyNode> result = new ArrayList<DependencyNode>();
        DependencyNodeUtil.selectInternal(node, filter, result);
        return result;
    }

    private static void selectInternal(DependencyNode root, Predicate<DependencyNode> filter, List<DependencyNode> collector) {
        if (filter.accept((Object)root)) {
            collector.add(root);
            for (DependencyNode child : root.getChildren()) {
                DependencyNodeUtil.selectInternal(child, filter, collector);
            }
        }
    }

    public static CharSequence prettyPrint(DependencyNode root) {
        StringBuilder sb = new StringBuilder();
        DependencyNodeUtil.prettyPrint(root, new Predicate<DependencyNode>(){

            public boolean accept(DependencyNode node) {
                return true;
            }
        }, sb, 0);
        return sb;
    }

    public static String prettyPrint(DependencyNode root, Predicate<DependencyNode> filter) {
        StringBuilder sb = new StringBuilder();
        DependencyNodeUtil.prettyPrint(root, filter, sb, 0);
        return sb.toString();
    }

    private static void prettyPrint(DependencyNode node, Predicate<DependencyNode> filter, StringBuilder builder, int depth) {
        if (filter.accept((Object)node)) {
            for (int i = 0; i < depth; ++i) {
                builder.append(" ");
            }
            if (depth > 0) {
                builder.append("|-");
            }
            builder.append(node.getDependency()).append(" (").append(node.getDependency().getScopeType()).append(")\n");
            for (DependencyNode child : node.getChildren()) {
                DependencyNodeUtil.prettyPrint(child, filter, builder, depth + 1);
            }
        }
    }

    public static Iterator<DependencyNode> depthFirstIterator(DependencyNode dependencyNode) {
        return new PostorderIterator(dependencyNode);
    }

    public static Iterator<DependencyNode> breadthFirstIterator(DependencyNode dependencyNode) {
        return new BreadthFirstIterator(dependencyNode);
    }

    public static Iterator<DependencyNode> preorderIterator(DependencyNode dependencyNode) {
        return new PreorderFirstIterator(dependencyNode);
    }

    public static boolean isForgeAddon(Coordinate coordinate) {
        return FORGE_ADDON_CLASSIFIER.equals(coordinate.getClassifier());
    }

    private static final class PostorderIterator
    implements Iterator<DependencyNode> {
        private DependencyNode root;
        private Iterator<DependencyNode> children;
        private Iterator<DependencyNode> subtree;

        public PostorderIterator(DependencyNode node) {
            this.root = node;
            this.children = node.getChildren().iterator();
            this.subtree = Collections.emptyList().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.root != null;
        }

        @Override
        public DependencyNode next() {
            DependencyNode retval;
            if (this.subtree.hasNext()) {
                retval = this.subtree.next();
            } else if (this.children.hasNext()) {
                this.subtree = new PostorderIterator(this.children.next());
                retval = this.subtree.next();
            } else {
                retval = this.root;
                this.root = null;
            }
            return retval;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static final class BreadthFirstIterator
    implements Iterator<DependencyNode> {
        private Queue<Iterator<DependencyNode>> queue = new LinkedList<Iterator<DependencyNode>>();

        public BreadthFirstIterator(DependencyNode rootNode) {
            this.queue.add(Collections.singleton(rootNode).iterator());
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty() && this.queue.element().hasNext();
        }

        @Override
        public DependencyNode next() {
            Iterator<DependencyNode> it = this.queue.element();
            DependencyNode node = it.next();
            Iterator<DependencyNode> itChildren = node.getChildren().iterator();
            if (!it.hasNext()) {
                this.queue.poll();
            }
            if (itChildren.hasNext()) {
                this.queue.add(itChildren);
            }
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static final class PreorderFirstIterator
    implements Iterator<DependencyNode> {
        private Stack<Iterator<DependencyNode>> stack = new Stack();

        public PreorderFirstIterator(DependencyNode node) {
            this.stack.push(Collections.singleton(node).iterator());
        }

        @Override
        public boolean hasNext() {
            return !this.stack.empty() && this.stack.peek().hasNext();
        }

        @Override
        public DependencyNode next() {
            Iterator<DependencyNode> it = this.stack.peek();
            DependencyNode node = it.next();
            Iterator<DependencyNode> itChildren = node.getChildren().iterator();
            if (!it.hasNext()) {
                this.stack.pop();
            }
            if (itChildren.hasNext()) {
                this.stack.push(itChildren);
            }
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

