/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxrpc;

import java.util.Set;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.builder.jaxrpc.JAXRPCDeployment;
import org.jboss.ws.metadata.builder.jaxrpc.JAXRPCMetaDataBuilder;
import org.jboss.ws.metadata.j2ee.UnifiedApplicationMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedBeanMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedEjbPortComponentMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedWebMetaData;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.webservices.PortComponentMetaData;
import org.jboss.ws.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.metadata.wsse.WSSecurityOMFactory;

public class JAXRPCServerMetaDataBuilder
extends JAXRPCMetaDataBuilder {
    final Logger log = Logger.getLogger(JAXRPCServerMetaDataBuilder.class);

    public UnifiedMetaData buildMetaData(JAXRPCDeployment udi) {
        this.log.debug("START buildMetaData: [name=" + udi.getCanonicalName() + "]");
        try {
            WebserviceDescriptionMetaData[] wsDescriptionArr;
            UnifiedMetaData wsMetaData = new UnifiedMetaData(udi.vfRoot);
            wsMetaData.setDeploymentName(udi.getCanonicalName());
            wsMetaData.setClassLoader(udi.classLoader);
            for (WebserviceDescriptionMetaData wsdMetaData : wsDescriptionArr = udi.getWebservicesMetaData().getWebserviceDescriptions()) {
                PortComponentMetaData[] pcMetaDataArr;
                ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, null);
                serviceMetaData.setWebserviceDescriptionName(wsdMetaData.getWebserviceDescriptionName());
                wsMetaData.addService(serviceMetaData);
                String wsdlFile = wsdMetaData.getWsdlFile();
                serviceMetaData.setWsdlFile(wsdlFile);
                WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
                String mappingFile = wsdMetaData.getJaxrpcMappingFile();
                serviceMetaData.setMappingLocation(udi.getMetaDataFileURL(mappingFile));
                JavaWsdlMapping javaWsdlMapping = serviceMetaData.getJavaWsdlMapping();
                if (javaWsdlMapping == null) {
                    throw new WSException("jaxrpc-mapping-file not configured from webservices.xml");
                }
                this.setupTypesMetaData(serviceMetaData);
                WSSecurityConfigFactory wsseConfFactory = WSSecurityConfigFactory.newInstance();
                WSSecurityConfiguration securityConfiguration = wsseConfFactory.createConfiguration(wsMetaData.getRootFile(), WSSecurityOMFactory.SERVER_RESOURCE_NAME);
                serviceMetaData.setSecurityConfiguration(securityConfiguration);
                for (PortComponentMetaData pcMetaData : pcMetaDataArr = wsdMetaData.getPortComponents()) {
                    WSDLEndpoint wsdlEndpoint;
                    QName portName = pcMetaData.getWsdlPort();
                    if (portName.getNamespaceURI().length() == 0) {
                        String nsURI = wsdlDefinitions.getTargetNamespace();
                        portName = new QName(nsURI, portName.getLocalPart());
                        this.log.warn("Adding wsdl targetNamespace to: " + portName);
                        pcMetaData.setWsdlPort(portName);
                    }
                    if ((wsdlEndpoint = this.getWsdlEndpoint(wsdlDefinitions, portName)) == null) {
                        throw new WSException("Cannot find port in wsdl: " + portName);
                    }
                    serviceMetaData.setServiceName(wsdlEndpoint.getWsdlService().getName());
                    QName interfaceQName = wsdlEndpoint.getInterface().getName();
                    ServerEndpointMetaData sepMetaData = new ServerEndpointMetaData(serviceMetaData, portName, interfaceQName, EndpointMetaData.Type.JAXRPC);
                    sepMetaData.setPortComponentName(pcMetaData.getPortComponentName());
                    String linkName = pcMetaData.getEjbLink() != null ? pcMetaData.getEjbLink() : pcMetaData.getServletLink();
                    sepMetaData.setLinkName(linkName);
                    serviceMetaData.addEndpoint(sepMetaData);
                    this.initEndpointEncodingStyle(sepMetaData);
                    this.initEndpointAddress(udi, sepMetaData);
                    if (udi.metaData instanceof UnifiedApplicationMetaData) {
                        UnifiedEjbPortComponentMetaData bpcMetaData;
                        UnifiedApplicationMetaData apMetaData = (UnifiedApplicationMetaData)udi.metaData;
                        wsMetaData.setSecurityDomain(apMetaData.getSecurityDomain());
                        String wsdName = serviceMetaData.getWebserviceDescriptionName();
                        String wsdlPublishLocation = apMetaData.getWsdlPublishLocationByName(wsdName);
                        serviceMetaData.setWsdlPublishLocation(wsdlPublishLocation);
                        UnifiedBeanMetaData beanMetaData = apMetaData.getBeanByEjbName(linkName);
                        if (beanMetaData == null) {
                            throw new WSException("Cannot obtain UnifiedBeanMetaData for: " + linkName);
                        }
                        String configName = apMetaData.getConfigName();
                        String configFile = apMetaData.getConfigFile();
                        if (configName != null || configFile != null) {
                            sepMetaData.setConfigName(configName, configFile);
                        }
                        if ((bpcMetaData = beanMetaData.getPortComponent()) != null) {
                            if (bpcMetaData.getAuthMethod() != null) {
                                String authMethod = bpcMetaData.getAuthMethod();
                                sepMetaData.setAuthMethod(authMethod);
                            }
                            if (bpcMetaData.getTransportGuarantee() != null) {
                                String transportGuarantee = bpcMetaData.getTransportGuarantee();
                                sepMetaData.setTransportGuarantee(transportGuarantee);
                            }
                            if (bpcMetaData.getSecureWSDLAccess() != null) {
                                Boolean secureWSDLAccess = bpcMetaData.getSecureWSDLAccess();
                                sepMetaData.setSecureWSDLAccess(secureWSDLAccess);
                            }
                        }
                    } else if (udi.metaData instanceof UnifiedWebMetaData) {
                        UnifiedWebMetaData webMetaData = (UnifiedWebMetaData)udi.metaData;
                        wsMetaData.setSecurityDomain(webMetaData.getSecurityDomain());
                        String targetBean = webMetaData.getServletClassNames().get(linkName);
                        sepMetaData.setServiceEndpointImplName(targetBean);
                        String wsdName = serviceMetaData.getWebserviceDescriptionName();
                        String wsdlPublishLocation = webMetaData.getWsdlPublishLocationByName(wsdName);
                        serviceMetaData.setWsdlPublishLocation(wsdlPublishLocation);
                        String configName = webMetaData.getConfigName();
                        String configFile = webMetaData.getConfigFile();
                        if (configName != null || configFile != null) {
                            sepMetaData.setConfigName(configName, configFile);
                        }
                        this.initTransportGuaranteeJSE(udi, sepMetaData, linkName);
                    }
                    ObjectName sepID = JAXRPCServerMetaDataBuilder.createServiceEndpointID(udi, sepMetaData);
                    sepMetaData.setServiceEndpointID(sepID);
                    JAXRPCServerMetaDataBuilder.replaceAddressLocation(sepMetaData);
                    String seiName = pcMetaData.getServiceEndpointInterface();
                    sepMetaData.setServiceEndpointInterfaceName(seiName);
                    ServiceEndpointInterfaceMapping seiMapping = javaWsdlMapping.getServiceEndpointInterfaceMapping(seiName);
                    if (seiMapping == null) {
                        this.log.warn("Cannot obtain SEI mapping for: " + seiName);
                    }
                    this.processEndpointMetaDataExtensions(sepMetaData, wsdlDefinitions);
                    this.setupOperationsFromWSDL(sepMetaData, wsdlEndpoint, seiMapping);
                    for (UnifiedHandlerMetaData uhmd : pcMetaData.getHandlers()) {
                        Set<String> portNames = uhmd.getPortNames();
                        if (portNames.size() != 0 && !portNames.contains(portName.getLocalPart())) continue;
                        sepMetaData.addHandler(uhmd.getHandlerMetaDataJAXRPC(HandlerMetaData.HandlerType.ENDPOINT));
                    }
                }
            }
            this.log.debug("END buildMetaData: " + wsMetaData);
            return wsMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }

    private WSDLEndpoint getWsdlEndpoint(WSDLDefinitions wsdlDefinitions, QName portName) {
        WSDLEndpoint wsdlEndpoint = null;
        for (WSDLService wsdlService : wsdlDefinitions.getServices()) {
            WSDLEndpoint auxEndpoint = wsdlService.getEndpoint(portName);
            if (auxEndpoint == null) continue;
            wsdlEndpoint = auxEndpoint;
            break;
        }
        return wsdlEndpoint;
    }
}

