/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.extensions.security.EncodingOperation;
import org.jboss.ws.extensions.security.QNameTarget;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.Target;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.WSSecurityException;
import org.jboss.ws.extensions.security.element.EncryptedKey;
import org.jboss.ws.extensions.security.element.ReferenceList;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.element.X509Token;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptionOperation
implements EncodingOperation {
    private SecurityHeader header;
    private SecurityStore store;
    private static HashMap<String, Algorithm> algorithms = new HashMap(4);
    private static final String DEFAULT_ALGORITHM = "aes-128";

    public EncryptionOperation(SecurityHeader header, SecurityStore store) throws WSSecurityException {
        this.header = header;
        this.store = store;
    }

    private void processTarget(XMLCipher cipher, Document message, Target target, ReferenceList list2, SecretKey key) throws WSSecurityException {
        if (!(target instanceof QNameTarget)) {
            throw new NotImplementedException();
        }
        QName name = ((QNameTarget)target).getName();
        Element element = Util.findElement(message.getDocumentElement(), name);
        if (element == null) {
            throw new RuntimeException("Could not find element");
        }
        Util.assignWsuId(element);
        try {
            cipher.init(1, (Key)key);
            EncryptedData encrypted = cipher.getEncryptedData();
            String id = Util.generateId("encrypted");
            encrypted.setId(id);
            list2.add(id);
            cipher.doFinal(message, element, target.isContent());
        }
        catch (Exception e) {
            throw new WSSecurityException("Error encrypting target: " + name, e);
        }
    }

    public SecretKey getSecretKey(String algorithm) throws WSSecurityException {
        Algorithm alg = algorithms.get(algorithm);
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(alg.jceName);
            kgen.init(alg.size);
            return kgen.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(e.getMessage());
        }
    }

    @Override
    public void process(Document message, List<Target> targets, String alias, String credential, String algorithm) throws WSSecurityException {
        XMLCipher cipher;
        if (!algorithms.containsKey(algorithm)) {
            algorithm = DEFAULT_ALGORITHM;
        }
        SecretKey secretKey = this.getSecretKey(algorithm);
        try {
            cipher = XMLCipher.getInstance((String)EncryptionOperation.algorithms.get((Object)algorithm).xmlName);
            cipher.init(1, (Key)secretKey);
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException("Error initializing xml cipher" + e.getMessage(), e);
        }
        ReferenceList list2 = new ReferenceList();
        if (targets == null || targets.size() == 0) {
            String namespace = message.getDocumentElement().getNamespaceURI();
            this.processTarget(cipher, message, new QNameTarget(new QName(namespace, "Body"), true), list2, secretKey);
        } else {
            for (Target target : targets) {
                this.processTarget(cipher, message, target, list2, secretKey);
            }
        }
        X509Certificate cert = this.store.getCertificate(alias);
        X509Token token = (X509Token)this.header.getSharedToken(cert);
        if (token == null) {
            token = new X509Token(cert, message);
            this.header.addToken(token);
        }
        EncryptedKey eKey = new EncryptedKey(message, secretKey, token, list2);
        this.header.addSecurityProcess(eKey);
    }

    static {
        algorithms.put(DEFAULT_ALGORITHM, new Algorithm("AES", "http://www.w3.org/2001/04/xmlenc#aes128-cbc", 128));
        algorithms.put("aes-192", new Algorithm("AES", "http://www.w3.org/2001/04/xmlenc#aes192-cbc", 192));
        algorithms.put("aes-256", new Algorithm("AES", "http://www.w3.org/2001/04/xmlenc#aes256-cbc", 256));
        algorithms.put("tripledes", new Algorithm("TripleDes", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc", 168));
    }

    private static class Algorithm {
        public String jceName;
        public String xmlName;
        public int size;

        Algorithm(String jceName, String xmlName, int size) {
            this.jceName = jceName;
            this.xmlName = xmlName;
            this.size = size;
        }
    }
}

