/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.activation.DataHandler;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.server.ServerConfig;
import org.jboss.ws.core.server.ServerConfigFactory;

public final class IOUtils {
    private static Logger log = Logger.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static Writer getCharsetFileWriter(File file, String charset) throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);
    }

    public static void copyStream(OutputStream outs, InputStream ins) throws IOException {
        byte[] bytes = new byte[1024];
        int r = ins.read(bytes);
        while (r > 0) {
            outs.write(bytes, 0, r);
            r = ins.read(bytes);
        }
    }

    public static void copyReader(OutputStream outs, Reader reader) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outs);
        char[] bytes = new char[1024];
        int r = reader.read(bytes);
        while (r > 0) {
            writer.write(bytes, 0, r);
            r = reader.read(bytes);
        }
    }

    public static byte[] convertToBytes(DataHandler dh) {
        try {
            ByteArrayOutputStream buffOS = new ByteArrayOutputStream();
            dh.writeTo((OutputStream)buffOS);
            return buffOS.toByteArray();
        }
        catch (IOException e) {
            throw new WSException("Unable to convert DataHandler to byte[]: " + e.getMessage());
        }
    }

    public static InputStream transformReader(Reader reader) throws IOException {
        int capacity = 1024;
        char[] charBuffer = new char[capacity];
        StringBuffer strBuffer = new StringBuffer(capacity);
        int len = reader.read(charBuffer, 0, capacity);
        while (len > 0) {
            strBuffer.append(charBuffer, 0, len);
            len = reader.read(charBuffer, 0, capacity);
        }
        return new ByteArrayInputStream(strBuffer.toString().getBytes());
    }

    public static File createTempDirectory() throws IOException {
        File tmpdir = null;
        try {
            ServerConfigFactory factory = ServerConfigFactory.getInstance();
            ServerConfig config = factory.getServerConfig();
            tmpdir = new File(config.getServerTempDir().getCanonicalPath() + "/jbossws");
            tmpdir.mkdirs();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return tmpdir;
    }
}

