/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.addressing.AddressingProperties;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
import org.jboss.ws.core.server.EndpointContext;
import org.jboss.ws.core.server.PropertyCallback;
import org.jboss.ws.core.server.ServerConfig;
import org.jboss.ws.core.server.ServerConfigFactory;
import org.jboss.ws.core.server.ServiceEndpoint;
import org.jboss.ws.core.server.ServiceEndpointDTO;
import org.jboss.ws.core.server.ServiceEndpointInfo;
import org.jboss.ws.core.server.ServiceEndpointInvoker;
import org.jboss.ws.core.server.ServiceEndpointManagerMBean;
import org.jboss.ws.core.server.ServiceEndpointMetrics;
import org.jboss.ws.core.server.ServletHeaderSource;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.SOAPConnectionImpl;
import org.jboss.ws.core.utils.ThreadLocalAssociation;
import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceEndpointManager
implements ServiceEndpointManagerMBean {
    private static final Logger log = Logger.getLogger(ServiceEndpointManager.class);
    public static final String BEAN_NAME = "ServiceEndpointManager";
    public static String UNDEFINED_HOSTNAME = "jbossws.undefined.host";
    private Map<ObjectName, ServiceEndpoint> registry = new ConcurrentHashMap<ObjectName, ServiceEndpoint>();
    private String webServiceHost = UNDEFINED_HOSTNAME;
    private int webServicePort;
    private int webServiceSecurePort;
    private boolean alwaysModifySOAPAddress;
    private String serviceEndpointInvokerJSE;
    private String serviceEndpointInvokerEJB21;
    private String serviceEndpointInvokerEJB3;
    private String serviceEndpointInvokerMDB;

    @Override
    public String getWebServiceHost() {
        return this.webServiceHost;
    }

    @Override
    public int getWebServicePort() {
        if (this.webServicePort == 0) {
            ServerConfigFactory factory = ServerConfigFactory.getInstance();
            ServerConfig config = factory.getServerConfig();
            this.webServicePort = config.getWebServicePort();
            log.debug("Using WebServicePort: " + this.webServicePort);
        }
        return this.webServicePort;
    }

    @Override
    public int getWebServiceSecurePort() {
        if (this.webServiceSecurePort == 0) {
            ServerConfigFactory factory = ServerConfigFactory.getInstance();
            ServerConfig config = factory.getServerConfig();
            this.webServiceSecurePort = config.getWebServiceSecurePort();
            log.debug("Using WebServiceSecurePort: " + this.webServiceSecurePort);
        }
        return this.webServiceSecurePort;
    }

    @Override
    public boolean isAlwaysModifySOAPAddress() {
        return this.alwaysModifySOAPAddress;
    }

    @Override
    public void setWebServiceHost(String host) throws UnknownHostException {
        if (host == null || host.trim().length() == 0) {
            log.debug("Using undefined host: " + UNDEFINED_HOSTNAME);
            host = UNDEFINED_HOSTNAME;
        }
        if ("0.0.0.0".equals(host)) {
            InetAddress localHost = InetAddress.getLocalHost();
            log.debug("Using local host: " + localHost.getHostName());
            host = localHost.getHostName();
        }
        this.webServiceHost = host;
    }

    @Override
    public void setWebServicePort(int port) {
        this.webServicePort = port;
    }

    @Override
    public void setWebServiceSecurePort(int port) {
        this.webServiceSecurePort = port;
    }

    @Override
    public void setAlwaysModifySOAPAddress(boolean modify) {
        this.alwaysModifySOAPAddress = modify;
    }

    public String getServiceEndpointInvokerEJB21() {
        return this.serviceEndpointInvokerEJB21;
    }

    public void setServiceEndpointInvokerEJB21(String invoker) {
        this.serviceEndpointInvokerEJB21 = invoker;
    }

    public String getServiceEndpointInvokerEJB3() {
        return this.serviceEndpointInvokerEJB3;
    }

    public void setServiceEndpointInvokerEJB3(String invoker) {
        this.serviceEndpointInvokerEJB3 = invoker;
    }

    public String getServiceEndpointInvokerMDB() {
        return this.serviceEndpointInvokerMDB;
    }

    public void setServiceEndpointInvokerMDB(String invoker) {
        this.serviceEndpointInvokerMDB = invoker;
    }

    public String getServiceEndpointInvokerJSE() {
        return this.serviceEndpointInvokerJSE;
    }

    public void setServiceEndpointInvokerJSE(String invoker) {
        this.serviceEndpointInvokerJSE = invoker;
    }

    @Override
    public String getImplementationVersion() {
        return UnifiedMetaData.getImplementationVersion();
    }

    public List<ObjectName> getServiceEndpoints() {
        ArrayList<ObjectName> list2 = new ArrayList<ObjectName>();
        list2.addAll(this.registry.keySet());
        return list2;
    }

    public ServiceEndpoint getServiceEndpointByID(ObjectName sepID) {
        ServiceEndpoint wsEndpoint = this.registry.get(sepID);
        if (wsEndpoint == null) {
            log.warn("No ServiceEndpoint found for serviceID: " + sepID);
        }
        return wsEndpoint;
    }

    public ServiceEndpoint resolvePortComponentLink(String pcLink) {
        String pcName = pcLink;
        int hashIndex = pcLink.indexOf("#");
        if (hashIndex > 0) {
            pcName = pcLink.substring(hashIndex + 1);
        }
        ServiceEndpoint serviceEndpoint = null;
        for (ObjectName sepID : this.registry.keySet()) {
            ServiceEndpoint auxEndpoint = this.registry.get(sepID);
            ServiceEndpointInfo sepInfo = auxEndpoint.getServiceEndpointInfo();
            if (!pcName.equals(sepInfo.getServerEndpointMetaData().getPortComponentName())) continue;
            if (serviceEndpoint != null) {
                log.warn("Multiple service endoints found for: " + pcLink);
                serviceEndpoint = null;
                break;
            }
            serviceEndpoint = auxEndpoint;
        }
        if (serviceEndpoint == null) {
            log.warn("No ServiceEndpoint found for pcLink: " + pcLink);
        }
        return serviceEndpoint;
    }

    public String showServiceEndpointTable(URL requestURL) throws MalformedURLException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<h3>Registered Service Endpoints</h3>");
        pw.println("<table>");
        pw.println("<tr><td>ServiceEndpointID</td><td>ServiceEndpointAddress</td><td>&nbsp;</td></tr>");
        for (Map.Entry<ObjectName, ServiceEndpoint> entry : this.registry.entrySet()) {
            ObjectName sepID = entry.getKey();
            ServiceEndpoint wsEndpoint = entry.getValue();
            ServiceEndpointInfo seInfo = wsEndpoint.getServiceEndpointInfo();
            String displayAddress = this.getDisplayAddress(seInfo, requestURL);
            pw.println("<tr><td>" + sepID.getCanonicalName() + "</td><td><a href='" + displayAddress + "?wsdl'>" + displayAddress + "?wsdl</a></td></tr>");
        }
        pw.println("</table>");
        pw.close();
        return sw.toString();
    }

    public List<ServiceEndpointDTO> getRegisteredEndpoints(URL requestURL) throws MalformedURLException {
        ArrayList<ServiceEndpointDTO> registered = new ArrayList<ServiceEndpointDTO>();
        for (Map.Entry<ObjectName, ServiceEndpoint> entry : this.registry.entrySet()) {
            ObjectName sepID = entry.getKey();
            ServiceEndpoint wsEndpoint = entry.getValue();
            ServiceEndpointInfo seInfo = wsEndpoint.getServiceEndpointInfo();
            String displayAddress = this.getDisplayAddress(seInfo, requestURL);
            try {
                ServiceEndpointDTO dto = new ServiceEndpointDTO();
                dto.setSepID(sepID);
                dto.setAddress(displayAddress);
                dto.setSeMetrics((ServiceEndpointMetrics)wsEndpoint.getServiceEndpointMetrics().clone());
                dto.setState(wsEndpoint.getState());
                registered.add(dto);
            }
            catch (CloneNotSupportedException e) {}
        }
        return registered;
    }

    private String getDisplayAddress(ServiceEndpointInfo seInfo, URL requestURL) throws MalformedURLException {
        String endpointAddress = seInfo.getServerEndpointMetaData().getEndpointAddress();
        URL displayURL = new URL(endpointAddress);
        String endPointPath = displayURL.getPath();
        if (this.getWebServiceHost().equals(UNDEFINED_HOSTNAME)) {
            displayURL = requestURL;
        }
        String displayAddress = displayURL.getProtocol() + "://" + displayURL.getHost() + ":" + displayURL.getPort() + endPointPath;
        return displayAddress;
    }

    public ServiceEndpointMetrics getServiceEndpointMetrics(ObjectName sepID) {
        ServiceEndpoint wsEndpoint = this.getServiceEndpointByID(sepID);
        return wsEndpoint != null ? wsEndpoint.getServiceEndpointMetrics() : null;
    }

    public String showServiceEndpointMetrics(ObjectName sepID) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ServiceEndpointMetrics seMetrics = this.getServiceEndpointMetrics(sepID);
        if (seMetrics != null) {
            pw.println("<h3>Service Endpoint Metrics</h3>");
            pw.println("<table>");
            pw.println("<tr><td>EndpointID</td><td>" + seMetrics.getEndpointID() + "</td></tr>");
            pw.println("<tr><td>Start Time</td><td>" + seMetrics.getStartTime() + "</td></tr>");
            pw.println("<tr><td>Stop Time</td><td>" + seMetrics.getStopTime() + "</td></tr>");
            pw.println("<tr><td>Request Count</td><td>" + seMetrics.getRequestCount() + "</td></tr>");
            pw.println("<tr><td>Response Count</td><td>" + seMetrics.getRequestCount() + "</td></tr>");
            pw.println("<tr><td>Fault Count</td><td>" + seMetrics.getResponseCount() + "</td></tr>");
            pw.println("<tr><td>Max Processing Time</td><td>" + seMetrics.getMaxProcessingTime() + "</td></tr>");
            pw.println("<tr><td>Min Processing Time</td><td>" + seMetrics.getMinProcessingTime() + "</td></tr>");
            pw.println("<tr><td>Avg Processing Time</td><td>" + seMetrics.getAverageProcessingTime() + "</td></tr>");
            pw.println("<tr><td>Total Processing Time</td><td>" + seMetrics.getTotalProcessingTime() + "</td></tr>");
            pw.println("</table>");
            pw.close();
        }
        return sw.toString();
    }

    public void processWSDLRequest(ObjectName sepID, OutputStream outStream, URL requestURL, String resourcePath) throws Exception {
        ServiceEndpoint wsEndpoint = this.getServiceEndpointByID(sepID);
        if (wsEndpoint == null) {
            throw new WSException("Cannot obtain endpoint for: " + sepID);
        }
        wsEndpoint.handleWSDLRequest(outStream, requestURL, resourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(ObjectName sepID, InputStream inStream, OutputStream outStream, EndpointContext context) throws Exception {
        CommonMessageContext msgContext;
        String SESSION_COOKIES = "org.jboss.ws.cookies";
        ServiceEndpoint wsEndpoint = this.getServiceEndpointByID(sepID);
        if (wsEndpoint == null) {
            throw new WSException("Cannot obtain endpoint for: " + sepID);
        }
        ServerEndpointMetaData sepMetaData = wsEndpoint.getServiceEndpointInfo().getServerEndpointMetaData();
        EndpointMetaData.Type type = sepMetaData.getType();
        ServletContext servletContext = context.getServletContext();
        HttpServletRequest httpRequest = context.getHttpServletRequest();
        HttpServletResponse httpResponse = context.getHttpServletResponse();
        ServletHeaderSource headerSource = new ServletHeaderSource(httpRequest, httpResponse);
        HttpSessionPropertyCallback httpSession = new HttpSessionPropertyCallback(context);
        if (type == EndpointMetaData.Type.JAXRPC) {
            msgContext = new SOAPMessageContextJAXRPC();
            msgContext.put("javax.xml.ws.servlet.context", (Object)servletContext);
            msgContext.put("javax.xml.ws.servlet.request", (Object)httpRequest);
            msgContext.put("javax.xml.ws.servlet.response", (Object)httpResponse);
            msgContext.put("javax.xml.ws.servlet.session", (Object)httpSession);
        } else {
            msgContext = new SOAPMessageContextJAXWS();
            msgContext.put("javax.xml.ws.handler.message.outbound", (Object)new Boolean(false));
            msgContext.put("javax.xml.ws.binding.attachments.inbound", (Object)new HashMap());
            msgContext.put("javax.xml.ws.http.request.headers", (Object)headerSource.getHeaderMap());
            msgContext.put("javax.xml.ws.http.request.method", (Object)httpRequest.getMethod());
            msgContext.put("javax.xml.ws.http.request.querystring", (Object)httpRequest.getQueryString());
            msgContext.put("javax.xml.ws.http.request.pathinfo", (Object)httpRequest.getPathInfo());
            msgContext.put("javax.xml.ws.servlet.context", (Object)servletContext);
            msgContext.put("javax.xml.ws.servlet.request", (Object)httpRequest);
            msgContext.put("javax.xml.ws.servlet.response", (Object)httpResponse);
        }
        msgContext.setEndpointMetaData(sepMetaData);
        MessageContextAssociation.pushMessageContext(msgContext);
        try {
            Integer code;
            MessageAbstraction resMessage = wsEndpoint.processRequest(headerSource, context, inStream);
            msgContext = MessageContextAssociation.peekMessageContext();
            Map headers = (Map)msgContext.get("javax.xml.ws.http.response.headers");
            if (headers != null) {
                headerSource.setHeaderMap(headers);
            }
            if ((code = (Integer)msgContext.get("javax.xml.ws.http.response.code")) != null) {
                httpResponse.setStatus(code.intValue());
            }
            boolean isFault = false;
            if (resMessage instanceof SOAPMessage) {
                SOAPPart part = ((SOAPMessage)resMessage).getSOAPPart();
                if (part == null) {
                    throw new SOAPException("Cannot obtain SOAPPart from response message");
                }
                SOAPEnvelope soapEnv = part.getEnvelope();
                boolean bl = isFault = soapEnv != null && soapEnv.getBody().hasFault();
                if (isFault && httpResponse != null) {
                    httpResponse.setStatus(500);
                }
            }
            this.sendResponse(outStream, msgContext, isFault);
        }
        finally {
            outStream.flush();
            outStream.close();
            MessageContextAssociation.popMessageContext();
            ThreadLocalAssociation.clear();
        }
    }

    private void sendResponse(OutputStream outputStream, CommonMessageContext msgContext, boolean isFault) throws SOAPException, IOException {
        MessageAbstraction resMessage = msgContext.getMessageAbstraction();
        String wsaTo = null;
        AddressingProperties outProps = (AddressingProperties)msgContext.get("javax.xml.ws.addressing.context.outbound");
        if (outProps != null && outProps.getTo() != null) {
            AddressingConstantsImpl ADDR = new AddressingConstantsImpl();
            wsaTo = outProps.getTo().getURI().toString();
            if (wsaTo.equals(ADDR.getAnonymousURI())) {
                wsaTo = null;
            }
        }
        if (wsaTo != null) {
            log.debug("Sending response to addressing destination: " + wsaTo);
            new SOAPConnectionImpl().callOneWay((SOAPMessage)resMessage, wsaTo);
        } else {
            resMessage.writeTo(outputStream);
        }
    }

    public String processRequest(ObjectName sepID, String inMessage) throws Exception {
        log.debug("processSOAPRequest: " + sepID);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(inMessage.getBytes("UTF-8"));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(512);
        this.processRequest(sepID, inputStream, outputStream, null);
        String outMsg = new String(outputStream.toByteArray());
        return outMsg;
    }

    private ServiceEndpointInvoker getServiceEndpointInvoker(ServiceEndpointInfo seInfo) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ServiceEndpointInvoker seInvoker = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (seInfo.getType() == ServiceEndpointInfo.EndpointType.JSE) {
            Class<?> seInvokerClass = cl.loadClass(this.serviceEndpointInvokerJSE);
            seInvoker = (ServiceEndpointInvoker)seInvokerClass.newInstance();
        } else if (seInfo.getType() == ServiceEndpointInfo.EndpointType.SLSB21) {
            Class<?> seInvokerClass = cl.loadClass(this.serviceEndpointInvokerEJB21);
            seInvoker = (ServiceEndpointInvoker)seInvokerClass.newInstance();
        } else if (seInfo.getType() == ServiceEndpointInfo.EndpointType.SLSB30) {
            Class<?> seInvokerClass = cl.loadClass(this.serviceEndpointInvokerEJB3);
            seInvoker = (ServiceEndpointInvoker)seInvokerClass.newInstance();
        } else if (seInfo.getType() == ServiceEndpointInfo.EndpointType.MDB21) {
            Class<?> seInvokerClass = cl.loadClass(this.serviceEndpointInvokerMDB);
            seInvoker = (ServiceEndpointInvoker)seInvokerClass.newInstance();
        }
        if (seInvoker == null) {
            throw new WSException("Cannot obtain service endpoint invoker");
        }
        return seInvoker;
    }

    @Override
    public List<HandlerMetaData> getHandlerMetaData(ObjectName sepID) {
        ServiceEndpoint wsEndpoint = this.getServiceEndpointByID(sepID);
        if (wsEndpoint == null) {
            throw new WSException("Cannot find service endpoint: " + sepID);
        }
        List<HandlerMetaData> handlers = null;
        if (wsEndpoint != null) {
            ServerEndpointMetaData sepMetaData = wsEndpoint.getServiceEndpointInfo().getServerEndpointMetaData();
            handlers = sepMetaData.getHandlerMetaData(HandlerMetaData.HandlerType.ALL);
        }
        return handlers;
    }

    @Override
    public void setHandlerMetaData(ObjectName sepID, List<HandlerMetaData> handlers) {
        ServiceEndpoint wsEndpoint = this.getServiceEndpointByID(sepID);
        if (wsEndpoint == null) {
            throw new WSException("Cannot find service endpoint: " + sepID);
        }
        ServiceEndpointInfo sepInfo = wsEndpoint.getServiceEndpointInfo();
        if (sepInfo.getState() != ServiceEndpoint.State.STOPED) {
            throw new WSException("Endpoint expected to be in STOPED state");
        }
        ServerEndpointMetaData sepMetaData = wsEndpoint.getServiceEndpointInfo().getServerEndpointMetaData();
        sepMetaData.clearHandlers();
        for (HandlerMetaData handlerMetaData : handlers) {
            handlerMetaData.setEndpointMetaData(sepMetaData);
            sepMetaData.addHandler(handlerMetaData);
        }
    }

    public void createServiceEndpoint(ServiceEndpointInfo seInfo) throws Exception {
        ObjectName sepID = seInfo.getServiceEndpointID();
        if (this.registry.get(sepID) != null) {
            throw new WSException("Service already registerd: " + sepID);
        }
        ServiceEndpointInvoker seInvoker = this.getServiceEndpointInvoker(seInfo);
        seInvoker.init(seInfo);
        seInfo.setInvoker(seInvoker);
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        ServerEndpointMetaData epMetaData = seInfo.getServerEndpointMetaData();
        String managedEndpointBean = epMetaData.getManagedEndpointBean();
        Class<?> seClass = ctxLoader.loadClass(managedEndpointBean);
        Constructor<?> ctor = seClass.getConstructor(ServiceEndpointInfo.class);
        ServiceEndpoint wsEndpoint = (ServiceEndpoint)ctor.newInstance(seInfo);
        wsEndpoint.create();
        this.registry.put(sepID, wsEndpoint);
        log.debug("WebService created: " + sepID);
    }

    @Override
    public void startServiceEndpoint(ObjectName sepID) throws Exception {
        ServiceEndpoint wsEndpoint = this.getServiceEndpointByID(sepID);
        if (wsEndpoint == null) {
            throw new WSException("Cannot find service endpoint: " + sepID);
        }
        wsEndpoint.start();
        ServiceEndpointInfo seInfo = wsEndpoint.getServiceEndpointInfo();
        log.info("WebService started: " + seInfo.getServerEndpointMetaData().getEndpointAddress());
    }

    @Override
    public void stopServiceEndpoint(ObjectName sepID) throws Exception {
        ServiceEndpoint wsEndpoint = this.getServiceEndpointByID(sepID);
        if (wsEndpoint == null) {
            log.error("Cannot find service endpoint: " + sepID);
            return;
        }
        wsEndpoint.stop();
        ServiceEndpointInfo seInfo = wsEndpoint.getServiceEndpointInfo();
        log.info("WebService stopped: " + seInfo.getServerEndpointMetaData().getEndpointAddress());
    }

    public void destroyServiceEndpoint(ObjectName sepID) throws Exception {
        ServiceEndpoint wsEndpoint = this.getServiceEndpointByID(sepID);
        if (wsEndpoint == null) {
            log.error("Cannot find service endpoint: " + sepID);
            return;
        }
        wsEndpoint.destroy();
        this.registry.remove(sepID);
        ServiceEndpointInfo seInfo = wsEndpoint.getServiceEndpointInfo();
        log.debug("WebService destroyed: " + seInfo.getServerEndpointMetaData().getEndpointAddress());
    }

    public void create() throws Exception {
        log.info(this.getImplementationVersion());
        MBeanServer server = this.getJMXServer();
        if (server != null) {
            server.registerMBean(this, OBJECT_NAME);
        }
    }

    public void destroy() throws Exception {
        log.debug("Destroy service endpoint manager");
        MBeanServer server = this.getJMXServer();
        if (server != null) {
            server.unregisterMBean(OBJECT_NAME);
        }
    }

    private MBeanServer getJMXServer() {
        MBeanServer server = null;
        ArrayList servers = MBeanServerFactory.findMBeanServer(null);
        if (servers.size() > 0) {
            server = (MBeanServer)servers.get(0);
        }
        return server;
    }

    public static class HttpSessionPropertyCallback
    implements PropertyCallback {
        private EndpointContext context;

        public HttpSessionPropertyCallback(EndpointContext context) {
            this.context = context;
        }

        public Object get() {
            return this.context.getHttpSession();
        }
    }
}

