/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.client;

import java.io.IOException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import org.jboss.ws.WSException;
import org.jboss.ws.core.ConfigProvider;
import org.jboss.ws.core.StubExt;
import org.jboss.ws.integration.UnifiedVirtualFile;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceExt
extends Service
implements ConfigProvider {
    private String configName;
    private String configFile;
    private String securityConfig;

    public ServiceExt(URL wsdlDocumentLocation, QName serviceName) {
        super(wsdlDocumentLocation, serviceName);
    }

    @Override
    public String getConfigFile() {
        return this.configFile;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public void setConfigName(String configName) {
        this.configName = configName;
    }

    @Override
    public void setConfigName(String configName, String configFile) {
        this.configName = configName;
        this.configFile = configFile;
    }

    public String getSecurityConfig() {
        return this.securityConfig;
    }

    public void setSecurityConfig(String securityConfig) {
        this.securityConfig = securityConfig;
    }

    @Override
    public <T> T getPort(Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        T port = super.getPort(serviceEndpointInterface, features);
        this.configurePort(port);
        return port;
    }

    @Override
    public <T> T getPort(Class<T> serviceEndpointInterface) {
        T port = super.getPort(serviceEndpointInterface);
        this.configurePort(port);
        return port;
    }

    @Override
    public <T> T getPort(EndpointReference endpointReference, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        T port = super.getPort(endpointReference, serviceEndpointInterface, features);
        this.configurePort(port);
        return port;
    }

    @Override
    public <T> T getPort(QName portName, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        T port = super.getPort(portName, serviceEndpointInterface, features);
        this.configurePort(port);
        return port;
    }

    @Override
    public <T> T getPort(QName portName, Class<T> serviceEndpointInterface) {
        T port = super.getPort(portName, serviceEndpointInterface);
        this.configurePort(port);
        return port;
    }

    private void configurePort(Object port) {
        EndpointMetaData epMetaData;
        ServiceMetaData serviceMetaData;
        ConfigProvider cp = (ConfigProvider)port;
        if (this.configName != null || this.configFile != null) {
            cp.setConfigName(this.configName, this.configFile);
        }
        if (this.securityConfig != null && (serviceMetaData = (epMetaData = ((StubExt)port).getEndpointMetaData()).getServiceMetaData()).getSecurityConfiguration() == null) {
            try {
                WSSecurityConfigFactory wsseConfFactory = WSSecurityConfigFactory.newInstance();
                UnifiedVirtualFile vfsRoot = serviceMetaData.getUnifiedMetaData().getRootFile();
                WSSecurityConfiguration config = wsseConfFactory.createConfiguration(vfsRoot, this.securityConfig);
                serviceMetaData.setSecurityConfiguration(config);
            }
            catch (IOException ex) {
                WSException.rethrow("Cannot set security config", ex);
            }
        }
    }
}

