/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.xml.ws.WebServiceContext;
import org.jboss.logging.Logger;

public class WebServiceContextInjector {
    private static Logger log = Logger.getLogger(WebServiceContextInjector.class);

    public void injectContext(Object epInstance, WebServiceContext wsContext) {
        try {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = epInstance.getClass().getDeclaredFields()) {
                Class<?> type = field.getType();
                if (type != WebServiceContext.class || !field.isAnnotationPresent(Resource.class)) continue;
                field.setAccessible(true);
                field.set(epInstance, wsContext);
            }
            for (Method method : methods = epInstance.getClass().getDeclaredMethods()) {
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes.length != 1 || paramTypes[0] != WebServiceContext.class || !method.isAnnotationPresent(Resource.class)) continue;
                method.setAccessible(true);
                method.invoke(epInstance, wsContext);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            log.warn("Cannot inject WebServiceContext", ex);
        }
    }
}

